#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <tchar.h>

#define SECURITY_WIN32

extern "C" {
#include "sspi.h"
};

int main(int argc, char **argv)
{
	PCredHandle phand;
	SECURITY_STATUS ret;
	HINSTANCE li = LoadLibrary("security.dll");
	PSecurityFunctionTable psft;
	PSecurityFunctionTable (*pfn)(void);

	pfn = (PSecurityFunctionTable (*)(void))GetProcAddress(li,SECURITY_ENTRYPOINT);
	psft = (*pfn)();

	ULONG npack;
	PSecPkgInfo ppinfo;
	ret = (psft->EnumerateSecurityPackages)(&npack,&ppinfo);
	printf("EnumerateSecurityPackages: ret = %x\n", ret);

	PTimeStamp ptimestamp;	
	ret = (psft->AcquireCredentialsHandle)(
			"Duwamp",
			"NTLM",
			SECPKG_CRED_BOTH,
			NULL,
			NULL,
			NULL,
			NULL,
			phand,
			ptimestamp);

	printf("AcquireCredentialsHandle: ret = %x\n", ret);

	PCtxtHandle pnew;
	PSecBufferDesc pout;
	
	SecBufferDesc bufdesc;

	bufdesc.ulVersion =	SECBUFFER_VERSION;
	bufdesc.cBuffers = 0;
	bufdesc.pBuffers = NULL;

	ret = (psft->InitializeSecurityContext)(
		phand,
		NULL,
		"SYS-PORTLAB",
		ISC_REQ_USE_SUPPLIED_CREDS|ISC_REQ_ALLOCATE_MEMORY,
		0,
		SECURITY_NATIVE_DREP,
		&bufdesc, // IN	PSecBufferDesc	pInput,
		0,
		pnew, // OUT	PCtxtHandle	phNewContext,
		pout, // INOUT	PSecBufferDesc	pOutput,
		&npack, // OUT	PULONG	pfContextAttributes,
		ptimestamp); // OUT	PTimeStamp	ptsExpiry)

	printf("InitializeSecurityContext: ret = %x\n", ret);

}
