#ifndef _SIDOBJ_H_
#define _SIDOBJ_H_

/*
    Windows NT Security functions library.
    Copyright (C) 1995  Jeremy R. Allison

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Log: sidobj.h,v $
 * Revision 1.2  1995/07/05  23:47:37  jra
 * Added operator const casts.
 *
 * Revision 1.1  1995/06/30  18:32:55  jra
 * Initial revision
 *^M
*/

#include <windows.h>
#include <tchar.h>

class SIDobj {
private:

	// Private class used by SIDobj to hold SID information.
	class SIDinfo {
	private:
		TCHAR *name_;
		TCHAR *domain_;
		SID_NAME_USE type_;
		DWORD refcnt_;

		~SIDinfo(); // Can only be called by deleteRef().

		SIDinfo(const SIDinfo& ); // Not defined - no copying.
		SIDinfo& operator=(const SIDinfo& ); // Not defined - no copying.

	public:
		SIDinfo(const SID *psid, const TCHAR *mach = 0);
		SIDinfo *addRef() { refcnt_++; return this; }
		void deleteRef() { if(--refcnt_ == 0) delete this; }
		const TCHAR *getName() const { return name_; }
		const TCHAR *getDomain() const { return domain_; }
		SID_NAME_USE getType() const { return type_; };
	};

	SIDinfo *psidinfo_;	// Shared among all similar SIDobj's
	TCHAR *mach_lookup_; // Machine to lookup SID information on.
	SID *psid_;

	// Utility functions.
	BOOL copySid(const SID *);
	BOOL deepcopy(const SIDobj& );
	BOOL validSIDinfo();

	SIDobj& operator=( const SIDobj& );

public:

	// Public constructors.
	SIDobj(PSID_IDENTIFIER_AUTHORITY pia, BYTE cnt, DWORD s1, 
				DWORD s2 = 0, DWORD s3 = 0, DWORD s4 = 0,
				DWORD s5 = 0, DWORD s6 = 0, DWORD s7 = 0, DWORD s8 = 0);
	SIDobj(const SID *);
	SIDobj(const TCHAR *name, const TCHAR *mach);

	BOOL CopyIntoSIDobj(SIDobj *dest);
	 
	~SIDobj() { 
		delete [] psid_;
		if(psidinfo_) 
			psidinfo_->deleteRef();
		delete [] mach_lookup_; 
	}
	SIDobj( const SIDobj& );
	int operator==( const SIDobj& );

	int sidSize() const { return GetLengthSid(psid_); }
	operator const SID *() const { return psid_; }
	operator SID *() const { return psid_; }
	operator const PSID () const { return (PSID)psid_; }
	operator PSID () const { return (PSID)psid_; }
	SID *getSid() const { return psid_; }

	BOOL setLookupMachine(const TCHAR *mach);
	BOOL getUserName(TCHAR **, DWORD *);
	BOOL getUserDomain(TCHAR **, DWORD *);
	BOOL getUserType(SID_NAME_USE *);
};

#endif
