#include "list.h"

/*
     $Log: list.cpp,v $
// Revision 1.1  1995/06/30  18:32:55  jra
// Initial revision
//^M
*/

//
// Deepcopy - copies all elements of a list
//
template <class Item>
void List<Item>::deepcopy(const List<Item>& l) {
	if( &l != this) {
		RemoveAll();
		// TODO : Replace this with an iterator....
		ListIterator<Item> iter(&l);
		for(; !iter.Done(); iter.Next() ) {
			Insert(iter.Get());
		}
	}
}

//
// Get an Item at a specified index
//
template <class Item>
Item& List<Item>::Get(unsigned long index) const {
	unsigned long i;

	assert(index < count_);

	ListItem<Item> *p = head_;
	for( i = 0; i < index; i++, p = p->next_)
		;
	return p->i_;
}

//
// Check if a List includes a particular Item
// Returns index of item if found and returns 1
// Returns 0 if not found.
//
template <class Item>
bool List<Item>::Includes(const Item& it, unsigned long *pos) const {
	unsigned long i;

	ListItem<Item> *p = head_;
	for( i = 0; i < count_; i++, p = p->next_)
		if( p->i_ == it) {
			*pos = i;
			return 1;
		}
    return 0;
}

//
// Insert an Item into the doubly linked list
//
template <class Item>
unsigned long List<Item>::Insert( const Item& it) {
	ListItem<Item> *li = new ListItem<Item>(it);

	assert( li != 0);

	li->next_ = head_;
	li->prev_ = 0;
	if(head_ != 0)
		head_->prev_ = li;
	if(0 == tail_)
		tail_ = li;

	head_ = li;
	count_++;
	return 0;
}

//
// Remove a particular item from the list
//
template <class Item>
bool List<Item>::Remove(const Item& it) {
	unsigned long pos;

	if(!Includes(it, &pos))
		return 1;
	RemoveAt(pos);
	return 0;
}

//
// Remove an item at a particular position in the list.
//
template <class Item>
void List<Item>::RemoveAt(unsigned long index) {
	assert(index < count_);
	ListItem<Item> *p = head_;
	ListItem<Item> *last = 0;

	unsigned long i;
	for( i = 0; i < index; i++) {
		last = p;
		p = p->next_;
	}

	if(p == head_)
		head_ = p->next_;
	if(p->next_) {
		// Correct backlink
		p->next_->prev_ = last;
		if(last)
			last->next_ = p->next_;
	} else {
		// End of chain, link to tail_
		tail_ = last;
	}
	delete p;
	count_--;
}

//
// Remove the last item in the list
//
template <class Item>
void List<Item>::RemoveLast() {
	assert(count_ > 0);
	ListItem<Item> *last = tail_;
	tail_ = last->prev_;
	delete last;
	if(tail_ == 0)
		head_ = 0;
	count_--;
}

//
// Remove the first item in the list
//
template <class Item>
void List<Item>::RemoveFirst() {
	assert(count_ > 0);
	ListItem<Item> *first = head_;
	head_ = first->next_;
	delete first;
	if(head_ == 0)
		tail_ = 0;
	count_--;
}

//
// Remove everything in the list
//
template <class Item>
void List<Item>::RemoveAll() {
	ListItem<Item> *p, *last;

	for( p = head_; p; count_--) {
		last = p;
		p = p->next_;
		delete last;
	}
	head_ = tail_ = 0;
}
