#ifndef _AUTOHEAP_H_
#define _AUTOHEAP_H_

/*
	This code is adapted from the autoheap code in
	the book C++ FAQ's.

    $Log: autoheap.h,v $
 * Revision 1.1  1995/06/30  18:32:55  jra
 * Initial revision
 *^M
*/

#include <assert.h>

//
// Class to cope with automatic deletion of anonymous 
// memory (char *) when it goes out of scope.
//
class autoHeapChar {
private:
	char *ptr_;

	autoHeapChar& operator=(const char *);
	autoHeapChar( const autoHeapChar& );

public:

	autoHeapChar(char *ptr = 0) :ptr_(ptr) { }
	~autoHeapChar()		                   { deallocate(); }
	void deallocate()                      { delete [] ptr_; ptr_ = 0; }
	autoHeapChar& operator=(char *ptr)
		{ deallocate(); ptr_ = ptr; return *this; }

	operator char *() { assert(ptr_ != 0); return ptr_; }
	char &operator*()  { assert(ptr_ != 0); return *ptr_; }

	char *relinquishOwnership()
		{ char *old = ptr_; ptr_ = 0; return old; }
	char *getPtr() const { return ptr_; }
};

//
// Template version of the same class.
//
template <class T>
class autoHeapPtr {
private:

	T *ptr_;
	autoHeapPtr<T>& operator=(const autoHeapPtr<T> &);
	autoHeapPtr( const autoHeapPtr<T>& );

public:

	autoHeapPtr(T *ptr = 0) :ptr_(ptr)     { }
	~autoHeapPtr()		                   { deallocate(); }
	void deallocate()                      { delete ptr_; ptr_ = 0; }
	autoHeapPtr<T>& operator=( T *ptr)
		{ deallocate(); ptr_ = ptr; return *this; }

	T *operator->() { assert(ptr_ != 0); return ptr_; }
	T &operator*()  { assert(ptr_ != 0); return *ptr_; }

	T *getPtr() const { return ptr_; }

	T *relinquishOwnership()
		{ T *old = ptr_; ptr_ = 0; return old; }
};
	
#endif
