/*
 * Unix SMB/CIFS implementation.
 * client auto-generated by pidl. DO NOT MODIFY!
 */

#include "includes.h"
#include "librpc/gen_ndr/cli_ntsvcs.h"

NTSTATUS rpccli_PNP_Disconnect(struct rpc_pipe_client *cli,
			       TALLOC_CTX *mem_ctx,
			       WERROR *werror)
{
	struct PNP_Disconnect r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PNP_Disconnect, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_ntsvcs,
				NDR_PNP_DISCONNECT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PNP_Disconnect, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PNP_Connect(struct rpc_pipe_client *cli,
			    TALLOC_CTX *mem_ctx,
			    WERROR *werror)
{
	struct PNP_Connect r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PNP_Connect, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_ntsvcs,
				NDR_PNP_CONNECT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PNP_Connect, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PNP_GetVersion(struct rpc_pipe_client *cli,
			       TALLOC_CTX *mem_ctx,
			       uint16_t *version /* [out] [ref] */,
			       WERROR *werror)
{
	struct PNP_GetVersion r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PNP_GetVersion, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_ntsvcs,
				NDR_PNP_GETVERSION,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PNP_GetVersion, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*version = *r.out.version;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PNP_GetGlobalState(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   WERROR *werror)
{
	struct PNP_GetGlobalState r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PNP_GetGlobalState, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_ntsvcs,
				NDR_PNP_GETGLOBALSTATE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PNP_GetGlobalState, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PNP_InitDetection(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  WERROR *werror)
{
	struct PNP_InitDetection r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PNP_InitDetection, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_ntsvcs,
				NDR_PNP_INITDETECTION,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PNP_InitDetection, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PNP_ReportLogOn(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				WERROR *werror)
{
	struct PNP_ReportLogOn r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PNP_ReportLogOn, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_ntsvcs,
				NDR_PNP_REPORTLOGON,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PNP_ReportLogOn, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PNP_ValidateDeviceInstance(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx,
					   const char *devicepath /* [in] [ref,charset(UTF16)] */,
					   uint32_t flags /* [in]  */,
					   WERROR *werror)
{
	struct PNP_ValidateDeviceInstance r;
	NTSTATUS status;

	/* In parameters */
	r.in.devicepath = devicepath;
	r.in.flags = flags;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PNP_ValidateDeviceInstance, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_ntsvcs,
				NDR_PNP_VALIDATEDEVICEINSTANCE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PNP_ValidateDeviceInstance, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PNP_GetRootDeviceInstance(struct rpc_pipe_client *cli,
					  TALLOC_CTX *mem_ctx,
					  WERROR *werror)
{
	struct PNP_GetRootDeviceInstance r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PNP_GetRootDeviceInstance, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_ntsvcs,
				NDR_PNP_GETROOTDEVICEINSTANCE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PNP_GetRootDeviceInstance, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PNP_GetRelatedDeviceInstance(struct rpc_pipe_client *cli,
					     TALLOC_CTX *mem_ctx,
					     WERROR *werror)
{
	struct PNP_GetRelatedDeviceInstance r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PNP_GetRelatedDeviceInstance, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_ntsvcs,
				NDR_PNP_GETRELATEDDEVICEINSTANCE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PNP_GetRelatedDeviceInstance, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PNP_EnumerateSubKeys(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     WERROR *werror)
{
	struct PNP_EnumerateSubKeys r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PNP_EnumerateSubKeys, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_ntsvcs,
				NDR_PNP_ENUMERATESUBKEYS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PNP_EnumerateSubKeys, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PNP_GetDeviceList(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  WERROR *werror)
{
	struct PNP_GetDeviceList r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PNP_GetDeviceList, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_ntsvcs,
				NDR_PNP_GETDEVICELIST,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PNP_GetDeviceList, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PNP_GetDeviceListSize(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx,
				      const char *devicename /* [in] [unique,charset(UTF16)] */,
				      uint32_t *size /* [out] [ref] */,
				      uint32_t flags /* [in]  */,
				      WERROR *werror)
{
	struct PNP_GetDeviceListSize r;
	NTSTATUS status;

	/* In parameters */
	r.in.devicename = devicename;
	r.in.flags = flags;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PNP_GetDeviceListSize, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_ntsvcs,
				NDR_PNP_GETDEVICELISTSIZE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PNP_GetDeviceListSize, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*size = *r.out.size;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PNP_GetDepth(struct rpc_pipe_client *cli,
			     TALLOC_CTX *mem_ctx,
			     WERROR *werror)
{
	struct PNP_GetDepth r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PNP_GetDepth, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_ntsvcs,
				NDR_PNP_GETDEPTH,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PNP_GetDepth, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PNP_GetDeviceRegProp(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     const char *devicepath /* [in] [ref,charset(UTF16)] */,
				     uint32_t property /* [in]  */,
				     uint32_t *unknown1 /* [in,out] [ref] */,
				     uint8_t *buffer /* [out] [ref,length_is(*buffer_size),size_is(*buffer_size)] */,
				     uint32_t *buffer_size /* [in,out] [ref] */,
				     uint32_t *needed /* [in,out] [ref] */,
				     uint32_t unknown3 /* [in]  */,
				     WERROR *werror)
{
	struct PNP_GetDeviceRegProp r;
	NTSTATUS status;

	/* In parameters */
	r.in.devicepath = devicepath;
	r.in.property = property;
	r.in.unknown1 = unknown1;
	r.in.buffer_size = buffer_size;
	r.in.needed = needed;
	r.in.unknown3 = unknown3;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PNP_GetDeviceRegProp, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_ntsvcs,
				NDR_PNP_GETDEVICEREGPROP,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PNP_GetDeviceRegProp, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*unknown1 = *r.out.unknown1;
	memcpy(buffer, r.out.buffer, *r.in.buffer_size * sizeof(*buffer));
	*buffer_size = *r.out.buffer_size;
	*needed = *r.out.needed;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PNP_SetDeviceRegProp(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     WERROR *werror)
{
	struct PNP_SetDeviceRegProp r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PNP_SetDeviceRegProp, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_ntsvcs,
				NDR_PNP_SETDEVICEREGPROP,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PNP_SetDeviceRegProp, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PNP_GetClassInstance(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     WERROR *werror)
{
	struct PNP_GetClassInstance r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PNP_GetClassInstance, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_ntsvcs,
				NDR_PNP_GETCLASSINSTANCE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PNP_GetClassInstance, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PNP_CreateKey(struct rpc_pipe_client *cli,
			      TALLOC_CTX *mem_ctx,
			      WERROR *werror)
{
	struct PNP_CreateKey r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PNP_CreateKey, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_ntsvcs,
				NDR_PNP_CREATEKEY,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PNP_CreateKey, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PNP_DeleteRegistryKey(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx,
				      WERROR *werror)
{
	struct PNP_DeleteRegistryKey r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PNP_DeleteRegistryKey, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_ntsvcs,
				NDR_PNP_DELETEREGISTRYKEY,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PNP_DeleteRegistryKey, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PNP_GetClassCount(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  WERROR *werror)
{
	struct PNP_GetClassCount r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PNP_GetClassCount, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_ntsvcs,
				NDR_PNP_GETCLASSCOUNT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PNP_GetClassCount, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PNP_GetClassName(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 WERROR *werror)
{
	struct PNP_GetClassName r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PNP_GetClassName, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_ntsvcs,
				NDR_PNP_GETCLASSNAME,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PNP_GetClassName, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PNP_DeleteClassKey(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   WERROR *werror)
{
	struct PNP_DeleteClassKey r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PNP_DeleteClassKey, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_ntsvcs,
				NDR_PNP_DELETECLASSKEY,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PNP_DeleteClassKey, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PNP_GetInterfaceDeviceAlias(struct rpc_pipe_client *cli,
					    TALLOC_CTX *mem_ctx,
					    WERROR *werror)
{
	struct PNP_GetInterfaceDeviceAlias r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PNP_GetInterfaceDeviceAlias, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_ntsvcs,
				NDR_PNP_GETINTERFACEDEVICEALIAS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PNP_GetInterfaceDeviceAlias, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PNP_GetInterfaceDeviceList(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx,
					   WERROR *werror)
{
	struct PNP_GetInterfaceDeviceList r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PNP_GetInterfaceDeviceList, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_ntsvcs,
				NDR_PNP_GETINTERFACEDEVICELIST,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PNP_GetInterfaceDeviceList, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PNP_GetInterfaceDeviceListSize(struct rpc_pipe_client *cli,
					       TALLOC_CTX *mem_ctx,
					       WERROR *werror)
{
	struct PNP_GetInterfaceDeviceListSize r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PNP_GetInterfaceDeviceListSize, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_ntsvcs,
				NDR_PNP_GETINTERFACEDEVICELISTSIZE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PNP_GetInterfaceDeviceListSize, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PNP_RegisterDeviceClassAssociation(struct rpc_pipe_client *cli,
						   TALLOC_CTX *mem_ctx,
						   WERROR *werror)
{
	struct PNP_RegisterDeviceClassAssociation r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PNP_RegisterDeviceClassAssociation, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_ntsvcs,
				NDR_PNP_REGISTERDEVICECLASSASSOCIATION,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PNP_RegisterDeviceClassAssociation, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PNP_UnregisterDeviceClassAssociation(struct rpc_pipe_client *cli,
						     TALLOC_CTX *mem_ctx,
						     WERROR *werror)
{
	struct PNP_UnregisterDeviceClassAssociation r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PNP_UnregisterDeviceClassAssociation, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_ntsvcs,
				NDR_PNP_UNREGISTERDEVICECLASSASSOCIATION,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PNP_UnregisterDeviceClassAssociation, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PNP_GetClassRegProp(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    WERROR *werror)
{
	struct PNP_GetClassRegProp r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PNP_GetClassRegProp, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_ntsvcs,
				NDR_PNP_GETCLASSREGPROP,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PNP_GetClassRegProp, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PNP_SetClassRegProp(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    WERROR *werror)
{
	struct PNP_SetClassRegProp r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PNP_SetClassRegProp, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_ntsvcs,
				NDR_PNP_SETCLASSREGPROP,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PNP_SetClassRegProp, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PNP_CreateDevInst(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  WERROR *werror)
{
	struct PNP_CreateDevInst r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PNP_CreateDevInst, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_ntsvcs,
				NDR_PNP_CREATEDEVINST,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PNP_CreateDevInst, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PNP_DeviceInstanceAction(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 WERROR *werror)
{
	struct PNP_DeviceInstanceAction r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PNP_DeviceInstanceAction, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_ntsvcs,
				NDR_PNP_DEVICEINSTANCEACTION,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PNP_DeviceInstanceAction, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PNP_GetDeviceStatus(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    WERROR *werror)
{
	struct PNP_GetDeviceStatus r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PNP_GetDeviceStatus, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_ntsvcs,
				NDR_PNP_GETDEVICESTATUS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PNP_GetDeviceStatus, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PNP_SetDeviceProblem(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     WERROR *werror)
{
	struct PNP_SetDeviceProblem r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PNP_SetDeviceProblem, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_ntsvcs,
				NDR_PNP_SETDEVICEPROBLEM,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PNP_SetDeviceProblem, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PNP_DisableDevInst(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   WERROR *werror)
{
	struct PNP_DisableDevInst r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PNP_DisableDevInst, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_ntsvcs,
				NDR_PNP_DISABLEDEVINST,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PNP_DisableDevInst, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PNP_UninstallDevInst(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     WERROR *werror)
{
	struct PNP_UninstallDevInst r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PNP_UninstallDevInst, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_ntsvcs,
				NDR_PNP_UNINSTALLDEVINST,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PNP_UninstallDevInst, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PNP_AddID(struct rpc_pipe_client *cli,
			  TALLOC_CTX *mem_ctx,
			  WERROR *werror)
{
	struct PNP_AddID r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PNP_AddID, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_ntsvcs,
				NDR_PNP_ADDID,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PNP_AddID, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PNP_RegisterDriver(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   WERROR *werror)
{
	struct PNP_RegisterDriver r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PNP_RegisterDriver, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_ntsvcs,
				NDR_PNP_REGISTERDRIVER,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PNP_RegisterDriver, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PNP_QueryRemove(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				WERROR *werror)
{
	struct PNP_QueryRemove r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PNP_QueryRemove, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_ntsvcs,
				NDR_PNP_QUERYREMOVE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PNP_QueryRemove, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PNP_RequestDeviceEject(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       WERROR *werror)
{
	struct PNP_RequestDeviceEject r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PNP_RequestDeviceEject, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_ntsvcs,
				NDR_PNP_REQUESTDEVICEEJECT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PNP_RequestDeviceEject, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PNP_IsDockStationPresent(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 WERROR *werror)
{
	struct PNP_IsDockStationPresent r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PNP_IsDockStationPresent, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_ntsvcs,
				NDR_PNP_ISDOCKSTATIONPRESENT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PNP_IsDockStationPresent, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PNP_RequestEjectPC(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   WERROR *werror)
{
	struct PNP_RequestEjectPC r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PNP_RequestEjectPC, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_ntsvcs,
				NDR_PNP_REQUESTEJECTPC,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PNP_RequestEjectPC, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PNP_HwProfFlags(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				uint32_t unknown1 /* [in]  */,
				const char *devicepath /* [in] [ref,charset(UTF16)] */,
				uint32_t unknown2 /* [in]  */,
				uint32_t *unknown3 /* [in,out] [ref] */,
				uint16_t *unknown4 /* [in,out] [unique] */,
				const char *unknown5 /* [in] [unique,charset(UTF16)] */,
				const char **unknown5a /* [out] [unique,charset(UTF16)] */,
				uint32_t unknown6 /* [in]  */,
				uint32_t unknown7 /* [in]  */,
				WERROR *werror)
{
	struct PNP_HwProfFlags r;
	NTSTATUS status;

	/* In parameters */
	r.in.unknown1 = unknown1;
	r.in.devicepath = devicepath;
	r.in.unknown2 = unknown2;
	r.in.unknown3 = unknown3;
	r.in.unknown4 = unknown4;
	r.in.unknown5 = unknown5;
	r.in.unknown6 = unknown6;
	r.in.unknown7 = unknown7;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PNP_HwProfFlags, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_ntsvcs,
				NDR_PNP_HWPROFFLAGS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PNP_HwProfFlags, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*unknown3 = *r.out.unknown3;
	if (unknown4 && r.out.unknown4) {
		*unknown4 = *r.out.unknown4;
	}
	if (unknown5a && r.out.unknown5a) {
		*unknown5a = *r.out.unknown5a;
	}

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PNP_GetHwProfInfo(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  uint32_t idx /* [in]  */,
				  struct PNP_HwProfInfo *info /* [in,out] [ref] */,
				  uint32_t size /* [in]  */,
				  uint32_t flags /* [in]  */,
				  WERROR *werror)
{
	struct PNP_GetHwProfInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.idx = idx;
	r.in.info = info;
	r.in.size = size;
	r.in.flags = flags;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PNP_GetHwProfInfo, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_ntsvcs,
				NDR_PNP_GETHWPROFINFO,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PNP_GetHwProfInfo, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*info = *r.out.info;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PNP_AddEmptyLogConf(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    WERROR *werror)
{
	struct PNP_AddEmptyLogConf r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PNP_AddEmptyLogConf, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_ntsvcs,
				NDR_PNP_ADDEMPTYLOGCONF,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PNP_AddEmptyLogConf, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PNP_FreeLogConf(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				WERROR *werror)
{
	struct PNP_FreeLogConf r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PNP_FreeLogConf, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_ntsvcs,
				NDR_PNP_FREELOGCONF,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PNP_FreeLogConf, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PNP_GetFirstLogConf(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    WERROR *werror)
{
	struct PNP_GetFirstLogConf r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PNP_GetFirstLogConf, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_ntsvcs,
				NDR_PNP_GETFIRSTLOGCONF,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PNP_GetFirstLogConf, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PNP_GetNextLogConf(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   WERROR *werror)
{
	struct PNP_GetNextLogConf r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PNP_GetNextLogConf, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_ntsvcs,
				NDR_PNP_GETNEXTLOGCONF,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PNP_GetNextLogConf, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PNP_GetLogConfPriority(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       WERROR *werror)
{
	struct PNP_GetLogConfPriority r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PNP_GetLogConfPriority, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_ntsvcs,
				NDR_PNP_GETLOGCONFPRIORITY,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PNP_GetLogConfPriority, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PNP_AddResDes(struct rpc_pipe_client *cli,
			      TALLOC_CTX *mem_ctx,
			      WERROR *werror)
{
	struct PNP_AddResDes r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PNP_AddResDes, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_ntsvcs,
				NDR_PNP_ADDRESDES,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PNP_AddResDes, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PNP_FreeResDes(struct rpc_pipe_client *cli,
			       TALLOC_CTX *mem_ctx,
			       WERROR *werror)
{
	struct PNP_FreeResDes r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PNP_FreeResDes, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_ntsvcs,
				NDR_PNP_FREERESDES,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PNP_FreeResDes, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PNP_GetNextResDes(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  WERROR *werror)
{
	struct PNP_GetNextResDes r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PNP_GetNextResDes, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_ntsvcs,
				NDR_PNP_GETNEXTRESDES,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PNP_GetNextResDes, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PNP_GetResDesData(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  WERROR *werror)
{
	struct PNP_GetResDesData r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PNP_GetResDesData, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_ntsvcs,
				NDR_PNP_GETRESDESDATA,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PNP_GetResDesData, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PNP_GetResDesDataSize(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx,
				      WERROR *werror)
{
	struct PNP_GetResDesDataSize r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PNP_GetResDesDataSize, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_ntsvcs,
				NDR_PNP_GETRESDESDATASIZE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PNP_GetResDesDataSize, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PNP_ModifyResDes(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 WERROR *werror)
{
	struct PNP_ModifyResDes r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PNP_ModifyResDes, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_ntsvcs,
				NDR_PNP_MODIFYRESDES,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PNP_ModifyResDes, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PNP_DetectResourceLimit(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					WERROR *werror)
{
	struct PNP_DetectResourceLimit r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PNP_DetectResourceLimit, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_ntsvcs,
				NDR_PNP_DETECTRESOURCELIMIT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PNP_DetectResourceLimit, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PNP_QueryResConfList(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     WERROR *werror)
{
	struct PNP_QueryResConfList r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PNP_QueryResConfList, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_ntsvcs,
				NDR_PNP_QUERYRESCONFLIST,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PNP_QueryResConfList, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PNP_SetHwProf(struct rpc_pipe_client *cli,
			      TALLOC_CTX *mem_ctx,
			      WERROR *werror)
{
	struct PNP_SetHwProf r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PNP_SetHwProf, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_ntsvcs,
				NDR_PNP_SETHWPROF,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PNP_SetHwProf, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PNP_QueryArbitratorFreeData(struct rpc_pipe_client *cli,
					    TALLOC_CTX *mem_ctx,
					    WERROR *werror)
{
	struct PNP_QueryArbitratorFreeData r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PNP_QueryArbitratorFreeData, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_ntsvcs,
				NDR_PNP_QUERYARBITRATORFREEDATA,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PNP_QueryArbitratorFreeData, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PNP_QueryArbitratorFreeSize(struct rpc_pipe_client *cli,
					    TALLOC_CTX *mem_ctx,
					    WERROR *werror)
{
	struct PNP_QueryArbitratorFreeSize r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PNP_QueryArbitratorFreeSize, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_ntsvcs,
				NDR_PNP_QUERYARBITRATORFREESIZE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PNP_QueryArbitratorFreeSize, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PNP_RunDetection(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 WERROR *werror)
{
	struct PNP_RunDetection r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PNP_RunDetection, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_ntsvcs,
				NDR_PNP_RUNDETECTION,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PNP_RunDetection, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PNP_RegisterNotification(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 WERROR *werror)
{
	struct PNP_RegisterNotification r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PNP_RegisterNotification, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_ntsvcs,
				NDR_PNP_REGISTERNOTIFICATION,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PNP_RegisterNotification, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PNP_UnregisterNotification(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx,
					   WERROR *werror)
{
	struct PNP_UnregisterNotification r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PNP_UnregisterNotification, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_ntsvcs,
				NDR_PNP_UNREGISTERNOTIFICATION,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PNP_UnregisterNotification, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PNP_GetCustomDevProp(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     WERROR *werror)
{
	struct PNP_GetCustomDevProp r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PNP_GetCustomDevProp, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_ntsvcs,
				NDR_PNP_GETCUSTOMDEVPROP,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PNP_GetCustomDevProp, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PNP_GetVersionInternal(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       WERROR *werror)
{
	struct PNP_GetVersionInternal r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PNP_GetVersionInternal, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_ntsvcs,
				NDR_PNP_GETVERSIONINTERNAL,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PNP_GetVersionInternal, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PNP_GetBlockedDriverInfo(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 WERROR *werror)
{
	struct PNP_GetBlockedDriverInfo r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PNP_GetBlockedDriverInfo, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_ntsvcs,
				NDR_PNP_GETBLOCKEDDRIVERINFO,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PNP_GetBlockedDriverInfo, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_PNP_GetServerSideDeviceInstallFlags(struct rpc_pipe_client *cli,
						    TALLOC_CTX *mem_ctx,
						    WERROR *werror)
{
	struct PNP_GetServerSideDeviceInstallFlags r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(PNP_GetServerSideDeviceInstallFlags, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_ntsvcs,
				NDR_PNP_GETSERVERSIDEDEVICEINSTALLFLAGS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(PNP_GetServerSideDeviceInstallFlags, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

