%define Version 	2.2.7
%define date            1
%define Vendor  	Caldera
%define Dist		OpenLinux
%define EtcSamba 	/etc/samba.d
%define _defaultdocdir  /usr/doc
%define LSBservedir	/srv/samba

Name        	: samba
Version     	: %{Version}
Release     	: %{date}
Group       	: Server/Network

Summary        : Samba SMB client and server.
Summary(de)    : Samba SMB Client und Server.
Summary(es)    : Cliente y servidor SMB Samba.
Summary(fr)    : Client et serveur SMB Samba.
Summary(it)    : Client e server SMB.
Summary(pt)    : Cliente e servidor SMB Samba.

Copyright       : Andrew Tridgell, John H Terpstra; GPL Version 2
Packager        : Klaus Singvogel <klaus@caldera.de>
#Icon            : Caldera-daemon.gif
URL             : http://samba.org/samba

Requires    	: libpam >= 0.66, SysVinit-scripts >= 1.04-6


BuildRoot   	: /tmp/%{Name}-%{Version}

Source: ftp://ftp.samba.org/pub/samba/%{Name}-%{Version}.tar.gz


%Package doc
Group       	: Server/Network

Summary        : Documentation on SAMBA.
Summary(de)    : Die Dokumentation fr Samba.
Summary(es)    : Documentation de SAMBA.
Summary(fr)    : Documentation pour Samba.
Summary(it)    : Documentazione su SAMBA.
Summary(pt)    : Documentao sobre o SAMBA.


%Package -n smbfs
Group       	: System/Network

Summary     	: Mount and unmount commands for SMB filesystems (smbfs).
Summary(de)    : Mount und unmount fr SMB-Dateisysteme (smbfs).
Summary(es)    : Comandos de montaje y desmontaje de sistemas de ficheros SMB (smbfs).
Summary(fr)    : Commandes pour le montage et le dmontage des systmes de fichiers SMB (smbfs).
Summary(it)    : Comandi per montare e smontare i file system SMB (smbfs).
Summary(pt)    : Comandos mount e unmount para o sistema de ficheiros SMB (smbfs).



%Package -n swat
Group       	: Administration/Network
Requires        : setup >= 2.0-2, tcp_wrappers

Summary        : Samba Web Administration Tool.
Summary(de)    : Das Samba Web Administrationstool.
Summary(es)    : Utilidad de administracin Samba.
Summary(fr)    : Outil d'administration Internet pour Samba.
Summary(it)    : Strumento per l'amministrazione di Samba via Web.
Summary(pt)    : Ferramenta Web de administrao de Samba (Samba Web Administration Tool).


%Description
Samba provides an SMB server which can be used to provide network
services to SMB (sometimes called "Lan Manager") clients, including
various versions of MS Windows, OS/2, and other Linux machines.

%Description -l de
Samba stellt einen SMB Server zur Verfgung, mit dem Netzwerkdienste fr SMB
(auch "Lan Manager" genannt) Clients bereitgestellt werden knnen. Dies
schliet verschiedene Versionen von MS Windows, OS/2 und andere Linux
Maschinen ein.

%Description -l es
Samba dispone de un servidor SMB que puede utilizarse para proporcionar
servicios de red a clientes SMB (a veces conocido como "Lan Manager"),
incluyendo varias versiones de MS Windows, OS/2 y otras mquinas Linux.

%Description -l fr
Samba fournit un serveur SMB qui peut tre utilis pour fournir des services
de rseau aux clients SMB (parfois appels "Lan Manager"), comportant
diverses versions de MS Windows, OS/2 et d'autres machines Linux.

%Description -l it
Samba fornisce un server SMB che pu essere usato per fornire servizi
di rete a client SMB (talvolta chiamato "Lan Manager"), comprese varie
versioni di MS Windows, OS/2 e altre macchine Linux.

%Description -l pt
O Samba fornece um servidor de SMB que pode ser usado para fornecer servios de
rede aos clientes de SMB (denominado por vezes como "Lan Manager"), incluindo
vrias verses do Windows, OS/2 e outras mquinas Linux.

%Description doc
This package contains extensive SAMBA documentation, including a FAQ,
comprehensive usage documentation, and a number of examples.

%Description -l de doc
Dieses Paket enthlt eine ausfhrliche SAMBA Dokumentation, inklusive
einer FAQ, umfassender Gebrauchsdokumentation und einer Reihe von
Beispielen.

%Description -l es doc
Este paquete contiene una extensa documentacin sobre SAMBA, incluyendo
FAQ (Preguntas de Uso Frecuente), documentacin sobre el uso y algunos
ejemplos.

%Description -l fr doc
Ce paquetage contient une documentation complte sur Samba, y compris
une FAQ dtaille de son utilisation et un certain nombre d'exemples.

%Description -l it doc
Questo pacchetto contiene la documentazione su SAMBA tra cui una FAQ
una esaustiva documentazione d'uso e un certo numero di esempi.

%Description -l pt doc
Este pacote contm alguma documentao extensa sobre o SAMBA, incluindo a FAQ,
alguma documentao compreensiva sobre a utilizao e alguns exemplos.

%Description -n smbfs
This package includes the tools necessary to mount filesystems from
SMB servers.

%Description -l de -n smbfs
Dieses Paket enthlt die ntigen Tools, um Dateisysteme von SMB-Servern
zu mounten.

%Description -l es -n smbfs
este paqeute incluye las herramientas necesarias para montar sistemas de
ficheros de servidores SMB.

%Description -l fr -n smbfs
Ce paquetage contient les outils ncessaires pour monter des systmes
de fichiers sur des serveurs SMB.

%Description -l it -n smbfs
Questo pacchetto contiene gli strumenti necessari per montare filesystem
da server SMB.

%Description -l pt -n smbfs
Este pacote contm as ferramentas necessrias para montar sistema de
ficheiros de servidores SMB.

%Description -n swat
SWAT allows a Samba administrator to configure the complex smb.conf
file via a Web browser.  It also provides links to all the configurable
options in the smb.conf file allowing an administrator to easily look
up the effects of any change.

%Description -l de -n swat
Mit SWAT kann ein Samba-Administrator die komplexe smb.conf
Datei mit Hilfe eines Web-Browsers konfigurieren.  Es stellt auch Links zu
allen konfigurierbaren Optionen in der smb.conf Datei bereit, wodurch ein
Administrator die Auswirkungen einer nderung leicht nachvollziehen kann.

%Description -l es -n swat
SWAT permite a un administrador de Samba configurar el complejo fichero
smb.conf mediante una navegador web. Tambin proporciona enlaces a todas las
opciones configurables en el fichero smb.conf, permitiendo al administrador
comprobar fcilmente los efectos de cualquier cambio.

%Description -l fr -n swat
SWAT permet  un administrateur Samba de configurer le fichier smb.conf
complexe via un navigateur Web. Il fournit galement des liens d'aide pour
toutes les options configurables dans le fichier smb.conf permettant  un
administrateur de consulter aisment les effets d'une modification.

%Description -l it -n swat
SWAT permette ad un amministratore Samba di configurare il complesso file
smb.conf attraverso un browser Web. SWAT ha anche dei link di aiuto per
tutte le opzioni di configurazione del file smb.conf.

%Description -l pt -n swat
O SWAT permite a um administrador de Samba configurar o complexo ficheiro
smb.conf atravs de uma interface Web. Fornece tambm referncias para
todas as opes configuraveis no smb.conf, permitindo a um admnistrador
verificar rapidamente o efeite de qualquer alterao.


%Prep
%setup

# instead of patch (to help configuration) ...   ;^)
%{fixUP} -vbT source/Makefile.in -e '
  s:we don.t use sbindir because we want:if you want : +
  s:(the previous releases of Samba):$1, please use: +
  s:(SBINDIR\s*=\s*\@)b:# ./configure --sbindir=\\\$(BINDIR)\n${1}sb: +
  s:/log\.(\S+):/log/samba.d/${1}d: +
  s:(PASSWD_PROGRAM\s*=\s*)(/bin):$1/usr$2:
'
#  s:^(LIBS\s*=):AUTH_$1: +
#  s:((CLIENT|CUPS|NMBD|SMBD|SWAT|RPCCLIENT|SMBPASSWD|STATUS|TESTPRNS|TESTPARM)_OBJ\) )(\$\(LDF):$1\$(AUTH_LIBS) $3:

for i in {cvs.,change-}log; do [ ! -f ../$i ] || mv ../$i source; done

mv swat/help/welcome.html docs
%{fixUP} -vT docs -e '
  s:/usr/local/samba/bin/(smb(client|run)):/usr/bin/$1:g +
  s:/usr/local/samba/bin/((s|n)mbd|swat|smbstatus):/usr/sbin/$1:g +
  s:/usr/local/samba/var/locks:/var/lock/samba.d: +
  s:/usr/local/samba/(var|lib)/log:/var/log/samba.d/smb: +
  s:/usr/local/samba/swat:/usr/share/samba/swat:g +
  s:/usr/local/samba/lib:%{EtcSamba}:g +
  s:/usr/local/samba/printers:/var/spool/samba:g +
  s:/usr/local/samba/private/smbpasswd:/usr/bin/smbpasswd:g +
  s:/usr/local/samba/netlogon:%{LSBservedir}/netlogon:g;
'
mv docs/welcome.html swat/help
for i in docs/*/smb.conf.5*; do
  %{fixUP} -vT $i -e '
    s:users\.map:smbusers:g +
    s:SAMBA_INSTALL_DIRECTORY/lib:%{EtcSamba}: +
    s:None \(set in compile\)\.:(see above).: +
    s:/usr/local/:/usr/:g;
  '
done
%{fixUP} -vT docs/textdocs/Faxing.txt -e '
  s:/usr/local/etc/:/etc/: +
  s:/usr/local/:/usr/:;
'
%{fixUP} -vT docs/docbook/projdoc/ENCRYPTION.sgml -e '
  s:/usr/local/samba/private:%{EtcSamba}:g +
  s:mksmbpasswd.sh:mksmbpasswd:g +
  s:the Samba source directory:/usr/bin:;
'
%{fixUP} -vT docs/htmldocs/make_smbcodepage.1.html -e '
  s:/usr/local/samba:/usr/bin/:g;
'
for i in htmldocs/DOMAIN_MEMBER.html htmldocs/Samba-HOWTO-Collection.html \
         htmldocs/smbclient.1.html htmldocs/smbd.8.html \
         docbook/projdoc/DOMAIN_MEMBER.sgml htmldocs/DOMAIN_MEMBER.html \
         docbook/manpages/smbclient.1.sgml docbook/manpages/smbd.8.sgml \
	 docbook/projdoc/ENCRYPTION.sgml manpages/smbclient.1 manpages/smbd.8 ; do
%{fixUP} -vT docs/$i -e '
    s:/usr/local/samba/private/FOREST.SLEEPY.SID:/var/lock/samba.d/FOREST.SLEEPY.SID: +
    s:/usr/local/samba/private:/usr/bin:g +
    s:/usr/local/samba/bin:/usr/bin:g +
    s:/usr/local/sbin:/usr/sbin:g +
    s:/usr/local/src/samba:/usr/src/samba:g ;'
done
%{fixUP} -vT docs/docbook/manpages/make_smbcodepage.1.sgml -e '
  s:/usr/local/samba:/usr/bin:g ;
'
# End of DirtyHack(TM)


%Build
cd source
autoreconf

CFLAGS="$RPM_OPT_FLAGS" LDFLAGS="-s" ./configure \
	--prefix='$(DESTDIR)/usr' \
	--localstatedir='$(DESTDIR)/var' \
	--libdir='$(DESTDIR)%{EtcSamba}' \
	--with-privatedir='$(LIBDIR)' \
	--with-lockdir='$(DESTDIR)/var/lock/samba.d' \
	--with-swatdir='$(DESTDIR)/usr/share/swat' \
	--with-swatdir='$(DESTDIR)/usr/share/swat' \
	--with-sambabook='$(DESTDIR)/usr/share/swat/using_samba' \
	--with-configdir='$(DESTDIR)'%{EtcSamba} \
	--with-codepagedir='$(DESTDIR)'/usr/share/samba/codepages \
	--without-smbwrapper \
	--with-smbmount \
	--with-pam \
	--with-pam_smbpass \
	--with-quotas \
	--with-syslog \
	--win_winbind \
	--with-utmp

make LOGFILEBASE=/var/log/samba.d all
make LOGFILEBASE=/var/log/samba.d nsswitch/libnss_wins.so
make LOGFILEBASE=/var/log/samba.d smbfilter debug2html
make LOGFILEBASE=/var/log/samba.d bin/smbspool


%Install
%{mkDESTDIR}
VVS=packaging/%{Vendor}/%{Dist}

mkdir -p $DESTDIR/etc/{{rc.d/init,logrotate,pam}.d,sysconfig/daemons,skel/Samba}
mkdir -p $DESTDIR/var/{lo{ck,g}/samba.d,spool/samba}
mkdir -p $DESTDIR/usr/share/swat/using_samba/{gifs,figs}
mkdir -p $DESTDIR/lib/security
mkdir -p $DESTDIR/%{LSBservedir}/{netlogon,profiles,Public}
mkdir -p $DESTDIR/usr/share/samba/codepages/src $DESTDIR/sbin

make -C source  install
make LOGFILEBASE=/var/log/samba.d -C source install

strip $DESTDIR/usr/bin/smb{mnt,umount}
#mv $DESTDIR/usr/bin/{make,add,conv}* $DESTDIR/usr/sbin

cp -p source/codepages/codepage_def.??? $DESTDIR/usr/share/samba/codepages/src

# Install the nsswitch library extension file
install -m 755 source/nsswitch/libnss_wins.so $DESTDIR/lib/libnss_wins.so.2.0
# Make link for wins resolver
ln -s libnss_wins.so.2.0 $DESTDIR/lib/libnss_wins.so.2
ln -s libnss_wins.so.2.0 $DESTDIR/lib/libnss_wins.so

# Add PAM smbpass and winbind facilities
install -m 755 source/bin/pam_smbpass.so $DESTDIR/lib/security
install -m 755 source/nsswitch/libnss_winbind.so $DESTDIR/lib/libnss_winbind.so.2.0

# Make link for winbind resolver
ln -s libnss_winbind.so.2.0 $DESTDIR/lib/libnss_winbind.so.2
ln -s libnss_winbind.so.2.0 $DESTDIR/lib/libnss_winbind.so

install -m 755 source/nsswitch/pam_winbind.so $DESTDIR/lib/security
install -m 755 source/bin/wbinfo $DESTDIR/usr/bin
install -m 755 source/bin/debug2html $DESTDIR/usr/sbin/debug2html

cp -p $VVS/smb.conf.sample $DESTDIR%{EtcSamba}/smb.conf.sample
cp -p $VVS/smb.conf $DESTDIR%{EtcSamba}/smb.conf
cp -p $VVS/smbusers $DESTDIR%{EtcSamba}
cp -p $VVS/smbprint $DESTDIR/usr/bin

cp -p $VVS/smbadduser $DESTDIR/usr/bin/smbadduser
#cp -p $VVS/make_smbpasswd.perl $DESTDIR/usr/bin/make_smbpasswd
#cp -p $VVS/convertsmbpasswd.perl $DESTDIR/usr/bin/convertsmbpasswd
#cp -p $VVS/updatesmbpasswd.perl $DESTDIR/usr/bin/updatesmbpasswd

cp -p $VVS/samba.daemon $DESTDIR/etc/sysconfig/daemons/samba
cp -p $VVS/samba.pam $DESTDIR/etc/pam.d/samba
cp -p $VVS/samba.logrotate $DESTDIR/etc/logrotate.d/samba
cp -p $VVS/README.home $DESTDIR/etc/skel/Samba/README.txt
cp -p $VVS/README.Public $DESTDIR/%{LSBservedir}/Public/README.txt
cp -p $VVS/README.profiles $DESTDIR/%{LSBservedir}/profiles/README.txt

install -m 755 $VVS/samba.init-lsb $DESTDIR/etc/rc.d/init.d/samba
ln -s /etc/rc.d/init.d/samba $DESTDIR/usr/sbin

for f in testparm testprns; do
  ln -s $f $DESTDIR/usr/bin/smb$f
  ln -s $f.1 $DESTDIR/usr/man/man1/smb$f.1
done

#ln -s make_smbcodepage  $DESTDIR/usr/bin/mksmbcodepage
#ln -s make_smbpasswd $DESTDIR/usr/bin/mksmbpasswd
#ln -sf convert_smbpasswd $DESTDIR/usr/bin/convertsmbpasswd

ln -s ../usr/bin/smbmount $DESTDIR/sbin/mount.smbfs

cat <<-'EoH' > $DESTDIR%{EtcSamba}/lmhosts
	127.0.0.1 localhost
EoH


# -------------------- Documentation -------------------------------
DOCD="$DESTDIR/%{_defaultdocdir}/samba-%{Version}"; mkdir -p $DOCD
ln -sf ../Copyrights/GPL-2.0  $DOCD/COPYING

#cp -p README README-smbmount Manifest Read-Manifest-Now $DOCD

cp -p README Manifest Read-Manifest-Now $DOCD
cp -p WHATSNEW.txt Roadmap $DOCD
cp -a docs examples $DOCD

mv $DOCD/docs/htmldocs/wfw_slip.htm $DOCD/docs/wfw_slip.html

rm -rf $DOCD/docs/{htmldocs,manpages,yodldocs}
rm -rf $DOCD/examples/{svr4-startup,printing}
rm -rf $DOCD/CVS $DOCD/*/CVS $DOCD/*/*/CVS $DOCD/*/*/*/CVS

cp -p swat/README $DOCD/README.swat

# This is the O'Reily Samba Book - on-line
for i in docs/htmldocs/using_samba/*.html
do
install -m644 $i $DESTDIR/usr/share/swat/using_samba
done
for i in docs/htmldocs/using_samba/figs/*.gif
do
install -m644 $i $DESTDIR/usr/share/swat/using_samba/figs
done
for i in docs/htmldocs/using_samba/gifs/*.gif
do
install -m644 $i $DESTDIR/usr/share/swat/using_samba/gifs
done

%{fixUP} -vT $DOCD/examples -e 's:/usr/local/bin/:/usr/bin/:g;'
%{fixUP} -vT $DESTDIR/etc/samba.d -e 's:\@samba_home\@:%{LSBservedir}:'

%{fixManPages}

%{mkLists} -c samba
cat << 'EOF' | %{mkLists} -d samba
Samba					base
%{LSBservedir}				config-IGNORED
^/(etc|var|home|tmp)			config-IGNORED
swat					swat
%{_defaultdocdir}/samba-[^/]+/$		base
%{_defaultdocdir}/samba- 		doc
/lib/$					IGNORED
/srv/$					IGNORED
tmp					IGNORED
man					IGNORED
/src/$					IGNORED
/usr/private/$				IGNORED
@default@
EOF
cat << 'EOF' | %{mkLists} -f -a samba
\.old$					IGNORED
Samba/README.txt			base
^/etc					config-IGNORED
%{_defaultdocdir}/samba-[^/]+/(COPYING|README$)	base
libnss_wins.so				base
pam_*					base
%{_defaultdocdir}/samba-[^/]+/(COPYING|README$)	base
%{_defaultdocdir}/samba- 		doc
smb(mount|mnt|umount)			smbfs
mount.smbfs				smbfs
swat					swat
libsmbclient				libsmbclient
@default@
EOF


%Clean
%{rmDESTDIR}


%Post
lisa --SysV-init install samba S91 3:4:5 K09 0:1:2:6
/sbin/ldconfig


%Post -n swat
lisa --inetd install swat stream tcp nowait.400 root /usr/sbin/tcpd swat
perl -pi -e '$s=1 if /^swat/;
  print "swat:ALL EXCEPT 127.0.0.1\n" if eof && ! $s' /etc/hosts.deny


%PostUn
lisa --SysV-init remove samba $1
/sbin/ldconfig
# We want to remove the browse.dat and wins.dat files so they can not
# interfer with a new version of samba!
rm -f /var/lock/samba/browse.dat
rm -f /var/lock/samba/{brlock,connections,locking,messages}.tdb
if [ -e /var/lock/samba.d/namelist.debug ]; then
	rm -f /var/lock/samba.d/namelist.debug
fi
rm -f /var/lock/samba/unexpected.tdb
rm -f /var/lock/samba/{smbd,nmbd}.pid

# Note: We MUST keep:
#	winbindd_*, sshare_info*, printing*, ntdrivers*


%PostUn -n swat
lisa --inetd disable swat $1
[ -x /usr/sbin/swat ]||perl -ni -e '/^swat\s*\:/||print' /etc/hosts.deny


%Files -f files-samba-base
%defattr(-,root,root)
%config %attr(755,root,root) /etc/rc.d/init.d/samba
%config %attr(644,root,root) /etc/sysconfig/daemons/samba
%config %attr(644,root,root) /etc/pam.d/samba
%config %attr(644,root,root) /etc/logrotate.d/samba
%config %attr(-,root,root) %{EtcSamba}
%dir %attr(755,root,root) /var/lock/samba.d
%dir %attr(755,root,root) /var/log/samba.d
%dir %attr(1777,root,root) /var/spool/samba
%dir %attr(755,root,root) %{LSBservedir}
%dir %attr(755,root,root) %{LSBservedir}/netlogon
%dir %attr(755,root,root) %{LSBservedir}/profiles
%dir %attr(755,root,root) %{LSBservedir}/Public


%Files doc -f files-samba-doc
%defattr(-,root,root)


%Files -n smbfs -f files-samba-smbfs
%defattr(-,root,root)


%Files -n swat  -f files-samba-swat
%defattr(-,root,root)


%ChangeLog
* Mon Jan 01 1997 ...
 - nothing here for now
