Summary: Samba SMB client and server
Name: samba
Version: 2.2.1
Release: 20010710
Copyright: GNU GPL version 2
Group: Networking
Source: ftp://samba.org/pub/samba/samba-%{version}.tar.gz
Packager: Gerald (Jerry) Carter [Samba-Team] <jerry@samba.org>
Requires: pam >= 0.72 kernel >= 2.2.1 glibc >= 2.1.2
Prereq: chkconfig fileutils
BuildRoot: /var/tmp/samba
Prefix: /usr

%description
Samba provides an SMB server which can be used to provide
network services to SMB (sometimes called "Lan Manager")
clients, including various versions of MS Windows, OS/2,
and other Linux machines. Samba also provides some SMB
clients, which complement the built-in SMB filesystem
in Linux. Samba uses NetBIOS over TCP/IP (NetBT) protocols
and does NOT need NetBEUI (Microsoft Raw NetBIOS frame)
protocol.

Samba-2.2 features working NT Domain Control capability and 
includes the SWAT (Samba Web Administration Tool) that 
allows samba's smb.conf file to be remotely managed using your 
favourite web browser. For the time being this is being
enabled on TCP port 901 via inetd.

Users are advised to use Samba-2.2 as a Windows NT4
Domain Controller only on networks that do NOT have a Windows
NT Domain Controller. This release does NOT as yet have
Backup Domain control ability.

Please refer to the WHATSNEW.txt document for fixup information.
This binary release includes encrypted password support.

Please read the smb.conf file and ENCRYPTION.txt in the
docs directory for implementation details.

%changelog
* Mon May 21 2001 Gerald (Jerry) Carter <jerry@samba.org>
  - removed docs/htmldocs and docs/manpages from /usr/share/docs
    These het installed in /usr/share/swat already
  - Fix for codepages and src not getting installed in the RPM
  - Fixed minor typos

* Mon Apr 23 2001 Gerald (Jerry) Carter <jerry@samba.org>
  - Added a few bug fixes to release the first Mandrake RPMS

* Sat Apr 14 2001 John H Terpstra <jht@samba.org>
  - Added official samba-team support for Mandrakesoft
	- We get a lot of requests for this!

%prep
%setup

%build
cd source

%ifarch ia64
libtoolize --copy --force     # get it to recognize IA-64
autoconf
autoheader
EXTRA="-D_LARGEFILE64_SOURCE"
%endif

NUMCPU=`grep processor /proc/cpuinfo | wc -l`

CFLAGS="$RPM_OPT_FLAGS $EXTRA" ./configure \
	--prefix=%{prefix} \
	--with-fhs \
	--libdir=/etc/samba \
	--localstatedir=/var \
	--with-codepagedir=%{prefix}/share/samba/codepages \
	--with-configdir=/etc/samba \
	--with-swatdir=%{prefix}/share/swat \
	--with-quotas \
	--with-smbmount \
	--with-pam \
	--with-pam_smbpass \
	--with-syslog \
	--with-utmp \
	--with-netatalk \
	--with-sambabook=%{prefix}/share/swat/using_samba

make -j${NUMCPU} proto
make -j${NUMCPU} all smbfilter nsswitch/libnss_wins.so debug2html

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/etc/{logrotate.d,pam.d,samba,xinetd.d}
mkdir -p $RPM_BUILD_ROOT/etc/samba/security
mkdir -p $RPM_BUILD_ROOT/etc/rc.d/init.d
mkdir -p $RPM_BUILD_ROOT/lib/security
mkdir -p $RPM_BUILD_ROOT%{prefix}/{bin,sbin}
mkdir -p $RPM_BUILD_ROOT/home/samba
mkdir -p $RPM_BUILD_ROOT/sbin
mkdir -p $RPM_BUILD_ROOT%{prefix}/share/swat/{images,help,include}
mkdir -p $RPM_BUILD_ROOT%{prefix}/share/samba/codepages/src 
mkdir -p $RPM_BUILD_ROOT%{prefix}/share/swat/using_samba/{figs,gifs}
mkdir -p $RPM_BUILD_ROOT%{prefix}/share/man/{man1,man5,man7,man8}
mkdir -p $RPM_BUILD_ROOT/var/cache/samba
mkdir -p $RPM_BUILD_ROOT/var/log/samba
mkdir -p $RPM_BUILD_ROOT/var/spool/samba

# Install standard binary files
for i in nmblookup smbclient smbpasswd smbstatus testparm testprns \
   make_smbcodepage make_unicodemap make_printerdef rpcclient smbspool \
   smbmount smbumount smbmnt
do
	install -m755 -s source/bin/$i $RPM_BUILD_ROOT%{prefix}/bin
done
for i in smbtar
do
	install -m755 source/script/$i $RPM_BUILD_ROOT%{prefix}/bin
done

# Install secure binary files
for i in smbd nmbd swat debug2html smbfilter
do
	install -m755 -s source/bin/$i $RPM_BUILD_ROOT%{prefix}/sbin
done

# we need a symlink for mount to recognise the smb and smbfs filesystem types
ln -sf %{prefix}/bin/smbmount $RPM_BUILD_ROOT/sbin/mount.smbfs
ln -sf %{prefix}/bin/smbmount $RPM_BUILD_ROOT/sbin/mount.smb

# Install codepage source files
for i in 437 737 775 850 852 861 866 932 936 949 950 1251; do
	install -m644 source/codepages/codepage_def.$i $RPM_BUILD_ROOT%{prefix}/share/samba/codepages/src
done
for i in 437 737 850 852 861 866 932 936 949 950 ISO8859-1 ISO8859-2 ISO8859-5 ISO8859-7 KOI8-R; do
	install -m644 source/codepages/CP$i.TXT $RPM_BUILD_ROOT%{prefix}/share/samba/codepages/src
done

# Install the nsswitch library extenstion file
install -m755 source/nsswitch/libnss_wins.so $RPM_BUILD_ROOT/lib
# Make link for wins resolver
( cd $RPM_BUILD_ROOT/lib; ln -s libnss_wins.so libnss_wins.so.2; )

# PAM Authentication file
install -m755 source/bin/pam_smbpass.so $RPM_BUILD_ROOT/lib/security

# Install SWAT helper files
for i in swat/help/*.html docs/htmldocs/*.html; do
	install -m644 $i $RPM_BUILD_ROOT%{prefix}/share/swat/help
done
for i in swat/images/*.gif; do
	install -m644 $i $RPM_BUILD_ROOT%{prefix}/share/swat/images
done
for i in swat/include/*.html; do
	install -m644 $i $RPM_BUILD_ROOT%{prefix}/share/swat/include
done

# This is the O'Reily Samba Book - on-line
for i in docs/htmldocs/using_samba/*.html; do
	install -m644 $i $RPM_BUILD_ROOT%{prefix}/share/swat/using_samba
done
for i in docs/htmldocs/using_samba/figs/*.gif; do
	install -m644 $i $RPM_BUILD_ROOT%{prefix}/share/swat/using_samba/figs
done
for i in docs/htmldocs/using_samba/gifs/*.gif; do
	install -m644 $i $RPM_BUILD_ROOT%{prefix}/share/swat/using_samba/gifs
done

# Install the miscellany
install -m644 swat/README $RPM_BUILD_ROOT%{prefix}/share/swat
# Install level 1 man pages
for i in *.1; do
	install -m644 docs/manpages/$i $RPM_BUILD_ROOT%{prefix}/share/man/man1
done
install -m644 docs/manpages/smb.conf.5 $RPM_BUILD_ROOT%{prefix}/share/man/man5
install -m644 docs/manpages/lmhosts.5 $RPM_BUILD_ROOT%{prefix}/share/man/man5
install -m644 docs/manpages/smbpasswd.5 $RPM_BUILD_ROOT%{prefix}/share/man/man5

install -m644 docs/manpages/samba.7 $RPM_BUILD_ROOT%{prefix}/share/man/man7

install -m644 docs/manpages/smbd.8 $RPM_BUILD_ROOT%{prefix}/share/man/man8
install -m644 docs/manpages/nmbd.8 $RPM_BUILD_ROOT%{prefix}/share/man/man8
install -m644 docs/manpages/smbpasswd.8 $RPM_BUILD_ROOT%{prefix}/share/man/man8
install -m644 docs/manpages/swat.8 $RPM_BUILD_ROOT%{prefix}/share/man/man8
install -m644 docs/manpages/smbmount.8 $RPM_BUILD_ROOT%{prefix}/share/man/man8
install -m644 docs/manpages/smbmnt.8 $RPM_BUILD_ROOT%{prefix}/share/man/man8
install -m644 docs/manpages/smbumount.8 $RPM_BUILD_ROOT%{prefix}/share/man/man8
install -m644 docs/manpages/smbspool.8 $RPM_BUILD_ROOT%{prefix}/share/man/man8

install -m644 swat/README $RPM_BUILD_ROOT%{prefix}/share/swat

install -m644 packaging/Mandrake/smb.con* $RPM_BUILD_ROOT/etc/samba/
install -m644 packaging/Mandrake/smbusers $RPM_BUILD_ROOT/etc/samba/smbusers
install -m755 packaging/Mandrake/smbprint $RPM_BUILD_ROOT%{prefix}/bin
install -m755 packaging/Mandrake/findsmb $RPM_BUILD_ROOT%{prefix}/bin
install -m755 packaging/Mandrake/smb.init $RPM_BUILD_ROOT/etc/rc.d/init.d/smb
install -m755 packaging/Mandrake/smb.init $RPM_BUILD_ROOT%{prefix}/sbin/samba
install -m644 packaging/Mandrake/samba.pamd $RPM_BUILD_ROOT/etc/pam.d/samba
install -m644 packaging/Mandrake/samba.log $RPM_BUILD_ROOT/etc/logrotate.d/samba
install -m644 packaging/Mandrake/samba.xinetd $RPM_BUILD_ROOT/etc/xinetd.d/swat
echo 127.0.0.1 localhost > $RPM_BUILD_ROOT/etc/samba/lmhosts

##
## remove these directories so they don't get installed twice
##
/bin/rm -rf docs/htmldocs
/bin/rm -rf docs/manpages


%clean
rm -rf $RPM_BUILD_ROOT

%post
/sbin/chkconfig --add smb
/sbin/chkconfig smb off

# Build codepage load files
cd %{prefix}/share/samba/codepages
for i in 437 737 775 850 852 861 866 932 936 949 950 1251
do
%{prefix}/bin/make_smbcodepage c $i %{prefix}/share/samba/codepages/src/codepage_def.$i %{prefix}/share/samba/codepages/codepage.$i
done
for i in 437 737 850 852 861 866 932 936 949 950 ISO8859-1 ISO8859-2 ISO8859-5 ISO8859-7 KOI8-R
do
%{prefix}/bin/make_unicodemap $i %{prefix}/share/samba/codepages/src/CP$i.TXT %{prefix}/share/samba/codepages/unicode_map.$i
done

echo "Looking for old /etc/smb.conf..."
if [ -f /etc/smb.conf ]; then
	echo "Moving old /etc/smb.conf to /etc/samba/smb.conf"
	mv /etc/smb.conf /etc/samba/smb.conf
fi
 
echo "Looking for old /etc/smbusers..."
if [ -f /etc/smbusers ]; then
	echo "Moving old /etc/smbusers to /etc/samba/smbusers"
	mv /etc/smbusers /etc/samba/smbusers
fi
 
echo "Looking for old /etc/lmhosts..."
if [ -f /etc/lmhosts ]; then
	echo "Moving old /etc/lmhosts to /etc/samba/lmhosts"
	mv /etc/lmhosts /etc/samba/lmhosts
fi
 
echo "Looking for old /etc/MACHINE.SID..."
if [ -f /etc/MACHINE.SID ]; then
	echo "Moving old /etc/MACHINE.SID to /etc/samba/MACHINE.SID"
	mv /etc/MACHINE.SID /etc/samba/MACHINE.SID
fi
 
echo "Looking for old /etc/smbpasswd..."
if [ -f /etc/smbpasswd ]; then
	echo "Moving old /etc/smbpasswd to /etc/samba/smbpasswd"
	mv /etc/smbpasswd /etc/samba/smbpasswd
fi

#
# For 2.2.1 we move the tdb files from /var/lock/samba to /var/cache/samba
# to preserve across reboots.
#
echo "Moving tdb files in /var/lock/samba/*.tdb to /var/cache/samba/*.tdb"
for i in /var/lock/samba/*.tdb
do
if [ -f $i ]; then
	newname=`echo $i | sed -e's|var\/lock\/samba|var\/cache\/samba|'`
	echo "Moving $i to $newname"
	mv $i $newname
fi
done
 
# Remove the transient tdb files.
if [ -e /var/cache/samba/brlock.tdb ]; then
	rm -f /var/cache/samba/brlock.tdb
fi
 
if [ -e /var/cache/samba/unexpected.tdb ]; then
	rm -f /var/cache/samba/unexpected.tdb
fi
 
if [ -e /var/cache/samba/connections.tdb ]; then
	rm -f /var/cache/samba/connections.tdb
fi
 
if [ -e /var/cache/samba/locking.tdb ]; then
	rm -f /var/cache/samba/locking.tdb
fi
 
if [ -e /var/cache/samba/messages.tdb ]; then
	rm -f /var/cache/samba/messages.tdb
fi
 
if [ -d /var/lock/samba ]; then
	rm -rf /var/lock/samba
fi

# Add swat entry to /etc/services if not already there
if !( grep ^[:space:]*swat /etc/services > /dev/null ) then
	echo 'swat		901/tcp				# Add swat service used via inetd' >> /etc/services
fi

# Add swat entry to /etc/inetd.conf if needed.
if [ -f /etc/inetd.conf ]; then
	if !( grep ^[:space:]*swat /etc/inetd.conf > /dev/null ) then
		echo 'swat  stream  tcp nowait.400  root    %{prefix}/sbin/swat swat' >> /etc/inetd.conf
		killall -1 inetd || :
	fi
fi
 
# Add swat entry to xinetd.d if needed.
if [ -d $RPM_BUILD_ROOT/etc/xinetd.d ]; then
	mv /etc/samba/samba.xinetd /etc/xinetd.d/swat
else
	rm -f /etc/samba/samba.xinetd
fi
 
# Install the correct version of the samba pam file, depending on pam version.
if [ -f /lib/security/pam_stack.so ]; then
	echo "Installing stack version of /etc/pam.d/samba..."
	mv /etc/samba/samba.stack /etc/pam.d/samba
else
	echo "Installing non-stack version of /etc/pam.d/samba..."
	rm -f /etc/samba/samba.stack
fi

%preun
if [ $1 = 0 ] ; then
	/sbin/chkconfig --del smb

	# We want to remove the browse.dat file
	if [ -e /var/cache/samba/browse.dat ]; then
		rm -f /var/cache/samba/browse.dat
	fi

	if [ -e /var/cache/samba/wins.dat ]; then
		rm -f /var/cache/samba/wins.dat
	fi
 
	# Remove the transient tdb files.
	if [ -e /var/cache/samba/brlock.tdb ]; then
		rm -f /var/cache/samba/brlock.tdb
	fi
 
	if [ -e /var/cache/samba/unexpected.tdb ]; then
		rm -f /var/cache/samba/unexpected.tdb
	fi
 
	if [ -e /var/cache/samba/connections.tdb ]; then
		rm -f /var/cache/samba/connections.tdb
	fi
 
	if [ -e /var/cache/samba/locking.tdb ]; then
		rm -f /var/cache/samba/locking.tdb
	fi
 
	if [ -e /var/cache/samba/messages.tdb ]; then
		rm -f /var/cache/samba/messages.tdb
	fi
fi

%postun
# Only delete remnants of samba if this is the final deletion.
if [ $1 = 0 ] ; then
	if [ -x /etc/pam.d/samba ]; then
		rm -f /etc/pam.d/samba
	fi
 	if [ -e /var/log/samba ]; then
		rm -rf /var/log/samba
	fi
 	if [ -e /var/cache/samba ]; then
		rm -rf /var/cache/samba
	fi

	# Remove swat entries from /etc/inetd.conf and /etc/services
	cd /etc
	tmpfile=/etc/tmp.$$
	if [ -f /etc/inetd.conf ]; then
		# preserve inetd.conf permissions.
		cp -p /etc/inetd.conf $tmpfile
		sed -e '/^[:space:]*swat.*$/d' /etc/inetd.conf > $tmpfile
		mv $tmpfile inetd.conf
	fi
	# preserve services permissions.
	cp -p /etc/services $tmpfile
	sed -e '/^[:space:]*swat.*$/d' /etc/services > $tmpfile
	mv $tmpfile /etc/services
 
	# Remove swat entry from /etc/xinetd.d
	if [ -f /etc/xinetd.d/swat ]; then
		rm -r /etc/xinetd.d/swat
	fi
fi

%triggerpostun -- samba < samba-2.0.0
if [ $0 != 0 ]; then
    /sbin/chkconfig --add smb
fi

%files
%doc README COPYING Manifest Read-Manifest-Now
%doc WHATSNEW.txt Roadmap
%doc docs
%doc swat/README
%doc examples
%attr(-,root,root) %{prefix}/sbin/*
%attr(-,root,root) /sbin/*
%attr(-,root,root) %{prefix}/bin/*
%attr(755,root,root) /lib/*
%attr(-,root,root) %{prefix}/share/swat/help/*
%attr(-,root,root) %{prefix}/share/swat/images/*
%attr(-,root,root) %{prefix}/share/swat/include/*
%attr(-,root,root) %{prefix}/share/swat/using_samba/*
%attr(-,root,root) %config(noreplace) /etc/samba/lmhosts
%attr(-,root,root) %config(noreplace) /etc/samba/smb.conf
%attr(-,root,root) %config(noreplace) /etc/samba/smbusers
%attr(-,root,root) /etc/rc.d/init.d/smb
%attr(-,root,root) /etc/logrotate.d/samba
%attr(-,root,root) %config(noreplace) /etc/pam.d/samba
%attr(-,root,root) %{prefix}/share/man/man1/*
%attr(-,root,root) %{prefix}/share/man/man5/*
%attr(-,root,root) %{prefix}/share/man/man7/*
%attr(-,root,root) %{prefix}/share/man/man8/*
%attr(-,root,root) %dir /etc/samba/
%attr(-,root,root) %dir /usr/share/samba/codepages/*
%attr(-,root,root) %dir /usr/share/samba/codepages/src/*
%attr(-,root,root) %dir /var/cache/samba
%attr(-,root,root) %dir /var/log/samba
%attr(1777,root,root) %dir /var/spool/samba



