/* 
   Unix SMB/Netbios implementation.
   Version 1.5.
   Copyright (C) Andrew Tridgell 1992,1993
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef MAX_SERVICES
#define MAX_SERVICES 10
#endif

#ifndef MAX_CONNECTIONS
#define MAX_CONNECTIONS 50
#endif

#ifndef MAX_OPEN_FILES
#define MAX_OPEN_FILES 50
#endif

#ifndef GUEST_ACCOUNT
#define GUEST_ACCOUNT "pcuser"
#endif

#define BUFFER_SIZE 0x7FFF

#ifndef EXTERN
#	define EXTERN extern
#endif

#define True (0==0)
#define False (!True)

typedef unsigned char BOOL;
typedef short int16;
typedef int int32;
typedef unsigned short uint16;
typedef unsigned int uint32;

#ifndef CREATE_MODE
#define CREATE_MODE (0755)
#endif

/* these macros make access to the packet buffers easier. See also the
functions SSVAL() and SIVAL(). */
#define PVAL(buf,pos,type) (*((type *)(buf + pos)))
#define ISWP(x) (NeedSwap? int32_byte_swap((int32)x):(x))
#define SSWP(x) (NeedSwap? int16_byte_swap((int16)x):(x))
#define SCVAL(buf,pos,x) PVAL(buf,pos,unsigned char) = (x)
#define CVAL(buf,pos) PVAL(buf,pos,unsigned char)

#define BSW(x) SSWP(x)
#define BSL(x) ISWP(x)

#define DIR_STRUCT_SIZE 43

/* these define all the command types recognised by the server - there
are lots of gaps so probably there are some rare commands that are not
implemented */
#define pHELLO 114
#define pCONNECT 112
#define pFSTAT 16
#define pDIR 0x81
#define pDFREE 0x80
#define pOPEN 2
#define pCREATE 3
#define pCLOSE 4
#define pREAD 10
#define pWRITE 11
#define pMKDIR 0
#define pRMDIR 1
#define pDELETE 6
#define pGOODBYE 113
#define pACCESS 8
#define pCHMOD 9
#define pRENAME 7
#define pSETDIR '\377'

/* these define the attribute byte as seen by DOS */
#define aRONLY (1L<<0)
#define aHIDDEN (1L<<1)
#define aSYSTEM (1L<<2)
#define aVOLID (1L<<3)
#define aDIR (1L<<4)
#define aARCH (1L<<5)

/* these define some DOS error codes */
#define eINVALID_FUNCTION	1
#define eFILE_NOT_FOUND		2
#define eINVALID_PATH		3
#define eTOO_MANY_FILES_OPEN	4
#define eACCESS_DENIED		5
#define eINVALID_FILE_HANDLE	6
#define eMCB_DESTROYED		7
#define eNOT_ENOUGH_MEMORY	8
#define eMEM_ADDRESS_INVALID	9
#define eENV_STRING_INVALID	10
#define eFORMAT_INVALID		11
#define eACCESS_CODE_INVALID	12
#define eDATA_INVALID		13
#define eINVALID_DRIVE		15
#define eREMOVE_CURRENT_DIR	16
#define eNOT_SAME_DEVICE	17
#define eNO_MORE_FILES		18

#define ERRbadfile 2

/* these structures are used to store the state of the server */
typedef struct
	{
	BOOL available;
	char service[255];
	char path[MAXPATHLEN];
	char username[MAXPATHLEN];
	BOOL read_only;
	BOOL no_set_dir;
	BOOL guest_ok;
	BOOL print_ok;
	BOOL map_system;
	BOOL map_hidden;
	} services_struct;

typedef struct
	{
	BOOL open;
	int cnum;
	int fd;
	char name[MAXPATHLEN];
	} files_struct;

typedef struct
	{
	BOOL open;
	int service;
	int connect_num;
	int uid;
	int gid;
	void *dirptr;
	char dirpath[MAXPATHLEN];
	char connectpath[MAXPATHLEN];
	} connection_struct;


/* these are useful macros for checking validity of handles */
#define VALID_FNUM(fnum) ((fnum >= 0) && (fnum < MAX_OPEN_FILES))
#define OPEN_FNUM(fnum) (VALID_FNUM(fnum) && Files[fnum].open)
#define VALID_CNUM(cnum) ((cnum >= 0) && (cnum < MAX_CONNECTIONS))
#define OPEN_CNUM(cnum) (VALID_CNUM(cnum) && Connections[cnum].open)
#define SNUM(cnum) (Connections[cnum].service)
#define HOME(cnum) (Services[SNUM(cnum)].path)
#define CAN_WRITE(cnum) (OPEN_CNUM(cnum) && !Services[SNUM(cnum)].read_only)
#define VALID_SNUM(snum) ((snum >= 0) && (snum < MAX_SERVICES) && Services[snum].available)
#define GUEST_OK(snum) (VALID_SNUM(snum) && Services[snum].guest_ok)
#define CAN_PRINT(cnum) (OPEN_CNUM(cnum) && Services[SNUM(cnum)].print_ok)
#define MAP_HIDDEN(cnum) (OPEN_CNUM(cnum) && Services[SNUM(cnum)].map_hidden)
#define MAP_SYSTEM(cnum) (OPEN_CNUM(cnum) && Services[SNUM(cnum)].map_system)

/* the basic packet size, assuming no words or bytes */
#define smb_size 39

/* this is how errors are generated */
#define ERROR(class,x) error_packet(inbuf,outbuf,class,x,__LINE__)

/* offsets into message for common items */
#define smb_com 8
#define smb_rcls 9
#define smb_reh 10
#define smb_err 11
#define smb_reb 13
#define smb_tid 28
#define smb_pid 30
#define smb_uid 32
#define smb_mid 34
#define smb_wct 36
#define smb_vwv 37
#define smb_vwv0 37
#define smb_vwv1 39
#define smb_vwv2 41
#define smb_vwv3 43
#define smb_vwv4 45
#define smb_vwv5 47
#define smb_vwv6 49


/* the complete */
#define SMBmkdir      0x00   /* create directory */
#define SMBrmdir      0x01   /* delete directory */
#define SMBopen       0x02   /* open file */
#define SMBcreate     0x03   /* create file */
#define SMBclose      0x04   /* close file */
#define SMBflush      0x05   /* flush file */
#define SMBunlink     0x06   /* delete file */
#define SMBmv         0x07   /* rename file */
#define SMBgetatr     0x08   /* get file attributes */
#define SMBsetatr     0x09   /* set file attributes */
#define SMBread       0x0A   /* read from file */
#define SMBwrite      0x0B   /* write to file */
#define SMBlock       0x0C   /* lock byte range */
#define SMBunlock     0x0D   /* unlock byte range */
#define SMBctemp      0x0E   /* create temporary file */
#define SMBmknew      0x0F   /* make new file */
#define SMBchkpth     0x10   /* check directory path */
#define SMBexit       0x11   /* process exit */
#define SMBlseek      0x12   /* seek */
#define SMBtcon       0x70   /* tree connect */
#define SMBtdis       0x71   /* tree disconnect */
#define SMBnegprot    0x72   /* negotiate protocol */
#define SMBdskattr    0x80   /* get disk attributes */
#define SMBsearch     0x81   /* search directory */
#define SMBsplopen    0xC0   /* open print spool file */
#define SMBsplwr      0xC1   /* write to print spool file */
#define SMBsplclose   0xC2   /* close print spool file */
#define SMBsplretq    0xC3   /* return print queue */
#define SMBsends      0xD0   /* send single block message */
#define SMBsendb      0xD1   /* send broadcast message */
#define SMBfwdname    0xD2   /* forward user name */
#define SMBcancelf    0xD3   /* cancel forward */
#define SMBgetmac     0xD4   /* get machine name */
#define SMBsendstrt   0xD5   /* send start of multi-block message */
#define SMBsendend    0xD6   /* send end of multi-block message */
#define SMBsendtxt    0xD7   /* send text of multi-block message */


#define SUCCESS 0  /* The request was successful. */
#define ERRDOS 0x01 /*  Error is from the core DOS operating system set. */
#define ERRSRV 0x02  /* Error is generated by the server network file manager.*/
#define ERRHRD 0x03  /* Error is an hardware error. */
#define ERRCMD 0xFF  /* Command was not in the "SMB" format. */


#define ERRnosupport 0xFFFF
#define ERRinvnid 5

#ifdef USE_DIRECT
#define DIRECT direct
#else
#define DIRECT dirent
#endif


/* and a few prototypes */
char *smb_buf();
BOOL strequal(char *,char *);
BOOL mask_match(char *,char *,BOOL );
int dos_mode(int ,char *,mode_t );
char *timestring();
uint16 SVAL(char *,int );

#ifdef SUN
struct DIRECT *readdir();
char *strcpy();
int fprintf();
#endif

char *mktemp();
int setreuid();
int setregid();
int closedir();
char *getpass();
#ifndef PWD_AUTH
#ifndef crypt
char *crypt();
#endif
#endif


#ifdef STRING_DEBUG
#define strcpy mystrcpy
#define strchr mystrchr
#define strrchr mystrrchr
#define strlen mystrlen
#define strncpy mystrncpy
#define strcat mystrcat
#define memcpy mymemcpy
#define memset mymemset
#endif

#ifndef MIN
#define MIN(a,b) ((a)<(b)?(a):(b))
#endif
#ifndef MAX
#define MAX(a,b) ((a)>(b)?(a):(b))
#endif

#ifndef SIGNAL_CAST
#define SIGNAL_CAST
#endif
