#include "includes.h"

/* #define DEBUG(l,m) (l <= DEBUGLEVEL) && printf m */

extern pstring scope;
extern int DEBUGLEVEL;

char *nb_whats_your_name(int fd,char *ip_addr)
{
  BOOL found=False;
  int retries = 2;
  int retry_time = 5000;
  struct timeval tval;
  struct packet_struct p;
  struct packet_struct *p2;
  struct nmb_packet *nmb = &p.packet.nmb;
  static int name_trn_id = 0;
  struct in_addr to_ip;

  memcpy(&to_ip,ip_addr,4);

  DEBUG(3,("nb_whats_your_name(%d,<%s>)\n",fd,inet_ntoa(to_ip)));

  bzero((char *)&p,sizeof(p));

  if (!name_trn_id) name_trn_id = (time(NULL)%(unsigned)0x7FFF) + 
		      (getpid()%(unsigned)100);
  name_trn_id = (name_trn_id+1) % (unsigned)0x7FFF;

  nmb->header.name_trn_id = name_trn_id;
  nmb->header.opcode = 0;
  nmb->header.response = False;
  nmb->header.nm_flags.bcast = False;
  nmb->header.nm_flags.recursion_available = False;
  nmb->header.nm_flags.recursion_desired = False;
  nmb->header.nm_flags.trunc = False;
  nmb->header.nm_flags.authoritative = False;
  nmb->header.rcode = 0;
  nmb->header.qdcount = 1;
  nmb->header.ancount = 0;
  nmb->header.nscount = 0;
  nmb->header.arcount = 0;

  make_nmb_name(&nmb->question.question_name,"*",0,scope);

  nmb->question.question_type = 0x21;
  nmb->question.question_class = 0x1;

  p.ip = to_ip;
  p.port = NMB_PORT;
  p.fd = fd;
  p.timestamp = time(NULL);
  p.packet_type = NMB_PACKET;

  GetTimeOfDay(&tval);

  if (!send_packet(&p)) 
    return(False);

  retries--;

  while (1)
    {
      struct timeval tval2;
      GetTimeOfDay(&tval2);
      if (TvalDiff(&tval,&tval2) > retry_time) {
	if (!retries) break;
	if (!found && !send_packet(&p))
	  return False;
	GetTimeOfDay(&tval);
	retries--;
      }

      if ((p2=receive_packet(fd,NMB_PACKET,90))) {
	struct nmb_packet *nmb2 = &p2->packet.nmb;
	debug_nmb_packet(p2);

	DEBUG(4,("Got a packet\n"));
	if (!(nmb->header.name_trn_id != nmb2->header.name_trn_id ||
	    !nmb2->header.response ||
	    nmb2->header.opcode != 0 || nmb2->header.nm_flags.bcast ||
	    nmb2->header.rcode || !nmb2->header.ancount ||
	    nmb2->answers->rr_type != 0x21)) { 
	  /* The packet's for us! */
	  char *p = &nmb2->answers->rdata[0];
	  int numnames = CVAL(p,0);
	  DEBUG(4,("It's for us! (%d names)\n",numnames));
	  p++;
          while (numnames--) {
	    char qname[17];
	    char *c;
	    int type;
	    StrnCpy(qname,p,15);
	    type = CVAL(p,15);
	    p += 16;
	    if ((type == 0) && !(p[0]&0x80)) {
	      /* This is the one we want!  Pack it up, clean up, and
	       return */
	      free_packet(p2);
	      for (c = qname; *c && !isspace(*c); c++)
		*c = tolower(*c);
	      *c = '\0';
	      return strdup(qname);
	    }
	  }
	}
	free_packet(p2);
      }
    }
  return NULL;
}
