/* LinPopUp - A Linux enhanced port of Winpopup, running over Samba.
 * Coded by Jean-Marc Jacquet <jeanmarcj@usa.net>
 * Copyright (C) 1998 Little Igloo Org  http://www.chez.com/littleigloo
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <string.h>
#include "protos.h"



static int
samba_post (gchar * header_text, gchar * message_text)
{
  FILE *output;
  gchar command_line[2048];
  gchar buf_line[80];
  char c;
  int i = 0;

  /* -- launch smbclient and read output from pipe -- */
  sprintf (command_line, "echo -e \"%s\" | smbclient -M %s", message_text, header_text);
  output = popen (command_line, "r");
  while ((c = getc (output)) != EOF)
    command_line[i++] = c;
  command_line[i] = 0;
  pclose (output);

  /* -- sommaire investigation of the output -- */
  if (strstr (command_line, "nknown host"))
    {
      sprintf (buf_line, "\n\nUnknown host : %s", header_text);
      alert_ok ("Error", buf_line, "ok");
      return FALSE;
    }
  if (strstr (command_line, "error connecting to"))
    {
      sprintf (buf_line, "\n\nHost unreachable: %s", header_text);
      alert_ok ("Error", buf_line, "ok");
      return FALSE;
    }
  if (strstr (command_line, "Control-D\nsent") && strstr (command_line, "bytes (status was"))
    {
      alert_ok ("LinPopUp", "\n\nMessage succesfully sent.", "ok");
      return TRUE;
    }

  alert_ok_text (command_line);
  return TRUE;
}



static void
send_send (GtkWidget * widget, gpointer * data)
{
  GtkWidget *send_window;
  GtkWidget *send_text;
  GtkWidget *send_header;
  gchar *header_text;
  gchar *message_text;

/*-- retrieving send_header and send_text data previously marqued with gtk_object_set_data(...) --*/
  send_window = gtk_widget_get_toplevel (widget);
  send_header = gtk_object_get_data (GTK_OBJECT (send_window), "send_header");
  send_text = gtk_object_get_data (GTK_OBJECT (send_window), "send_text");

  /* -- retrieving header text, and checking for a  destinataire -- */
  if (!strlen (header_text = gtk_entry_get_text (GTK_ENTRY (send_header))))
    {
      alert_ok (" Error", "\nPlease enter a destinataire.", "Ok");
      return;
    }

  /* -- retrieving message text -- */
  message_text = gtk_editable_get_chars (GTK_EDITABLE (send_text), 0, -1);

  /* -- cowardly posting it via samba, and close the send window in many case-- */
  if (samba_post (header_text, message_text))
    gtk_widget_destroy (send_window);
}



static void
send_cancel (GtkWidget * widget, gpointer * data)
{
  GtkWidget *send_window;
  GtkWidget *send_text;

/*-- retrieving send_text data previously marqued with gtk_object_set_data(...) --*/
  send_window = gtk_widget_get_toplevel (widget);
  send_text = gtk_object_get_data (GTK_OBJECT (send_window), "send_text");

  /* -- if a message was entered, asking for confirmation -- */
  if (gtk_text_get_length (GTK_TEXT (send_text)))
    if (alert_dialog ("", "\nA new message was entered.\n\nCancel anyway ?", "Yes", "No", 2) == 2)
      return;

  gtk_widget_destroy (send_window);
}


void
reply_message (void)
{

  if (current_showed_message)
    {
      is_it_a_reply = TRUE;
      send_message ();
    }
}


void
send_message (void)
{
  GtkWidget *send_window;
  GtkWidget *send_vbox;
  GtkWidget *send_statusbar;
  GtkWidget *send_frame;
  GtkWidget *send_table;
  GtkWidget *send_button_send;
  GtkWidget *send_button_cancel;
  GtkWidget *send_header;
  GtkWidget *send_text;
  GtkWidget *send_label;
  int send_context_id;
  gint x, y;


  /* -- First, the window -- */
  send_window = gtk_window_new (GTK_WINDOW_DIALOG);

  gtk_widget_set_usize (GTK_WIDGET (send_window), 425, 400);
  gtk_widget_realize (send_window);
  gtk_window_set_title (GTK_WINDOW (send_window), "LinPopUp");
  gtk_container_border_width (GTK_CONTAINER (send_window), 1);
  gdk_window_get_origin (window->window, &x, &y);
  gtk_widget_set_uposition (send_window, x, y);

  /* -- Vbox as container -- */
  send_vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (send_window), send_vbox);
  gtk_widget_show (send_vbox);

  /* -- Top frame first packed to the vbox -- */
  send_frame = gtk_frame_new (NULL);
  gtk_frame_set_label (GTK_FRAME (send_frame), " Send to :  ");
  gtk_container_border_width (GTK_CONTAINER (send_frame), 2);
  gtk_frame_set_shadow_type (GTK_FRAME (send_frame), GTK_SHADOW_ETCHED_IN);
  gtk_box_pack_start (GTK_BOX (send_vbox), send_frame, FALSE, TRUE, 0);

  /* -- Creating frame's widgets -- */
  send_header = gtk_entry_new ();
  gtk_entry_set_editable (GTK_ENTRY (send_header), 1);
  gtk_object_set_data (GTK_OBJECT (send_window), "send_header", send_header);
  gtk_widget_show (send_header);

  send_button_send = gtk_button_new_with_label ("Send");
  gtk_signal_connect (GTK_OBJECT (send_button_send), "clicked",
		      GTK_SIGNAL_FUNC (send_send), NULL);
  gtk_widget_show (send_button_send);

  send_button_cancel = gtk_button_new_with_label ("Cancel");
  gtk_signal_connect (GTK_OBJECT (send_button_cancel), "clicked",
		      GTK_SIGNAL_FUNC (send_cancel), NULL);
  gtk_widget_show (send_button_cancel);

/*-- attaching frame's widget to a table, and packing it to the frame --*/
  send_table = gtk_table_new (2, 4, TRUE);
  gtk_table_set_col_spacings (GTK_TABLE (send_table), 5);
  gtk_table_set_row_spacings (GTK_TABLE (send_table), 5);
  gtk_container_border_width (GTK_CONTAINER (send_table), 10);
  gtk_table_attach (GTK_TABLE (send_table), send_header, 0, 3, 0, 1,
		    GTK_FILL,
		    GTK_FILL, 0, 0);
  gtk_table_attach (GTK_TABLE (send_table), send_button_send, 3, 4, 0, 1,
		    GTK_FILL,
		    GTK_FILL, 0, 0);
  gtk_table_attach (GTK_TABLE (send_table), send_button_cancel, 3, 4, 1, 2,
		    GTK_FILL | GTK_EXPAND, GTK_FILL, 0, 0);
  gtk_container_add (GTK_CONTAINER (send_frame), send_table);
  gtk_widget_show (send_table);
  gtk_widget_show (send_frame);

  /* -- below the top frame creating a text area via create_text defined in text.c -- */
  send_label = gtk_label_new ("  Message :");
  gtk_misc_set_alignment (GTK_MISC (send_label), 0, 0);
  gtk_box_pack_start (GTK_BOX (send_vbox), send_label, FALSE, FALSE, 0);
  gtk_widget_show (send_label);

  send_text = create_text (send_vbox);
  gtk_text_set_editable (GTK_TEXT (send_text), 1);
  gtk_object_set_data (GTK_OBJECT (send_window), "send_text", send_text);

  /* -- and finally a statusbar -- */
  send_statusbar = gtk_statusbar_new ();
  gtk_box_pack_start (GTK_BOX (send_vbox), send_statusbar, FALSE, TRUE, 0);
  gtk_widget_show (send_statusbar);
  send_context_id = gtk_statusbar_get_context_id (GTK_STATUSBAR (send_statusbar), " ");

  gtk_widget_show (send_window);

  /* -- connecting the send_cancel function to the delete event -- */
  gtk_signal_connect (GTK_OBJECT (send_window), "delete_event", GTK_SIGNAL_FUNC (send_cancel), NULL);



  /* -- If this a reply, fill the destination and text field -- */
  if (is_it_a_reply)
    {
      struct linpopup_message this_message;
      char buf[2045];
      int char_pos_text, char_pos_buf;
      GdkColormap *colormap;
      static GdkColor text_fg =
      {0, 0x8080, 0x0000, 0x0000};

      read_message (current_showed_message, &this_message);
      gtk_entry_set_text (GTK_ENTRY (send_header), this_message.host);	//We answer to a host not to a user

      sprintf (buf, "%s on %s %s \n---\n", this_message.sender, this_message.host, wrote);
      gtk_text_freeze (GTK_TEXT (send_text));
      gtk_text_insert (GTK_TEXT (send_text), NULL, &send_text->style->black, NULL, buf, -1);

      char_pos_buf = 0;
      buf[char_pos_buf++] = user_rc.quote;
      buf[char_pos_buf++] = 32;

      for (char_pos_text = 0; char_pos_text < strlen (this_message.text); char_pos_text++)
	{
	  buf[char_pos_buf++] = this_message.text[char_pos_text];
	  if (this_message.text[char_pos_text] == 10)
	    {
	      buf[char_pos_buf++] = user_rc.quote;
	      buf[char_pos_buf++] = 32;
	    }
	}
      buf[char_pos_buf] = 0;

      /* -- quoted text appears in red -- */
      colormap = gtk_widget_get_colormap (send_window);
      gdk_color_alloc (colormap, &text_fg);
      gtk_text_insert (GTK_TEXT (send_text), NULL, &text_fg, NULL, buf, -1);
      gtk_text_insert (GTK_TEXT (send_text), NULL, &send_text->style->black, NULL, "\n\n", -1);

      gtk_text_thaw (GTK_TEXT (send_text));
      gtk_text_set_editable (GTK_TEXT (send_text), 1);
      gtk_widget_grab_focus (send_text);

      is_it_a_reply = FALSE;
    }
}
