
#ifndef _PI_TOOLS_
#define _PI_TOOLS_

///////////////////////////////////////////////////////////////////////
//
// Breeze Designer Plug-In Tools
// Written by Neville Richards
//
///////////////////////////////////////////////////////////////////////

#ifndef _BREEZE_PLUGIN_
#include "plugin.h"
#endif

#ifdef __cplusplus
extern "C" {            /* Assume C declarations for C++ */
#endif	/* __cplusplus */

///////////////////////////////////////////////////////////////////////
//
// Debugging Routines
//
///////////////////////////////////////////////////////////////////////

#ifdef _DEBUG
extern void FAR cdecl pitTracePrintf(LPSTR lpFmt, ...);
extern void FAR cdecl pitTracePrintfF( LPSTR lpFmt, ...);

#define TRACE pitTracePrintf
#define TRACEF pitTracePrintfF
#define ASSERT(p) if(!(p)) TracePrintf(" ASSERTion failed: %s\n", (LPSTR)#p);

#else
extern void FAR cdecl TracePrintf(LPSTR lpFmt, ...);
extern void FAR cdecl TracePrintfF( LPSTR lpFmt, ...);

#define TRACE 1 ? (void)0: TracePrintf
#define TRACEF 1 ? (void)0: TracePrintf
#define ASSERT(p)
#endif

typedef PointXYZ Point3d;

//
// Interface functions
//
extern HCADOBJECT  piCreateObject( LPSTR szObjectName, UINT nObjectType );
extern HCADOBJECT  piGetObject( HCADOBJECT hCadObject, UINT bFlags );
extern HCADOBJECT  piCreateDefaultObject( UINT nObjectType );
extern BOOL        piFreeObject( HCADOBJECT hCadObject );
extern BOOL        piSetObjectAttrib( HCADOBJECT hCadObject, UINT nAttribute, LPXYZ pAttribute );
extern BOOL        piSetObjectTexture( HCADOBJECT hCadObject, LPSTR szTexture );
extern BOOL        piDeleteObject( HCADOBJECT hCadObject );
extern BOOL        piDeleteGeometry( HCADOBJECT hCadObject );
extern BOOL        piGetGeometry( HCADOBJECT hCadObject, UINT nFirstNext, LPXYZ lpPoints );
extern BOOL        piPutGeometry( HCADOBJECT hCadObject, UINT nPoints, LPXYZ lpPoints );
extern BOOL        piMove( LPXYZ pMove );
extern BOOL        piScale( LPXYZ pScale );
extern BOOL        piRotate( LPXYZ pRotate );
extern BOOL        piSetCursor( LPXYZ pPosition );
extern BOOL        piAnimSetObject( HCADOBJECT hCadObject );
extern BOOL        piAnimCreate( LPSTR szProjectName, UINT mMaxFrames );
extern UINT        piAnimGetMaxFrame( void );
extern BOOL        piAnimSetFrame( UINT nFrame  );
extern BOOL        piAnimGotoFrame( UINT nFrame  );
extern UINT        piAnimGetCurrentFrame();
extern BOOL        piRedraw( void );
extern BOOL        piErrorMessage( LPSTR szError );
extern BOOL        piLibInit( UINT nVersion, LPPLUGININFO lpInfo, LPPIFNS lpFunctions, UINT nFunctions );
extern BOOL        piLibFuncInit( DWORD nOperation, LPVOID lpLocalData, LPVOID lpData, UINT nMode );

#ifdef __cplusplus
}                       /* End of extern "C" { */
#endif	/* __cplusplus */

#endif





