#include "precomp.h"
#include "cedit.h"

#define HANDLE_MESSAGE( msg, method )\
		case msg: { ASSERT( pCtrl != NULL ); return pCtrl->##method( wParam, lParam ); }

LRESULT PASCAL EditCtrlWndProc(HWND hWnd, register UINT uMsg, register WPARAM wParam, register LPARAM lParam)
{
	CEdit *pCtrl = (CEdit *)GetWindowLong(hWnd, 0);
	switch ( uMsg )
	{
		case WM_CREATE:
			{
				ASSERT( pCtrl == NULL );
				return CEdit::OnCreate( hWnd, wParam, lParam );
			}

		HANDLE_MESSAGE( WM_NCDESTROY, OnNcDestroy );
		HANDLE_MESSAGE( WM_DESTROY, OnDestroy );
		HANDLE_MESSAGE( WM_ERASEBKGND, OnEraseBkGnd );
		HANDLE_MESSAGE( WM_PAINT, OnPaint );
		HANDLE_MESSAGE( WM_SIZE, OnSize );
		HANDLE_MESSAGE( WM_SETFONT, OnSetFont );
		HANDLE_MESSAGE( WM_GETFONT, OnGetFont );
		HANDLE_MESSAGE( WM_SETFOCUS, OnSetFocus );
		HANDLE_MESSAGE( WM_KILLFOCUS, OnKillFocus );
		HANDLE_MESSAGE( WM_LBUTTONDOWN, OnLButtonDown );
		HANDLE_MESSAGE( WM_RBUTTONDOWN, OnRButtonDown );
		HANDLE_MESSAGE( WM_MBUTTONDOWN, OnMButtonDown);
		HANDLE_MESSAGE( WM_LBUTTONUP, OnLButtonUp );
		HANDLE_MESSAGE( WM_RBUTTONUP, OnRButtonUp );
		HANDLE_MESSAGE( WM_MBUTTONUP, OnMButtonUp );
		HANDLE_MESSAGE( WM_MOUSEMOVE, OnMouseMove );
		HANDLE_MESSAGE( WM_LBUTTONDBLCLK, OnLButtonDblClk );
		HANDLE_MESSAGE( WM_RBUTTONDBLCLK, OnRButtonDblClk );
		HANDLE_MESSAGE( WM_MBUTTONDBLCLK, OnMButtonDblClk );
		HANDLE_MESSAGE( WM_HSCROLL, OnHScroll );
		HANDLE_MESSAGE( WM_VSCROLL, OnVScroll );
		HANDLE_MESSAGE( WM_KEYDOWN, OnKeyDown );
		HANDLE_MESSAGE( WM_KEYUP, OnKeyUp );
		HANDLE_MESSAGE( WM_SYSKEYDOWN, OnSysKeyDown );
		HANDLE_MESSAGE( WM_SYSKEYUP, OnSysKeyUp );
		HANDLE_MESSAGE( WM_SYSCHAR, OnSysChar );
		HANDLE_MESSAGE( WM_CHAR, OnChar );
		HANDLE_MESSAGE( WM_SETCURSOR, OnSetCursor );
		HANDLE_MESSAGE( WM_TIMER, OnTimer );
		HANDLE_MESSAGE( WM_CONTEXTMENU, OnContextMenu );
		HANDLE_MESSAGE( WM_MOUSEWHEEL, OnMouseWheel );
		HANDLE_MESSAGE( WM_ENABLE, OnEnable );
		HANDLE_MESSAGE( WM_GETDLGCODE, OnGetDlgCode );
		HANDLE_MESSAGE( WM_SYSCOLORCHANGE, OnSysColorChange );

		// custom messages
		HANDLE_MESSAGE( CMM_SETLANGUAGE, OnSetLanguage );
		HANDLE_MESSAGE( CMM_GETLANGUAGE, OnGetLanguage );
		HANDLE_MESSAGE( CMM_ENABLECOLORSYNTAX, OnEnableColorSyntax );
		HANDLE_MESSAGE( CMM_ISCOLORSYNTAXENABLED, OnIsColorSyntaxEnabled );
		HANDLE_MESSAGE( CMM_OPENFILE, OnOpenFile );
		HANDLE_MESSAGE( CMM_INSERTFILE, OnInsertFile );
		HANDLE_MESSAGE( CMM_INSERTTEXT, OnInsertText );
		HANDLE_MESSAGE( WM_SETTEXT, OnSetText );
		HANDLE_MESSAGE( CMM_SETTEXT, OnSetText );
		HANDLE_MESSAGE( CMM_SETCOLORS, OnSetColors );
		HANDLE_MESSAGE( CMM_GETCOLORS, OnGetColors );
		HANDLE_MESSAGE( CMM_ENABLEWHITESPACEDISPLAY, OnEnableWhitespaceDisplay );
		HANDLE_MESSAGE( CMM_ISWHITESPACEDISPLAYENABLED, OnIsWhitespaceDisplayEnabled );
		HANDLE_MESSAGE( CMM_ENABLETABEXPAND, OnEnableTabExpand );
		HANDLE_MESSAGE( CMM_ISTABEXPANDENABLED, OnIsTabExpandEnabled );
		HANDLE_MESSAGE( CMM_ENABLESMOOTHSCROLLING, OnEnableSmoothScrolling );
		HANDLE_MESSAGE( CMM_ISSMOOTHSCROLLINGENABLED, OnIsSmoothScrollingEnabled );
		HANDLE_MESSAGE( CMM_SETTABSIZE, OnSetTabSize );
		HANDLE_MESSAGE( CMM_GETTABSIZE, OnGetTabSize );
		HANDLE_MESSAGE( CMM_SETREADONLY, OnSetReadOnly );
		HANDLE_MESSAGE( CMM_ISREADONLY, OnIsReadOnly );
		HANDLE_MESSAGE( CMM_ENABLELINETOOLTIPS, OnEnableLineToolTips );
		HANDLE_MESSAGE( CMM_ISLINETOOLTIPSENABLED, OnIsLineToolTipsEnabled );
		HANDLE_MESSAGE( CMM_ENABLELEFTMARGIN, OnEnableLeftMargin );
		HANDLE_MESSAGE( CMM_ISLEFTMARGINENABLED, OnIsLeftMarginEnabled );
		HANDLE_MESSAGE( CMM_SAVEFILE, OnSaveFile );
		HANDLE_MESSAGE( CMM_REPLACETEXT, OnReplaceText );
		HANDLE_MESSAGE( CMM_GETTEXTLENGTH, OnGetTextLength );
		HANDLE_MESSAGE( CMM_GETTEXT, OnGetText );
		HANDLE_MESSAGE( CMM_GETLINECOUNT, OnGetLineCount );
		HANDLE_MESSAGE( CMM_GETLINE, OnGetLine );
		HANDLE_MESSAGE( CMM_GETLINELENGTH, OnGetLineLength );
		HANDLE_MESSAGE( CMM_GETWORD, OnGetWord );
		HANDLE_MESSAGE( CMM_GETWORDLENGTH, OnGetWordLength );
		HANDLE_MESSAGE( CMM_ADDTEXT, OnAddText );
		HANDLE_MESSAGE( CMM_DELETELINE, OnDeleteLine );
		HANDLE_MESSAGE( CMM_INSERTLINE, OnInsertLine );
		HANDLE_MESSAGE( CMM_GETSEL, OnGetSel );
		HANDLE_MESSAGE( CMM_SETSEL, OnSetSel );
		HANDLE_MESSAGE( CMM_DELETESEL, OnDeleteSel );
		HANDLE_MESSAGE( CMM_REPLACESEL, OnReplaceSel );
		HANDLE_MESSAGE( CMM_EXECUTECMD, OnExecuteCmd );
		HANDLE_MESSAGE( CMM_SETSPLITTERPOS, OnSetSplitterPos );
		HANDLE_MESSAGE( CMM_GETSPLITTERPOS, OnGetSplitterPos );
		HANDLE_MESSAGE( CMM_SETAUTOINDENTMODE, OnSetAutoIndentMode );
		HANDLE_MESSAGE( CMM_GETAUTOINDENTMODE, OnGetAutoIndentMode );
		HANDLE_MESSAGE( CMM_CANCUT, OnCanCut );
		HANDLE_MESSAGE( CMM_CANCOPY, OnCanCopy );
		HANDLE_MESSAGE( CMM_CANPASTE, OnCanPaste );
		HANDLE_MESSAGE( CMM_CUT, OnCut );
		HANDLE_MESSAGE( CMM_COPY, OnCopy );
		HANDLE_MESSAGE( CMM_PASTE, OnPaste );
		HANDLE_MESSAGE( CMM_CANUNDO, OnCanUndo );
		HANDLE_MESSAGE( CMM_CANREDO, OnCanRedo );
		HANDLE_MESSAGE( CMM_REDO, OnRedo );
		HANDLE_MESSAGE( CMM_UNDO, OnUndo );
		HANDLE_MESSAGE( CMM_CLEARUNDOBUFFER, OnClearUndoBuffer );
		HANDLE_MESSAGE( CMM_SETUNDOLIMIT, OnSetUndoLimit );
		HANDLE_MESSAGE( CMM_GETUNDOLIMIT, OnGetUndoLimit );
		HANDLE_MESSAGE( CMM_ISMODIFIED, OnIsModified );
		HANDLE_MESSAGE( CMM_SETMODIFIED, OnSetModified );
		HANDLE_MESSAGE( CMM_ENABLEOVERTYPE, OnEnableOvertype );
		HANDLE_MESSAGE( CMM_ISOVERTYPEENABLED, OnIsOvertypeEnabled );
		HANDLE_MESSAGE( CMM_ENABLECASESENSITIVE, OnEnableCaseSensitive );
		HANDLE_MESSAGE( CMM_ISPRESERVECASEENABLED, OnIsPreserveCaseEnabled );
		HANDLE_MESSAGE( CMM_ENABLEPRESERVECASE, OnEnablePreserveCase );
		HANDLE_MESSAGE( CMM_ISCASESENSITIVEENABLED, OnIsCaseSensitiveEnabled );
		HANDLE_MESSAGE( CMM_ENABLEWHOLEWORD, OnEnableWholeWord );
		HANDLE_MESSAGE( CMM_ISWHOLEWORDENABLED, OnIsWholeWordEnabled );
		HANDLE_MESSAGE( CMM_ENABLEREGEXP, OnEnableRegExp );
		HANDLE_MESSAGE( CMM_ISREGEXPENABLED, OnIsRegExpEnabled );
		HANDLE_MESSAGE( CMM_SETTOPINDEX, OnSetTopIndex );
		HANDLE_MESSAGE( CMM_GETTOPINDEX, OnGetTopIndex );
		HANDLE_MESSAGE( CMM_GETVISIBLELINECOUNT, OnGetVisibleLineCount );
		HANDLE_MESSAGE( CMM_ENABLECRLF, OnEnableCRLF );
		HANDLE_MESSAGE( CMM_ISCRLFENABLED, OnIsCRLFEnabled );
		HANDLE_MESSAGE( CMM_SETFONTOWNERSHIP, OnSetFontOwnership );
		HANDLE_MESSAGE( CMM_GETFONTOWNERSHIP, OnGetFontOwnership );
		HANDLE_MESSAGE( CMM_GETCURRENTVIEW, OnGetCurrentView );
		HANDLE_MESSAGE( CMM_GETVIEWCOUNT, OnGetViewCount );
		HANDLE_MESSAGE( CMM_SHOWSCROLLBAR, OnShowScrollBar );
		HANDLE_MESSAGE( CMM_HASSCROLLBAR, OnHasScrollBar );
		HANDLE_MESSAGE( CMM_GETSELFROMPOINT, OnGetSelFromPoint );
		HANDLE_MESSAGE( CMM_SELECTLINE, OnSelectLine );
		HANDLE_MESSAGE( CMM_HITTEST, OnHitTest );
		HANDLE_MESSAGE( CMM_ENABLEDRAGDROP, OnEnableDragDrop );
		HANDLE_MESSAGE( CMM_ISDRAGDROPENABLED, OnIsDragDropEnabled );
		HANDLE_MESSAGE( CMM_ENABLESPLITTER, OnEnableSplitter );
		HANDLE_MESSAGE( CMM_ISSPLITTERENABLED, OnIsSplitterEnabled );
		HANDLE_MESSAGE( CMM_ENABLECOLUMNSEL, OnEnableColumnSel );
		HANDLE_MESSAGE( CMM_ISCOLUMNSELENABLED, OnIsColumnSelEnabled );
		HANDLE_MESSAGE( CMM_ENABLEGLOBALPROPS, OnEnableGlobalProps );
		HANDLE_MESSAGE( CMM_ISGLOBALPROPSENABLED, OnIsGlobalPropsEnabled );
		HANDLE_MESSAGE( CMM_ISRECORDINGMACRO, OnIsRecordingMacro );
		HANDLE_MESSAGE( CMM_ISPLAYINGMACRO, OnIsPlayingMacro );
		HANDLE_MESSAGE( CMM_SETDLGPARENT, OnSetDlgParent );
		HANDLE_MESSAGE( CMM_ENABLESELBOUNDS, OnEnableSelBounds );
		HANDLE_MESSAGE( CMM_ISSELBOUNDSENABLED, OnIsSelBoundsEnabled );
		HANDLE_MESSAGE( CMM_SETFONTSTYLES, OnSetFontStyles );
		HANDLE_MESSAGE( CMM_GETFONTSTYLES, OnGetFontStyles );
		HANDLE_MESSAGE( CMM_SETITEMDATA, OnSetItemData );
		HANDLE_MESSAGE( CMM_GETITEMDATA, OnGetItemData );
		HANDLE_MESSAGE( CMM_SETLINESTYLE, OnSetLineStyle );
		HANDLE_MESSAGE( CMM_GETLINESTYLE, OnGetLineStyle );
		HANDLE_MESSAGE( CMM_SETBOOKMARK, OnSetBookmark );
		HANDLE_MESSAGE( CMM_GETBOOKMARK, OnGetBookmark );
		HANDLE_MESSAGE( CMM_SETALLBOOKMARKS, OnSetAllBookmarks );
		HANDLE_MESSAGE( CMM_GETALLBOOKMARKS, OnGetAllBookmarks );
		HANDLE_MESSAGE( CMM_SETLINENUMBERING, OnSetLineNumbering );
		HANDLE_MESSAGE( CMM_GETLINENUMBERING, OnGetLineNumbering );
		HANDLE_MESSAGE( CMM_POSFROMCHAR, OnPosFromChar );
		HANDLE_MESSAGE( CMM_ENABLEHIDESEL, OnEnableHideSel );
		HANDLE_MESSAGE( CMM_ISHIDESELENABLED, OnIsHideSelEnabled );
		HANDLE_MESSAGE( CMM_SETHIGHLIGHTEDLINE, OnSetHighlightedLine );
		HANDLE_MESSAGE( CMM_GETHIGHLIGHTEDLINE, OnGetHighlightedLine );
		HANDLE_MESSAGE( CMM_ENABLENORMALIZECASE, OnEnableNormalizeCase );
		HANDLE_MESSAGE( CMM_ISNORMALIZECASEENABLED, OnIsNormalizeCaseEnabled );
		HANDLE_MESSAGE( CMM_SETDIVIDER, OnSetDivider );
		HANDLE_MESSAGE( CMM_GETDIVIDER, OnGetDivider );
		HANDLE_MESSAGE( CMM_ENABLEOVERTYPECARET, OnEnableOvertypeCaret );
		HANDLE_MESSAGE( CMM_ISOVERTYPECARETENABLED, OnIsOvertypeCaretEnabled );
		HANDLE_MESSAGE( CMM_SETFINDTEXT, OnSetFindText );
		HANDLE_MESSAGE( CMM_GETFINDTEXT, OnGetFindText );
		HANDLE_MESSAGE( CMM_SETREPLACETEXT, OnSetReplaceText );
		HANDLE_MESSAGE( CMM_GETREPLACETEXT, OnGetReplaceText );
		HANDLE_MESSAGE( CMM_SETIMAGELIST, OnSetImageList );
		HANDLE_MESSAGE( CMM_GETIMAGELIST, OnGetImageList );
		HANDLE_MESSAGE( CMM_SETMARGINIMAGES, OnSetMarginImages );
		HANDLE_MESSAGE( CMM_GETMARGINIMAGES, OnGetMarginImages );
		HANDLE_MESSAGE( CMM_ABOUTBOX, OnAboutBox );
		HANDLE_MESSAGE( CMM_PRINT, OnPrint );
		HANDLE_MESSAGE( CMM_SETCARETPOS, OnSetCaretPos );
		HANDLE_MESSAGE( CMM_VIEWCOLTOBUFFERCOL, OnViewColToBufferCol );
		HANDLE_MESSAGE( CMM_BUFFERCOLTOVIEWCOL, OnBufferColToViewCol );
		HANDLE_MESSAGE( CMM_SETBORDERSTYLE, OnSetBorderStyle );
		HANDLE_MESSAGE( CMM_GETBORDERSTYLE, OnGetBorderStyle );
		HANDLE_MESSAGE( CMM_GETCURRENTTOKEN, OnGetCurrentToken );
	}
	return DefWindowProc(hWnd, uMsg, wParam, lParam);
}
