//	Persistence of Vision Ray Tracer Scene Description File
#version unofficial MegaPov 0.4;

/*
   Three Lenses 3
   Photon Mapping Test Scene
   Nathan Kopp
   Spring, 1999
   
   This version has three light sources with refraction on/unspecified/off and
   three lenses with refraction on/unspecifed/off.
   
   woods.inc and woodmaps.inc have been modified by changing
   rgbf to rgbt for my version of layered textures.
*/

#include "colors.inc"
#include "woods.inc"

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  photons {
	spacing 0.02
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera StdCam
  location  <      1.287+1.5,     -17.525*.75,      16.135*.75>
  direction <        0.0,         0.0,      1.8317> // Aperture is 0.53 degrees
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33333,         0.0,         0.0> // Aspect ratio
  look_at   <      3.189-1.5,      -1.209-.5,      -0.215>
}

//
// *******  L I G H T S *******
//

light_source {   // Light1
  <-12, 2, 2>
  color rgb <1.000, 0.000, 0.000>*200
  fade_distance 1
  fade_power 2
  photons{refraction off}
}
light_source {   // Light1
  <-12, 0, 2>
  color rgb <0.000, 1.000, 0.000>*200
  fade_distance 1
  fade_power 2
}
light_source {   // Light1
  <-12, -2, 2>
  color rgb <0.000, 0.000, 1.000>*200
  fade_distance 1.2	//1
  fade_power 2
  photons{refraction on}
}

//
// ********  TEXTURES  *******
//

#declare Glass1 = 
   material  {		// Glass1
      texture {      
         pigment { color rgbf <1.0, 1.0, 1.0, 0.7> }      
         finish {
            ambient 0.0
            diffuse 0.0
            specular 1.0
            roughness 0.001
            reflection 0.1
         }
      }   
      interior { ior 1.5 }
   }
//
// ********  REFERENCED OBJECTS  *******
//

#declare Lens1 = intersection { // Lens1
  sphere { // Sphere001
    <0,0,0>,1
    scale <0.5, 1.0, 1.0>
    translate  -0.25*x
  }
  sphere { // Sphere002
    <0,0,0>,1
    scale <0.5, 1.0, 1.0>
    translate  0.25*x
  }
  scale 2.0
}

//
// ********  OBJECTS  *******
//

object { // Lens4->Lens1
  Lens1
  material { Glass1 }
  translate  -4*y
  photons {
	target 0.8
    refraction on
  }
}

object { // Lens3->Lens1
  Lens1
  material { Glass1 }
  photons {
	target 0.8
  }
}

object { // Lens2->Lens1
  Lens1
  material { Glass1 }
  translate  <0,4, 0.0>
  photons {
	target 0.8
    refraction off
  }
}

box { // Floor
  <-1, -1, -1>, <1, 1, 1>
  scale <10.0, 10.0, 0.1>
  texture {
    T_Wood1
    scale 5
    rotate <84.078362,0,-20>
    // Transform to parent space
  }
}




