//	Persistence of Vision Ray Tracer Scene Description File
#version unofficial MegaPov 0.4;

/*
  Prism
  photon mapping test scene
  
  Nathan Kopp
  Spring, 1999
*/


global_settings {
  adc_bailout 0.003922
  assumed_gamma 1.9

  max_intersections 64
  max_trace_level 5

  #if(1)
  photons {
	  spacing 0.02
    gather 20, 100	//100, 100
    expand_thresholds 0.2, 30
  }
  #end
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera StdCam
  location  <      0.058,      -4.105,       9.965>
  direction <        0.0,         0.0,      1.8317> // Aperture is 0.53 degrees
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33333,         0.0,         0.0> // Aspect ratio
  look_at   <     -1.169,      -0.467,      -0.150>
}

//
// *******  L I G H T S *******
//

#macro create_spectrum(nelems,bright)

#local elem=1;

color_map{

#while(elem<=nelems)

  /* h goes from 0 at red end to 1.0 at blue end */
  #local h = (elem-1)/(nelems-1);

  /* co-h goes from 1.0 at red end to 0.0 at blue end */
  #local coh = 1.0 - h; 
  
  #local Huered = 0.9 - (h/0.5);
  #local Hueblue = 1.0 - (coh/0.6);
  
  #if (Huered < 0.0) #local Huered = 0.0; #end
  #if (Hueblue < 0.0)  #local Hueblue = 0.0; #end

  #local Huered=1.0 - (1.0-Huered)*(1.0-Huered);  
  #local Hueblue=1.0 - (1.0-Hueblue)*(1.0-Hueblue);

  #local Huegreen = 1.0 - Huered - Hueblue;

  #if (h>0.85)
    #local Huered = 4*(h-0.85);  // was 4 - changed to 8
  #end
  
  #local ybulge =  -4.0*(h-0.1)*(h-0.6);
  #if (ybulge<0) #local ybulge=0; #end
  
  #local Huered = Huered+ybulge;// * 0.5; // added * 0.5
  #local Huegreen = Huegreen+ybulge;
  
  [bright, color rgb<Huered,Huegreen,Hueblue>]
  //#debug concat("<",str(Huered,0,3),",",str(Huegreen,0,3),",",str(Hueblue,0,3),">\n")
  
  
  #local elem=elem+1;
#end // while
}
#end // macro


light_source {   // Light1
  <0.000, 7.000, 1.841>
  color rgb <1.000, 1.000, 1.000>*6//*<.2,0,.8>
  /*
  color_map{
    [ 6 rgb<.4, 0, 0> ]
    //[ 6 rgb<.2,.1, 0> ]
    [ 6 rgb<.2,.2, 0> ]
    //[ 6 rgb< 0,.2, 0> ]
    //[ 6 rgb< 0,.5,.1> ]
    //[ 6 rgb< 0, 0,.2> ]
    [ 6 rgb<.2, 0,.7> ]
  }*/
  /*
  color_map {
    [ 3 rgb<1,1,0> ]
    [ 3 rgb<1,0,0> ]
    [ 3 rgb<0,1,0> ]
  }
  */       
  create_spectrum(8,3)
  //fade_power 2
  //fade_distance 4
}


//
// ********  TEXTURES  *******
//

#declare Glass = 
   material  {		// Glass
      texture {      
         pigment { color rgbf <1.0, 1.0, 1.0, 0.7> }      
         finish {
            ambient 0.0
            diffuse 0.0
            specular 1.0
            roughness 0.001
            reflection 0.1
         }
      }   
      interior {
         ior 1.5
         dispersion 1.2
         disp_nelems 10
         //disp_nelems 0
      }
   }


//  $MRY$: 'Material1'


#declare Material1 = 
   material  {		// Material1
      texture {      
         pigment { color rgb <1.0, 1.0, 1.0> }      
         finish {
            ambient 0.043133
            diffuse 0.899267
         }
      }
   }


//
// ********  OBJECTS  *******
//

box { // Cube003
  <-1, -1, -1>, <1, 1, 1>
  material { Material1 }
  scale <5.0, 0.1, 2.0>
  translate  <5.05, 2.0, 2.0>
}


plane { // Plane001
  z,0
  material { Material1 }
}


intersection { // Prism
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 1.5, 1.1>
    rotate -45.0*z
    translate  <-1.05, -1.05, 0.0>
  }
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
  }
  material { Glass }
  translate  .9*z
  photons {
	target 0.35
    refraction on
    reflection on
    ignore_photons
  }
  //rotate -45*z
  //translate 1*x
}

box { // Cube004
  <-1, -1, -1>, <1, 1, 1>
  material { Material1 }
  scale <5.0, 0.1, 2.0>
  translate  <-5.05, 2.0, 2.0>
}


