// Persistence Of Vision raytracer version 3.1e (isosurface patch)
// sample file by R.Suzuki   <rsuzuki@etl.go.jp>  Apr.'99
#version unofficial MegaPov 0.4;

#include "isocom.inc"

#declare R0=4;
#declare FUNC1=function {"sphere",<R0>}
#declare TH=function{"TH"}
#declare R=function{"R"}    
#declare R2=function{sqrt(x*x+z*z)}
#declare PH=function{"PH"}

isosurface {
	function {FUNC1(x,y+x*x*0.1,z)-max(noise3d(cos(TH)*sin(PH)*50,cos(PH)*50,sin(TH)*sin(PH)*50)^1.5,0.25)*1.5}
	eval                       
	max_gradient 16.7
	contained_by{ sphere {<0,0,0>,R0+1.5}}
	accuracy 0.01
	texture {ComYw}
}

