// Persistence Of Vision raytracer version 3.1e (isosurface patch)
// sample file by R.Suzuki   <rsuzuki@etl.go.jp>  Apr.'99
#version unofficial MegaPov 0.4;

camera {
	location <15, 25, -18>
	angle 25
	look_at <0, 0, 0>
}

light_source {<-50, 40, -20> color <1,1,1>}
light_source {<  0, 50, -50> color <1,1,1>}
background {color <0.65,0.72,0.72>}

#declare MESH1 = function    {"mesh1", <1, 1, 1, 0.17,  1>}

#declare RUSTY_MESH = 
    function{ MESH1(x,y-z*z*0.07+0.4,z) +
              noise3d(x*3,y*3,z*3)*0.2 +
              noise3d(x*16,y*16,z*16)*0.04-0.125}

isosurface {
     function{ RUSTY_MESH }
     contained_by{ box {<-3.7, -0.8, -3.7>, <3.7, 0.8, 3.7>}}
     eval
     threshold    0.18
     method 2
     pigment {colour <0.65,0.3,0.1>}
     finish {ambient 0.3}
     scale 1.25
}

