// Persistence Of Vision raytracer version 3.1 (isosurface patch)
// sample file by R.Suzuki   <rsuzuki@etl.go.jp>  Apr.'99
#version unofficial MegaPov 0.4;
     
camera { location <1.8, 0.055, 0.18>*1.7  direction <0, 0,  2.5> look_at <0,0.05,0.25>}

light_source {<  5, 20, -10> color 5.5}
background {color <0.2,0.25,0.42>}


fog { distance 7 color rgbf<0.5, 0.6, 0.7, 0.5> }
fog { distance 1  color rgbf<0.7, 0.7, 0.7, 0.5>
      fog_type 2  fog_offset -0.2  fog_alt 0.1 }


box {<-4, -1.5, -4>, <4, .03, 4>
     pigment {color <0.01,0.04,0.04>}
     normal { function  {noise3d(x*15,y*15,z*15)*0.003+noise3d(x*45,y*45,z*45)*0.006}
              slope_map { [0 <1, 1>]  [0.4 <0, 1>] } scale 0.3       }
     finish {reflection 0.7}
}


#declare RAND1=function{noise3d(x*40,y,z*40)}
#declare FUNC1=function{ y+abs(x+2)*0.15-0.2-noise3d(x*2,0,z)*0.5
               -noise3d(x*12,0,z*12)*0.03-RAND1*0.012-noise3d(x*125,y*5,z*125)*0.005
               -noise3d(x*300,y*100,z*300)*0.002-noise3d(x*1000,y*400,z*1000)*0.0005}

isosurface {
     function{ FUNC1 }
     contained_by{ box {<-4, -0.2, -4>, <4, 0.9, 4>}}  
     method 2
//     eval
     max_gradient 2.6     
     pigment { function { RAND1*(y+0.2)*0.12+y*0.3}
       color_map {[0.000, 0.006  color <.4,  .17, .02 >  color <.25,.2,  .125>]
                  [0.006, 0.008  color <.25, .2,  .125>  color <.2, .23, .125>]
                  [0.008, 0.025  color <.2,  .23, .125>  color <.2, .2,  .175>]
                  [0.025, 0.035  color <.2,  .2,  .175>  color <.45,.25, .2  >]
                  [0.035, 0.050  color <.45, .25, .2  >  color <.8, .8,  .7  >]
                  [0.050, 1.000  color <.8,  .8,  .7  >  color <.8, .8,  .07 >]}
       frequency 0.2
     }
     normal { 
        function  {noise3d(x*345,y*345,z*345)*0.15}
        slope_map { [0 <1, 1>]  [0.4 <0, 1>] } scale 0.1
     }              
     finish {phong 0.04}
}    
