// Persistence Of Vision raytracer version 3.1 (isosurface patch)
// sample file by R.Suzuki   <rsuzuki@etl.go.jp>  Apr.'99
#version unofficial MegaPov 0.6;

#include "isocom.inc"
camera { location <0, 20, -70>  direction <0, 0,  4.2> look_at <0,0,0>}


#declare R0=0.9;
#declare R1=0.4;

#declare T1=
isosurface {
	function {"torus",<R0,R1>}
	contained_by{ box {<-R0-R1,-R1,-R0-R1>,<R0+R1,R1,R0+R1>}} 
	texture {ComBl}
	no_shadow
}  

#declare Count=5;
#while (Count>0)  
  isosurface {
     function {"helix1",<1,2,R1,R0,Count*0.5,1,0>}
     contained_by{ box {<-R0-R1,-R0*2,-R0-R1>,<R0+R1,R0*2,R0+R1>}}
     eval 
     texture {ComYw}
     translate <-12+Count*4,R0*6,0>
     no_shadow
  }
  object{T1   translate <-12+Count*4,R0*8,0>}
  object{T1   translate <-12+Count*4,R0*4,0>}
  #declare Count=Count-1;
#end


#declare Count=5;
#while (Count>0)  
isosurface {
     function {"helix1",<1,3,R1,R0,1,(Count-1)*0.25,0>}
     contained_by{ box {<-R0-R1,-R0*2,-R0-R1>,<R0+R1,R0*2,R0+R1>}} 
	sign -1
     texture {ComYw}
     translate <-12+Count*4,0,0>
     no_shadow
  }
  object{T1   translate <-12+Count*4,R0*2,0>}
  object{T1   translate <-12+Count*4,-R0*2,0>}
  #declare Count=Count-1;
#end

#declare Count=5;
#while (Count>0)  
  isosurface {
     function {"helix1",<1,4,R1,R0,1,0.1,(Count-1)*0.25*90>}
     contained_by{ box {<-R0-R1*1.5,-R0*2,-R0-R1*1.5>,<R0+R1*1.5,R0*2,R0+R1*1.5>}} 
     texture {ComYw}
     translate <-12+Count*4,-R0*6,0>
     no_shadow
  }
  object{T1   translate <-12+Count*4,-R0*4,0>}
  object{T1   translate <-12+Count*4,-R0*8,0>}
  #declare Count=Count-1;
#end
