//	Persistence of Vision Ray Tracer Scene Description File
//	File: trim_bezier.pov
//	Date: 15/11/99
//	Demo showing the use trimmed bezier_patches.
	
#version unofficial MegaPov 0.4;

#declare MoveY = 1.1;

//********* Bezier_patch with 10-point star hole **************
bezier_patch {
	2,2
	<-1,-1, 0>, <1,-1, 0>,
	<-1, 1, 0>, <1, 1, 0>
	trimmed_by {
		type  1
		#declare c =10;
		#declare rel = 1/2;   
		#declare i = c;
		#while (i != 0)
			2 <cos (pi/c), sin (pi/c)>*rel, <1,0>
			rotate 360/c
			#declare i= i-1;
		#end      
		scale 0.4
		translate <0.5, 0.5>
	}
	texture {
		pigment { rgb <1, 0, 0> }
		finish { ambient 0.1 diffuse 0.8 phong 1 }
	}
	translate <-2.4, MoveY, 0>
}

//************* Bezier_patch with diamond shaped hole *************
bezier_patch {
	2,2
	<-1,-1>, <1,-1>,
	<-1, 1>, <1, 1>
	trimmed_by {
		type  1
		2 <1/4, 3/4>, <3/4, 3/4>
		2 <3/4, 1/4>, <1/4, 1/4>
		translate <-0.5, -0.5>
		rotate 45
		scale <1, 0.5>	
		translate <0.5, 0.5>
	}
	texture {
		pigment { rgb <1, 0, 0> }
		finish { ambient 0.1 diffuse 0.8 phong 1 }
	}
	translate <0, MoveY, 0>
}

//************* Bezier_patch with circular hole *************
bezier_patch {
	2,2
	<-1,-1,0>, <1,-1,0>,
	<-1,1, 0>, <1, 1,0>
	trimmed_by {
		type  1
		#declare i=4;
		#while (i!=0)
			3 <0,1>, <1,1>, <1,0>
			rotate 90
			#declare i= i -1;
		#end      
		scale 0.3
		translate <0.5,0.5>
	}
	texture {
		pigment { color <1,0,0> }
		finish { ambient 0.1 diffuse 0.8 phong 1 }
	}
	translate <-2.4, -MoveY, 0>
}

//*********** 6-point star with 6-point star hole *************
#declare vert=6;
#declare cykl=vert;
#declare star =
	trimmed_by {
		type 0
		#while (cykl > 0)
			3  
			#if (cykl=vert) <cos (2 * pi/vert), sin (2 * pi/vert)> #else previous #end
			<0,0>
			#if (cykl=1)  first #else <1, 0> #end 
				rotate 360/vert
			#declare cykl=cykl-1;
		#end		    
	}
	
bezier_patch {
	2,2
	<-1, -1, 0>, <1, -1, 0>,
	<-1, 1, 0>, <1, 1, 0>
	trimmed_by {
		star
		type  0
		scale 0.4
		translate <+0.5, +0.5>
	}
	trimmed_by {
		star
		scale 0.15
		rotate 180 / vert
		translate <0.5, 0.5>
		type 1
	}
	texture {
		pigment { rgb <1, 0, 0> }
		finish { ambient 0.1 diffuse 0.8 phong 1 }
	}
	translate <2.4, MoveY, 0>
}

//*********** Bezier_patch with 4-point star hole *************
bezier_patch {
	2, 2
	<-1,-1>, <1,-1>,
	<-1, 1>, <1, 1>
	trimmed_by {
		type  1
		#declare i=4;
		#while (i!=0)
			2 <0, 1>, <1/4, 1/4>
			rotate 90
			#declare i= i -1;
		#end      
		scale 0.3
		translate <0.5, 0.5>
	}
	texture {
		pigment { rgb <1, 0, 0> }
		finish { ambient 0.1 diffuse 0.8 phong 1 }
	}
	translate <0, -MoveY, 0>
}

//******************* 20-point star *********************
bezier_patch {
	2, 2
	<-1, -1>, <1, -1>,
	<-1, 1>, <1, 1>
	trimmed_by {
		type  0
		#declare c=20;
		#declare rel= 1/2  ;    
		#declare i=c;
		#while (i!=0)
			2  <cos (pi/c), sin (pi/c)>*rel, <1, 0>
			rotate 360/c
			#declare i= i -1;
		#end      
		scale 0.4
		translate <0.5, 0.5>
	}
	texture {
		pigment { rgb <1, 0, 0> }
		finish { ambient 0.1 diffuse 0.8 phong 1 }
	}
	translate <2.4, -MoveY, 0>
}

light_source {
	<50, 50, -50>
	rgb <1, 1, 1>
}

background { rgb <0.1, 0.1,1.0> }

camera {
	location <0, 0, -10>
	right x*image_width up y*image_height
	look_at <0, 0, 0>
	angle 40
}

