//	Persistence of Vision Ray Tracer Scene Description File
//	File: double_illuminate.pov
//	Date: 11-05-2000
//	Demo double_illuminate

//Set double_illuminate:
//	0 = off;
//	1 = double_illuminate on left sphere;
//	2 = double_illuninate on bottom;
//	3 = double_illuminate on left sphere AND bottom right half
	
#declare DoubleIllum = 3;


#version unofficial MegaPov 0.5;

camera {
	location < 0.0, 0.0, -9 >
	up image_height*y
	right image_width*x
	angle 35
	look_at < 0.0, 0.0, 0.0 >
	rotate x*10
}

light_source { <4000, 9000, -10000> rgb 1.0 } //genaral light

sphere {		//right rainbow sphere
	<1.2, 0.0, 0.0>, 1.0
	texture {
		pigment {
			gradient y
			color_map {
				[ 0.000 rgbft <1.0, 0.5, 1.0, 0.0, 0.0> ]	//violet 1
				[ 0.100 rgbft <1.0, 0.5, 1.0, 0.0, 0.0> ]	//violet 2
				[ 0.214 rgbft <0.5, 0.5, 1.0, 0.0, 0.0> ]	//indigo
				[ 0.328 rgbft <0.2, 0.2, 1.0, 0.0, 0.0> ]	//blue
				[ 0.442 rgbft <0.2, 1.0, 1.0, 0.0, 0.0> ]	//cyan
				[ 0.556 rgbft <0.2, 1.0, 0.2, 0.0, 0.0> ]	//green
				[ 0.670 rgbft <1.0, 1.0, 0.2, 0.0, 0.0> ]	//yellow
				[ 0.784 rgbft <1.0, 0.5, 0.2, 0.0, 0.0> ]	//orange
				[ 0.900 rgbft <1.0, 0.2, 0.2, 0.0, 0.0> ]	//red1
				[ 1.000 rgbft <1.0, 0.2, 0.2, 0.0, 0.0> ]	//red2
			}
		}
		finish {
			reflection rgb 0.3
			phong 1.0 phong_size 350
		}
	}
}

light_source { <-1.2, 0.0, 0.0> rgb 1.2 }  //light trapped in sphere
sphere {		//left rainbow sphere
	<-1.2, 0.0, 0.0>, 1.0
	texture {
		pigment {
			gradient y
			color_map {
				[ 0.000 rgbft <1.0, 0.5, 1.0, 0.0, 0.0> ]	//violet 1
				[ 0.100 rgbft <1.0, 0.5, 1.0, 0.0, 0.0> ]	//violet 2
				[ 0.214 rgbft <0.5, 0.5, 1.0, 0.0, 0.0> ]	//indigo
				[ 0.328 rgbft <0.2, 0.2, 1.0, 0.0, 0.0> ]	//blue
				[ 0.442 rgbft <0.2, 1.0, 1.0, 0.0, 0.0> ]	//cyan
				[ 0.556 rgbft <0.2, 1.0, 0.2, 0.0, 0.0> ]	//green
				[ 0.670 rgbft <1.0, 1.0, 0.2, 0.0, 0.0> ]	//yellow
				[ 0.784 rgbft <1.0, 0.5, 0.2, 0.0, 0.0> ]	//orange
				[ 0.900 rgbft <1.0, 0.2, 0.2, 0.0, 0.0> ]	//red1
				[ 1.000 rgbft <1.0, 0.2, 0.2, 0.0, 0.0> ]	//red2
			}
		}
		finish {
			reflection rgb 0.3
			phong 1.0 phong_size 350
		}
	}
	#if (DoubleIllum = 1 | DoubleIllum = 3)	//switches double_illuminate on/off
		double_illuminate  //iluminates inside and outside of sphere
	#end
}

light_source { <5.0,-10, 0.0> rgb 0.8 }  //light trapped in bottom cylinder
cylinder {		//bottom right half
	<0.0, -31, 0.0>, <10, -31, 0.0>, 30
	texture {
		pigment {
			granite
			color_map {
				[ 0.000 rgbft <0.0, 0.0, 0.0, 0.0, 0.0> ]	//black
				[ 1.000 rgbft <1.0, 1.0, 1.0, 0.0, 0.0> ]	//white
			}
			scallop_wave
			scale <0.03, 0.03, 0.03>
		}
	}
	#if (DoubleIllum = 2 | DoubleIllum = 3)	//switches double_illuminate on/off
		double_illuminate  //illuminates inside and outside surface of cylinder
	#end
}
cylinder {		//bottom left half
	<0.0, -31, 0.0>, <-10, -31, 0.0>, 30
	texture {
		pigment {
			granite
			color_map {
				[ 0.000 rgbft <0.0, 0.0, 0.0, 0.0, 0.0> ]	//black
				[ 1.000 rgbft <1.0, 1.0, 1.0, 0.0, 0.0> ]	//white
			}
			scallop_wave
			scale <0.03, 0.03, 0.03>
		}
	}
}

sky_sphere {
	pigment {
		gradient y
		color_map { [0.0 color rgb <0.7,0.7,1.0>] [1.0 color blue 0.5] }
		translate y*0.5
	}
}

