//	Persistence of Vision Ray Tracer Scene Description File
//	File: parallel_group.pov
//	Date: 15/11/99
//	Demo showing the use of light_groups and parallel light.
	
#version unofficial MegaPov 0.4;


camera {
	perspective 
	location < 0.0, 0, -22>
	angle 40
	look_at < 0.0, 0.0, -3 >
	rotate x*35
}

#declare Tile =
	box {
		<-3, -0.1, -3>, <3, 0.0, 3>
		texture {
			pigment { rgb 1 }
			finish { ambient 0.12 }
		}
		translate y*-0.4
	}
	
#declare Sphere =
	 sphere {
		<0.0, 1.0, 0.0>, 1.0
		texture {
			pigment { rgb 1 }
			finish {
				ambient rgb <0.1, 0.1, 0.1> 
				phong 1.0 phong_size 300
			}
		}
	}

//********* BACK ROW = NORMAL LIGHTS **************
//********* Left back = green spot *****************
light_source {
	<-3.0, 3, 3>
	rgb <0.0, 1.0, 0.0>
	spotlight
 	point_at <-3.0, 0.0, 3>
	radius 40 	falloff 90 tightness 6
	groups "SpotPar"
}
object {
	Sphere
	translate <-3.0, 0.0, 3.0>
	light_group "SpotPar"
}
object {
	Tile
	translate <-3, 0, 3>
	light_group "SpotPar"
}

//********* Right back = red point light *****************
light_source {
	<3.0, 4, 3>
	rgb <1.0, 0.0, 0.0> 
	groups "Point"
}
object {
	Sphere
	translate <3.0, 0.0, 3.0>
	light_group "Point"
}
object {
	Tile
	translate <3, 0, 3>
	light_group "Point"
}

//*********** FRONT ROW = PARALLEL LIGHTS *************
//********* Left front = blue spot parallel **************
light_source {
	<-3.0, 3, -3>
	rgb <0.0, 0.0, 1.0>*1.3
	parallel
	spotlight
 	point_at <-3.0, 0.0, -3>
	radius 60 	falloff 100 tightness 4
	groups "Spot"
}
object {
	Sphere
	translate <-3.0, 0.0, -3.0>
	light_group "Spot"
}
object {
	Tile
	translate <-3, 0, -3>
	light_group "Spot"
}

//********* Right front = yellow point light parallel **********
light_source {
	<3.0, 4, -3>
	color rgb <1.0, 1.0, 0.0>*0.8 
	parallel
	point_at <3.0, 0, -3>
	groups "PointPar"
}
object {
	Sphere
	translate <3.0, 0.0, -3.0>
	light_group "PointPar"
}
object {
	Tile
	translate <3, 0, -3>
	light_group "PointPar"
}

//******* Central sphere = white point light ***************
light_source {
	< 0.5, 5, -3 >
	rgb <1.0, 1.0, 1.0>*1.3
	groups "Center"
}
object {
	Sphere
	translate y*-1
	scale <1.4, 0.3, 1.4>
	translate y*-0.4
	light_group "Center"
}

