//	Persistence of Vision Ray Tracer Scene Description File
//	File: dispwarp.pov
//	Date: 
//	Author: Chris Huff
//	Description: Demonstrates the displace warp.
//*******************************************

#version unofficial MegaPov 0.6;

global_settings {
	assumed_gamma 1.8
}

camera {
	location <0, 0,-8>
	up y*image_height right x*image_width
	angle 25
	look_at <0, 0, 0>
}


#declare rsA = seed(7582);
#declare rsB = seed(4385);
#declare rsC = seed(6543);
#declare rsD = seed(8538);
#declare rsE = seed(5235);

#macro pmRand(RS)
	(rand(RS)*2-1)
#end
#macro gRand(RS)
	((rand(RS)+rand(RS)+rand(RS))/3)
#end
#macro gpmRand(RS)
	(gRand(RS)*2-1)
#end

#declare controlPgmt =
pigment {
	//******* choose one of the patterns below ********
	spherical
//	bozo
//	wrinkles
	//*******************************************
	poly_wave 2
	color_map {
		[0 color rgb 0]
		[1 color rgb 1]
	}
}

box {
	<-100,-100, 0>, < 100, 100, 0>
	texture {
	//******* choose one of the piments below ********
		pigment {gradient y frequency 10
//		pigment {onion frequency 5
//		pigment {crackle frequency 10
//		pigment {granite frequency 7
	//*******************************************
			color_map {[0 rgb 0][1 rgb 1]}
			warp { displace {controlPgmt} }
		}
		finish {ambient 1}
	}
}
