// filename="use_df3.pov"

//	Persistence of Vision Ray Tracer Scene Description File

//	Needs MegaPov 0.6

//	Date: august 10  2000

//	Author: Ren Smellenbergh

//	This demo uses the make_df3.df3 file created with make_df3.pov



#version unofficial MegaPov 0.6;



#if (clock_on = 1)

	#error "Oops, you forgot to turn off the clock"

#end



global_settings {

    assumed_gamma 1.8  //adjust if necessary

    max_trace_level 10

	// to ensure the intended image ratio of 1/1 is used

	ini_option concat ("Height=", str (image_width, 0, 0))

}



camera {

	location <0.0, 0.0, -10>

	up y*image_height right x*image_width

	look_at <0.0, 0.0, 0.0>

	angle 40

	rotate x*10

}



light_source { z*-10000  rgb 1.0*1.2  rotate <30,-30,0> }



box {

	0, 1

	hollow

	pigment {rgbt 1.0}

	interior {

		media {

			emission rgb 0.25

			scattering {

				4,	//rayleigh_scattering

				rgb 1.2

			}

			density {

				density_file df3 "make_df3.df3"

				interpolate 1	//tri-linear 

				color_map {

					[ 0.0 rgb <0, 0, 0.0> ]

					[ 0.25 rgb <1.000000, 1.000000, 1.000000> ]

					[ 0.25 rgb <0.929412, 0.094118, 0.117647> ]

					[ 0.75 rgb <1.000000, 0.913725, 0.341176>*2 ]

					[ 1.0 rgb <1.0, 1.0, 0.0>*2.5 ]

				}

			}

			method 3

			jitter 1.0

			aa_level 3.0

			aa_threshold 0.4

			intervals 5

			samples 4,  4

		}

	}

	translate -0.5

	scale 5

}



background { rgb <0.0, 0.0, 0.25> }



