#version unofficial MegaPov 0.6;

camera {location <4.5, 4.5, 4.5> look_at <0.3, 1, -1> angle 55}

light_source { <-15, 30, -25> color red 1 green 1 blue 1 }
light_source { < 15, 30, -25> color red 1 green 1 blue 1 }
light_source { < -1, 1, 10> color red 1 green 1 blue 1 }
light_source { < 0, 1, 0> color red 1 green 1 blue 1 }

// some stuff you don't really need to worry about
// as long as pipe looks nearly like a pipe and
// no surface acne appears ...

#declare problems = 0;         // for testing purposes ...
#declare eps = 0.048;           // change this parameter carefully, when pipe
                              // looks really strange.
#declare Patch_Type = 2 ;     
#declare Patch_Accuracy = 0.000001;
#declare Patch_Flatness = 0;   // set to 0 to get rid of (some) surface acne, higher values
                              // save memory. should be in [0,1]
#declare Patch_U_Steps = 2 ;   // raising one of this parameters DOUBLES
#declare Patch_V_Steps = 3 ;   // the needed memory so try to keep 'em low !!!
                              // higher values cause smoother segments.
                              // when you have a big nr_of_segment it makes
                              // more sense to raise V_Steps!


// the more interessting stuff ...

#declare sp_name="my_spline"    // name of the 3d_spline that gives the form
#declare th_name="th_spline"    // name of spline that determines the thickness
                                // of the pipe. parameters should run from 0 to 1.
#init_3d_spline {sp_name,<-1,0,0>,<-0.8,0.5,1>,<1.5,1,1.5>,
                             <3,1.2,-1>,<0.3,1.9,-1.1>,<-0.3,2.8,-0.1>,
                             <1.7,3,2>,<1.4,3.2,-0.8>}
#init_spline {th_name,<0,0.2>,<0.3,0.1>,<0.6,0.4>,<1,0.25>}
#declare nr_of_segments = 200;   // raise this if the pipe has 'corners'

object {
  #include "pipe.inc"           // this is the pipe
  texture {
     pigment {
        granite
        color_map {
           [ 0.0     rgb <0.2, 0.7, 0.8> ]
           [ 0.5     rgb <0.2, 0.7, 0.8> ]
           [ 0.5     rgb <0.9, 0.56, 0.1> ]
           [ 1.0     rgb <0.9, 0.56, 0.1> ]
        }
		triangle_wave
     }
     finish {
        ambient 0.3
        diffuse 1.0
        phong 1.0
        phong_size 70.0
     }
  }
}

/* The following lines are for testing purposes only !
#if (problems = 1)
  #warning "choose smaller eps or bigger nr_of segments !!!"
#else
  #warning "eps can be choosen bigger !!!"
#end
*/
