//	Persistence of Vision Ray Tracer Scene Description File
#version unofficial MegaPov 0.4;

//
// This is a simple demo file for testing the UV mapping version of POV.
// This was created by Nathan Kopp using Moray (and then hand-edited)
//
// The bicubic patches are identical, except that the top one uses regular
// texturing, and the bottom one adds the "uv_mapping" keyword.
//

background { color <0.000,0.000,0.000> }

camera {  //  Camera StdCam
  location  <-2.772, -7.230, 2.807>
  direction <0.0,     0.0,  1.5968>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  look_at   <0.000, 0.000, 0.000>
}


light_source {   // Light1
  <-9.779, -9.282, 2.800>
  color rgb <1.000, 1.000, 1.000>
}

light_source {   // Light2
  <6.096, -9.282, 13.469>
  color rgb <0.714, 0.714, 0.714>
}

#declare Texture1 =
   texture  // Texture1
   {
      pigment
      {
         checker
      }
   }

object { // BezPtch001
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.607867, -1.495616, 0.000000>, <-1.000000, -2.000000, 0.000000>, <0.000000, -2.000000, 0.000000>, <1.000000, -2.106677, -0.826745>,
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.080008, -2.426898>, <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.533384>,
      <-2.000000, 0.000000, 0.000000>, <-1.000000, 0.053338, 1.306791>, <0.000000, 0.000000, 0.000000>, <1.000000, -0.000000, 0.533384>,
      <-1.523554, 0.549970, 0.000000>, <-1.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.280861, 0.772993, 1.066768>
    }
  }
  uv_mapping
  texture {
    Texture1 scale 0.2
  }
  translate  <-1.025676, -0.694813, 0.0>
}

object { // BezPtch2
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.607867, -1.495616, 0.000000>, <-1.000000, -2.000000, 0.000000>, <0.000000, -2.000000, 0.000000>, <1.000000, -2.106677, -0.826745>,
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.080008, -2.426898>, <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.533384>,
      <-2.000000, 0.000000, 0.000000>, <-1.000000, 0.053338, 1.306791>, <0.000000, 0.000000, 0.000000>, <1.000000, -0.000000, 0.533384>,
      <-1.523554, 0.549970, 0.000000>, <-1.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.280861, 0.772993, 1.066768>
    }
  }
  texture {
    Texture1 scale 0.2
  }
  translate  <0.62864, -1.238575, 1.312198>
}




