//	Persistence of Vision Ray Tracer Scene Description File
#version unofficial MegaPov 0.4;

/*

UV Mapping Demo Scene
Created Feb 20, 1999

This contains 4 shapes that currently support uv mapping.  (This
does not have a mesh object).

All of these objects use the same hexagon texture.  Change the
line below to read "#declare USE_UV_MAPPING=yes;" to see what
the difference is without uv mapping.

This was originally created in moray.

*/

#declare USE_UV_MAPPING=yes;

camera {  //  Camera StdCam
  location  <     -4.042,      -8.503,       9.486>
  direction <        0.0,         0.0,      1.8317> // Aperture is 0.53 degrees
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33333,         0.0,         0.0> // Aspect ratio
  look_at   <      0.000,       0.000,       0.000>
}

light_source {  <0.000, -20.000, 20.000> color rgb <1.000, 1.000, 1.000>}

#include "demouv.inc"

/* background sphere */
sphere { // Sphere002
  <0,0,0>,1
  material {
    Material2
  }
  scale 36.904232
}

bicubic_patch {
type 1
flatness 0.01
u_steps 3
v_steps 3
uv_vectors <0, 0>, <1, 1>
<-3, 3, -1>, <-1, 3, -1>, <1, 3, -1>, <3, 3, -1>,
<-3, 1, -1>, <-1, 1, -1>, <1, 1, -1>, <3, 1, -1>,
<-3, -1, -1>, <-1, -1, -1>, <1, -1, -1>, <3, -1, -1>,
<-3, -3, -1>, <-1, -3, -1>, <1, -3, -1>, <3, -3, -1>
scale .2
uv_mapping
texture {
 pigment {
  image_map {
     gif "uvtest.gif"
   }
   rotate 90*z
 }
}
scale 5
}

