//	Persistence of Vision Ray Tracer Scene Description File
#version unofficial MegaPov 0.4;

// ---------------------------------------------------
// Normal Demo Scene
// by Nathan Kopp
//
//  Adjust the variables and see how things react
//
// ---------------------------------------------------

// also try #version 3.1;

// --------- choose a shape -----------
$Shape=sphere{0,1}
//$Shape=box{-.8,.8 }

// --------- choose a scale direction -----------
$Scale = 1;  // try 1,x,y,z

// --------- choose a normal -----------
$Normal=normal { granite .3 } 
//$Normal=normal { average normal_map{[1 bumps .1 scale .2 ]} }

// Encapsulate the bumps into an average to 'shield' the 'scale .2' from 
//  the 'no_bump_scale' keyword.

background{color rgb<1,1,1>}

camera{
  location <30,30,100>
  look_at <0,0,0>
  angle 10
}

light_source{ 
  <50,80,100> 
  color rgb<1,1,1>
}


$I=0;
#while (I<4)
  object{
    Shape
    pigment { rgb 1 }
    finish { specular .2 }
    normal { Normal }
    scale (I*.5*Scale)+1
    translate (8-I*5)*x
    translate 4*y
  }
  $I=I+1;
#end
  
$I=0;
#while (I<4)
  object{
    Shape
    pigment { rgb 1 }
    finish { specular .2 }
    normal { Normal no_bump_scale}
    scale (I*.5*Scale)+1
    translate (8-I*5)*x
    translate -4*y
  }
  $I=I+1;
#end
  

cylinder{
  0,2*x,.2
  pigment{rgb x}
  finish { specular .2 }
}
cylinder{
  0,2*y,.2
  pigment{rgb y}
  finish { specular .2 }
}
cylinder{
  0,2*z,.2
  pigment{rgb z}
  finish { specular .2 }
}
