/****************************************************
Scene:  cutaway2.pov
Author: Nathan Kopp

This scene requires MegaPov 0.5 or above.
MegaPov is an unofficial version of POV-Ray.

This scene demonstrates the new CSG cutaway_textures
feature.


This scene is lit primarily by radiosity fueled by
a bright sky_sphere.  The light source's intensity
is 0.3

*****************************************************/

#version unofficial MegaPov 0.5;

// note: the default texture is RED
$apply_texture=no; // apply a BLUE texture to the cutting plane
$use_cutaway=yes;   // enable cutaway textures

#include "colors.inc"
#include "metals.inc"
#include "stones.inc"
#include "woods.inc"
#include "skies.inc"

global_settings{ambient_light 0 radiosity{} }

camera
{
  location  <0.0, 0.4, -3.0>
  look_at   <0.0, 0.0,  0.0>
}

sky_sphere
{
  S_Cloud2
}

light_source
{
  <-30, 30, -30> color rgb .3
}

#default{
  texture{
    pigment{rgb <1,0,0>}
    finish{diffuse 1 ambient 0 phong 0 specular 0}    
  }
}


plane { y, -1 pigment {color rgb <0.7,0.5,0.3>} finish{ambient .1 diffuse .7}}

intersection{
  union
  {
    sphere { 0, 1
      texture { 
        #version official 3.1;
        T_Stone5 scale .3
        #version unofficial MegaPov 0.5;
      }
      translate -.5*x
    }
    
    sphere { 0, 1
      texture {
        #version official 3.1;
        T_Stone15 scale .2
        #version unofficial MegaPov 0.5;
        }
        #version unofficial MegaPov 0.5;
      translate .5*x 
    }
    
    difference{
      sphere{ 0,1
        translate -.75*z
      }
      sphere{ 0,.75
        translate -.75*z
      }
      texture{
        #version official 3.1;
        T_Wood9 scale .3 rotate 20*x
        #version unofficial MegaPov 0.5;
      }
    }
  }
  
  // this plane has no texture  
  plane{ 
    y 0 
    #if (apply_texture)
    texture{ pigment{rgb <0,0,1>} }
    #end
  }

  rotate -30*y  
  rotate -25*x
  translate .25*y
  
  #if (use_cutaway)
  cutaway_textures
  #end
}



