//	Persistence of Vision Ray Tracer Scene Description File
//	File: sol_tri.pov
//	Date: 11-05-2000
//	Author: R. Smellenbergh
//	Demo showing a solid triangle mesh

#version unofficial MegaPov 0.5;

camera {
	perspective 
	location <0.0, 0.0, -3>
	angle 40
	look_at <0.0, 0.0, 0.0>
}

light_source { <2000, 500, -3000> rgb 1.1 }

//A plate made with a mesh triangle
#declare  SolidMesh = 
	mesh {
		inside_vector y		//make mesh solid
		triangle { <   0.539825,   0.000000,  -0.392206>, <   0.667260,   0.000000,   0.000000>, <   0.000000,   0.000000,   0.000000> }
		triangle { <   0.667260,   0.000000,   0.000000>, <   0.539825,   0.000000,  -0.392206>, <   0.555657,   0.023090,  -0.403709> }
		triangle { <   0.555657,   0.023090,  -0.403709>, <   0.686830,   0.023090,   0.000000>, <   0.667260,   0.000000,   0.000000> }
		triangle { <   0.686830,   0.023090,   0.000000>, <   0.555657,   0.023090,  -0.403709>, <   0.575810,   0.037300,  -0.418350> }
		triangle { <   0.575810,   0.037300,  -0.418350>, <   0.711740,   0.037300,   0.000000>, <   0.686830,   0.023090,   0.000000> }
		triangle { <   0.711740,   0.037300,   0.000000>, <   0.575810,   0.037300,  -0.418350>, <   0.646348,   0.065720,  -0.469599> }
		triangle { <   0.646348,   0.065720,  -0.469599>, <   0.798930,   0.065720,   0.000000>, <   0.711740,   0.037300,   0.000000> }
		triangle { <   0.798930,   0.065720,   0.000000>, <   0.646348,   0.065720,  -0.469599>, <   0.762952,   0.065720,  -0.554317> }
		triangle { <   0.762952,   0.065720,  -0.554317>, <   0.943060,   0.065720,   0.000000>, <   0.798930,   0.065720,   0.000000> }
		triangle { <   0.943060,   0.065720,   0.000000>, <   0.762952,   0.065720,  -0.554317>, <   0.777344,   0.101240,  -0.564773> }
		triangle { <   0.777344,   0.101240,  -0.564773>, <   0.960850,   0.101240,   0.000000>, <   0.943060,   0.065720,   0.000000> }
		triangle { <   0.960850,   0.101240,   0.000000>, <   0.777344,   0.101240,  -0.564773>, <   0.646348,   0.101240,  -0.469599> }
		triangle { <   0.646348,   0.101240,  -0.469599>, <   0.798930,   0.101240,   0.000000>, <   0.960850,   0.101240,   0.000000> }
		triangle { <   0.798930,   0.101240,   0.000000>, <   0.646348,   0.101240,  -0.469599>, <   0.567178,   0.067500,  -0.412079> }
		triangle { <   0.567178,   0.067500,  -0.412079>, <   0.701070,   0.067500,   0.000000>, <   0.798930,   0.101240,   0.000000> }
		triangle { <   0.701070,   0.067500,   0.000000>, <   0.567178,   0.067500,  -0.412079>, <   0.536945,   0.044400,  -0.390113> }
		triangle { <   0.536945,   0.044400,  -0.390113>, <   0.663700,   0.044400,   0.000000>, <   0.701070,   0.067500,   0.000000> }
		triangle { <   0.663700,   0.044400,   0.000000>, <   0.536945,   0.044400,  -0.390113>, <   0.000000,   0.044400,   0.000000> }
		triangle { <   0.206195,   0.000000,  -0.634602>, <   0.539825,   0.000000,  -0.392206>, <   0.000000,   0.000000,   0.000000> }
		triangle { <   0.539825,   0.000000,  -0.392206>, <   0.206195,   0.000000,  -0.634602>, <   0.212242,   0.023090,  -0.653214> }
		triangle { <   0.212242,   0.023090,  -0.653214>, <   0.555657,   0.023090,  -0.403709>, <   0.539825,   0.000000,  -0.392206> }
		triangle { <   0.555657,   0.023090,  -0.403709>, <   0.212242,   0.023090,  -0.653214>, <   0.219940,   0.037300,  -0.676905> }
		triangle { <   0.219940,   0.037300,  -0.676905>, <   0.575810,   0.037300,  -0.418350>, <   0.555657,   0.023090,  -0.403709> }
		triangle { <   0.575810,   0.037300,  -0.418350>, <   0.219940,   0.037300,  -0.676905>, <   0.246883,   0.065720,  -0.759828> }
		triangle { <   0.246883,   0.065720,  -0.759828>, <   0.646348,   0.065720,  -0.469599>, <   0.575810,   0.037300,  -0.418350> }
		triangle { <   0.646348,   0.065720,  -0.469599>, <   0.246883,   0.065720,  -0.759828>, <   0.291422,   0.065720,  -0.896903> }
		triangle { <   0.291422,   0.065720,  -0.896903>, <   0.762952,   0.065720,  -0.554317>, <   0.646348,   0.065720,  -0.469599> }
		triangle { <   0.762952,   0.065720,  -0.554317>, <   0.291422,   0.065720,  -0.896903>, <   0.296919,   0.101240,  -0.913823> }
		triangle { <   0.296919,   0.101240,  -0.913823>, <   0.777344,   0.101240,  -0.564773>, <   0.762952,   0.065720,  -0.554317> }
		triangle { <   0.777344,   0.101240,  -0.564773>, <   0.296919,   0.101240,  -0.913823>, <   0.246883,   0.101240,  -0.759828> }
		triangle { <   0.246883,   0.101240,  -0.759828>, <   0.646348,   0.101240,  -0.469599>, <   0.777344,   0.101240,  -0.564773> }
		triangle { <   0.646348,   0.101240,  -0.469599>, <   0.246883,   0.101240,  -0.759828>, <   0.216643,   0.067500,  -0.666757> }
		triangle { <   0.216643,   0.067500,  -0.666757>, <   0.567178,   0.067500,  -0.412079>, <   0.646348,   0.101240,  -0.469599> }
		triangle { <   0.567178,   0.067500,  -0.412079>, <   0.216643,   0.067500,  -0.666757>, <   0.205095,   0.044400,  -0.631216> }
		triangle { <   0.205095,   0.044400,  -0.631216>, <   0.536945,   0.044400,  -0.390113>, <   0.567178,   0.067500,  -0.412079> }
		triangle { <   0.536945,   0.044400,  -0.390113>, <   0.205095,   0.044400,  -0.631216>, <   0.000000,   0.044400,   0.000000> }
		triangle { <  -0.206195,   0.000000,  -0.634602>, <   0.206195,   0.000000,  -0.634602>, <   0.000000,   0.000000,   0.000000> }
		triangle { <   0.206195,   0.000000,  -0.634602>, <  -0.206195,   0.000000,  -0.634602>, <  -0.212242,   0.023090,  -0.653214> }
		triangle { <  -0.212242,   0.023090,  -0.653214>, <   0.212242,   0.023090,  -0.653214>, <   0.206195,   0.000000,  -0.634602> }
		triangle { <   0.212242,   0.023090,  -0.653214>, <  -0.212242,   0.023090,  -0.653214>, <  -0.219940,   0.037300,  -0.676905> }
		triangle { <  -0.219940,   0.037300,  -0.676905>, <   0.219940,   0.037300,  -0.676905>, <   0.212242,   0.023090,  -0.653214> }
		triangle { <   0.219940,   0.037300,  -0.676905>, <  -0.219940,   0.037300,  -0.676905>, <  -0.246883,   0.065720,  -0.759828> }
		triangle { <  -0.246883,   0.065720,  -0.759828>, <   0.246883,   0.065720,  -0.759828>, <   0.219940,   0.037300,  -0.676905> }
		triangle { <   0.246883,   0.065720,  -0.759828>, <  -0.246883,   0.065720,  -0.759828>, <  -0.291422,   0.065720,  -0.896903> }
		triangle { <  -0.291422,   0.065720,  -0.896903>, <   0.291422,   0.065720,  -0.896903>, <   0.246883,   0.065720,  -0.759828> }
		triangle { <   0.291422,   0.065720,  -0.896903>, <  -0.291422,   0.065720,  -0.896903>, <  -0.296919,   0.101240,  -0.913823> }
		triangle { <  -0.296919,   0.101240,  -0.913823>, <   0.296919,   0.101240,  -0.913823>, <   0.291422,   0.065720,  -0.896903> }
		triangle { <   0.296919,   0.101240,  -0.913823>, <  -0.296919,   0.101240,  -0.913823>, <  -0.246883,   0.101240,  -0.759828> }
		triangle { <  -0.246883,   0.101240,  -0.759828>, <   0.246883,   0.101240,  -0.759828>, <   0.296919,   0.101240,  -0.913823> }
		triangle { <   0.246883,   0.101240,  -0.759828>, <  -0.246883,   0.101240,  -0.759828>, <  -0.216643,   0.067500,  -0.666757> }
		triangle { <  -0.216643,   0.067500,  -0.666757>, <   0.216643,   0.067500,  -0.666757>, <   0.246883,   0.101240,  -0.759828> }
		triangle { <   0.216643,   0.067500,  -0.666757>, <  -0.216643,   0.067500,  -0.666757>, <  -0.205095,   0.044400,  -0.631216> }
		triangle { <  -0.205095,   0.044400,  -0.631216>, <   0.205095,   0.044400,  -0.631216>, <   0.216643,   0.067500,  -0.666757> }
		triangle { <   0.205095,   0.044400,  -0.631216>, <  -0.205095,   0.044400,  -0.631216>, <   0.000000,   0.044400,   0.000000> }
		triangle { <  -0.539825,   0.000000,  -0.392206>, <  -0.206195,   0.000000,  -0.634602>, <   0.000000,   0.000000,   0.000000> }
		triangle { <  -0.206195,   0.000000,  -0.634602>, <  -0.539825,   0.000000,  -0.392206>, <  -0.555657,   0.023090,  -0.403709> }
		triangle { <  -0.555657,   0.023090,  -0.403709>, <  -0.212242,   0.023090,  -0.653214>, <  -0.206195,   0.000000,  -0.634602> }
		triangle { <  -0.212242,   0.023090,  -0.653214>, <  -0.555657,   0.023090,  -0.403709>, <  -0.575810,   0.037300,  -0.418350> }
		triangle { <  -0.575810,   0.037300,  -0.418350>, <  -0.219940,   0.037300,  -0.676905>, <  -0.212242,   0.023090,  -0.653214> }
		triangle { <  -0.219940,   0.037300,  -0.676905>, <  -0.575810,   0.037300,  -0.418350>, <  -0.646348,   0.065720,  -0.469599> }
		triangle { <  -0.646348,   0.065720,  -0.469599>, <  -0.246883,   0.065720,  -0.759828>, <  -0.219940,   0.037300,  -0.676905> }
		triangle { <  -0.246883,   0.065720,  -0.759828>, <  -0.646348,   0.065720,  -0.469599>, <  -0.762952,   0.065720,  -0.554317> }
		triangle { <  -0.762952,   0.065720,  -0.554317>, <  -0.291422,   0.065720,  -0.896903>, <  -0.246883,   0.065720,  -0.759828> }
		triangle { <  -0.291422,   0.065720,  -0.896903>, <  -0.762952,   0.065720,  -0.554317>, <  -0.777344,   0.101240,  -0.564773> }
		triangle { <  -0.777344,   0.101240,  -0.564773>, <  -0.296919,   0.101240,  -0.913823>, <  -0.291422,   0.065720,  -0.896903> }
		triangle { <  -0.296919,   0.101240,  -0.913823>, <  -0.777344,   0.101240,  -0.564773>, <  -0.646348,   0.101240,  -0.469599> }
		triangle { <  -0.646348,   0.101240,  -0.469599>, <  -0.246883,   0.101240,  -0.759828>, <  -0.296919,   0.101240,  -0.913823> }
		triangle { <  -0.246883,   0.101240,  -0.759828>, <  -0.646348,   0.101240,  -0.469599>, <  -0.567178,   0.067500,  -0.412079> }
		triangle { <  -0.567178,   0.067500,  -0.412079>, <  -0.216643,   0.067500,  -0.666757>, <  -0.246883,   0.101240,  -0.759828> }
		triangle { <  -0.216643,   0.067500,  -0.666757>, <  -0.567178,   0.067500,  -0.412079>, <  -0.536945,   0.044400,  -0.390113> }
		triangle { <  -0.536945,   0.044400,  -0.390113>, <  -0.205095,   0.044400,  -0.631216>, <  -0.216643,   0.067500,  -0.666757> }
		triangle { <  -0.205095,   0.044400,  -0.631216>, <  -0.536945,   0.044400,  -0.390113>, <   0.000000,   0.044400,   0.000000> }
		triangle { <  -0.667260,   0.000000,   0.000000>, <  -0.539825,   0.000000,  -0.392206>, <   0.000000,   0.000000,   0.000000> }
		triangle { <  -0.539825,   0.000000,  -0.392206>, <  -0.667260,   0.000000,   0.000000>, <  -0.686830,   0.023090,   0.000000> }
		triangle { <  -0.686830,   0.023090,   0.000000>, <  -0.555657,   0.023090,  -0.403709>, <  -0.539825,   0.000000,  -0.392206> }
		triangle { <  -0.555657,   0.023090,  -0.403709>, <  -0.686830,   0.023090,   0.000000>, <  -0.711740,   0.037300,   0.000000> }
		triangle { <  -0.711740,   0.037300,   0.000000>, <  -0.575810,   0.037300,  -0.418350>, <  -0.555657,   0.023090,  -0.403709> }
		triangle { <  -0.575810,   0.037300,  -0.418350>, <  -0.711740,   0.037300,   0.000000>, <  -0.798930,   0.065720,   0.000000> }
		triangle { <  -0.798930,   0.065720,   0.000000>, <  -0.646348,   0.065720,  -0.469599>, <  -0.575810,   0.037300,  -0.418350> }
		triangle { <  -0.646348,   0.065720,  -0.469599>, <  -0.798930,   0.065720,   0.000000>, <  -0.943060,   0.065720,   0.000000> }
		triangle { <  -0.943060,   0.065720,   0.000000>, <  -0.762952,   0.065720,  -0.554317>, <  -0.646348,   0.065720,  -0.469599> }
		triangle { <  -0.762952,   0.065720,  -0.554317>, <  -0.943060,   0.065720,   0.000000>, <  -0.960850,   0.101240,   0.000000> }
		triangle { <  -0.960850,   0.101240,   0.000000>, <  -0.777344,   0.101240,  -0.564773>, <  -0.762952,   0.065720,  -0.554317> }
		triangle { <  -0.777344,   0.101240,  -0.564773>, <  -0.960850,   0.101240,   0.000000>, <  -0.798930,   0.101240,   0.000000> }
		triangle { <  -0.798930,   0.101240,   0.000000>, <  -0.646348,   0.101240,  -0.469599>, <  -0.777344,   0.101240,  -0.564773> }
		triangle { <  -0.646348,   0.101240,  -0.469599>, <  -0.798930,   0.101240,   0.000000>, <  -0.701070,   0.067500,   0.000000> }
		triangle { <  -0.701070,   0.067500,   0.000000>, <  -0.567178,   0.067500,  -0.412079>, <  -0.646348,   0.101240,  -0.469599> }
		triangle { <  -0.567178,   0.067500,  -0.412079>, <  -0.701070,   0.067500,   0.000000>, <  -0.663700,   0.044400,   0.000000> }
		triangle { <  -0.663700,   0.044400,   0.000000>, <  -0.536945,   0.044400,  -0.390113>, <  -0.567178,   0.067500,  -0.412079> }
		triangle { <  -0.536945,   0.044400,  -0.390113>, <  -0.663700,   0.044400,   0.000000>, <   0.000000,   0.044400,   0.000000> }
		triangle { <  -0.539825,   0.000000,   0.392206>, <  -0.667260,   0.000000,   0.000000>, <   0.000000,   0.000000,   0.000000> }
		triangle { <  -0.667260,   0.000000,   0.000000>, <  -0.539825,   0.000000,   0.392206>, <  -0.555657,   0.023090,   0.403709> }
		triangle { <  -0.555657,   0.023090,   0.403709>, <  -0.686830,   0.023090,   0.000000>, <  -0.667260,   0.000000,   0.000000> }
		triangle { <  -0.686830,   0.023090,   0.000000>, <  -0.555657,   0.023090,   0.403709>, <  -0.575810,   0.037300,   0.418350> }
		triangle { <  -0.575810,   0.037300,   0.418350>, <  -0.711740,   0.037300,   0.000000>, <  -0.686830,   0.023090,   0.000000> }
		triangle { <  -0.711740,   0.037300,   0.000000>, <  -0.575810,   0.037300,   0.418350>, <  -0.646348,   0.065720,   0.469599> }
		triangle { <  -0.646348,   0.065720,   0.469599>, <  -0.798930,   0.065720,   0.000000>, <  -0.711740,   0.037300,   0.000000> }
		triangle { <  -0.798930,   0.065720,   0.000000>, <  -0.646348,   0.065720,   0.469599>, <  -0.762952,   0.065720,   0.554317> }
		triangle { <  -0.762952,   0.065720,   0.554317>, <  -0.943060,   0.065720,   0.000000>, <  -0.798930,   0.065720,   0.000000> }
		triangle { <  -0.943060,   0.065720,   0.000000>, <  -0.762952,   0.065720,   0.554317>, <  -0.777344,   0.101240,   0.564773> }
		triangle { <  -0.777344,   0.101240,   0.564773>, <  -0.960850,   0.101240,   0.000000>, <  -0.943060,   0.065720,   0.000000> }
		triangle { <  -0.960850,   0.101240,   0.000000>, <  -0.777344,   0.101240,   0.564773>, <  -0.646348,   0.101240,   0.469599> }
		triangle { <  -0.646348,   0.101240,   0.469599>, <  -0.798930,   0.101240,   0.000000>, <  -0.960850,   0.101240,   0.000000> }
		triangle { <  -0.798930,   0.101240,   0.000000>, <  -0.646348,   0.101240,   0.469599>, <  -0.567178,   0.067500,   0.412079> }
		triangle { <  -0.567178,   0.067500,   0.412079>, <  -0.701070,   0.067500,   0.000000>, <  -0.798930,   0.101240,   0.000000> }
		triangle { <  -0.701070,   0.067500,   0.000000>, <  -0.567178,   0.067500,   0.412079>, <  -0.536945,   0.044400,   0.390113> }
		triangle { <  -0.536945,   0.044400,   0.390113>, <  -0.663700,   0.044400,   0.000000>, <  -0.701070,   0.067500,   0.000000> }
		triangle { <  -0.663700,   0.044400,   0.000000>, <  -0.536945,   0.044400,   0.390113>, <   0.000000,   0.044400,   0.000000> }
		triangle { <  -0.206195,   0.000000,   0.634602>, <  -0.539825,   0.000000,   0.392206>, <   0.000000,   0.000000,   0.000000> }
		triangle { <  -0.539825,   0.000000,   0.392206>, <  -0.206195,   0.000000,   0.634602>, <  -0.212242,   0.023090,   0.653214> }
		triangle { <  -0.212242,   0.023090,   0.653214>, <  -0.555657,   0.023090,   0.403709>, <  -0.539825,   0.000000,   0.392206> }
		triangle { <  -0.555657,   0.023090,   0.403709>, <  -0.212242,   0.023090,   0.653214>, <  -0.219940,   0.037300,   0.676905> }
		triangle { <  -0.219940,   0.037300,   0.676905>, <  -0.575810,   0.037300,   0.418350>, <  -0.555657,   0.023090,   0.403709> }
		triangle { <  -0.575810,   0.037300,   0.418350>, <  -0.219940,   0.037300,   0.676905>, <  -0.246883,   0.065720,   0.759828> }
		triangle { <  -0.246883,   0.065720,   0.759828>, <  -0.646348,   0.065720,   0.469599>, <  -0.575810,   0.037300,   0.418350> }
		triangle { <  -0.646348,   0.065720,   0.469599>, <  -0.246883,   0.065720,   0.759828>, <  -0.291422,   0.065720,   0.896903> }
		triangle { <  -0.291422,   0.065720,   0.896903>, <  -0.762952,   0.065720,   0.554317>, <  -0.646348,   0.065720,   0.469599> }
		triangle { <  -0.762952,   0.065720,   0.554317>, <  -0.291422,   0.065720,   0.896903>, <  -0.296919,   0.101240,   0.913823> }
		triangle { <  -0.296919,   0.101240,   0.913823>, <  -0.777344,   0.101240,   0.564773>, <  -0.762952,   0.065720,   0.554317> }
		triangle { <  -0.777344,   0.101240,   0.564773>, <  -0.296919,   0.101240,   0.913823>, <  -0.246883,   0.101240,   0.759828> }
		triangle { <  -0.246883,   0.101240,   0.759828>, <  -0.646348,   0.101240,   0.469599>, <  -0.777344,   0.101240,   0.564773> }
		triangle { <  -0.646348,   0.101240,   0.469599>, <  -0.246883,   0.101240,   0.759828>, <  -0.216643,   0.067500,   0.666757> }
		triangle { <  -0.216643,   0.067500,   0.666757>, <  -0.567178,   0.067500,   0.412079>, <  -0.646348,   0.101240,   0.469599> }
		triangle { <  -0.567178,   0.067500,   0.412079>, <  -0.216643,   0.067500,   0.666757>, <  -0.205095,   0.044400,   0.631216> }
		triangle { <  -0.205095,   0.044400,   0.631216>, <  -0.536945,   0.044400,   0.390113>, <  -0.567178,   0.067500,   0.412079> }
		triangle { <  -0.536945,   0.044400,   0.390113>, <  -0.205095,   0.044400,   0.631216>, <   0.000000,   0.044400,   0.000000> }
		triangle { <   0.206195,   0.000000,   0.634602>, <  -0.206195,   0.000000,   0.634602>, <   0.000000,   0.000000,   0.000000> }
		triangle { <  -0.206195,   0.000000,   0.634602>, <   0.206195,   0.000000,   0.634602>, <   0.212242,   0.023090,   0.653214> }
		triangle { <   0.212242,   0.023090,   0.653214>, <  -0.212242,   0.023090,   0.653214>, <  -0.206195,   0.000000,   0.634602> }
		triangle { <  -0.212242,   0.023090,   0.653214>, <   0.212242,   0.023090,   0.653214>, <   0.219940,   0.037300,   0.676905> }
		triangle { <   0.219940,   0.037300,   0.676905>, <  -0.219940,   0.037300,   0.676905>, <  -0.212242,   0.023090,   0.653214> }
		triangle { <  -0.219940,   0.037300,   0.676905>, <   0.219940,   0.037300,   0.676905>, <   0.246883,   0.065720,   0.759828> }
		triangle { <   0.246883,   0.065720,   0.759828>, <  -0.246883,   0.065720,   0.759828>, <  -0.219940,   0.037300,   0.676905> }
		triangle { <  -0.246883,   0.065720,   0.759828>, <   0.246883,   0.065720,   0.759828>, <   0.291422,   0.065720,   0.896903> }
		triangle { <   0.291422,   0.065720,   0.896903>, <  -0.291422,   0.065720,   0.896903>, <  -0.246883,   0.065720,   0.759828> }
		triangle { <  -0.291422,   0.065720,   0.896903>, <   0.291422,   0.065720,   0.896903>, <   0.296919,   0.101240,   0.913823> }
		triangle { <   0.296919,   0.101240,   0.913823>, <  -0.296919,   0.101240,   0.913823>, <  -0.291422,   0.065720,   0.896903> }
		triangle { <  -0.296919,   0.101240,   0.913823>, <   0.296919,   0.101240,   0.913823>, <   0.246883,   0.101240,   0.759828> }
		triangle { <   0.246883,   0.101240,   0.759828>, <  -0.246883,   0.101240,   0.759828>, <  -0.296919,   0.101240,   0.913823> }
		triangle { <  -0.246883,   0.101240,   0.759828>, <   0.246883,   0.101240,   0.759828>, <   0.216643,   0.067500,   0.666757> }
		triangle { <   0.216643,   0.067500,   0.666757>, <  -0.216643,   0.067500,   0.666757>, <  -0.246883,   0.101240,   0.759828> }
		triangle { <  -0.216643,   0.067500,   0.666757>, <   0.216643,   0.067500,   0.666757>, <   0.205095,   0.044400,   0.631216> }
		triangle { <   0.205095,   0.044400,   0.631216>, <  -0.205095,   0.044400,   0.631216>, <  -0.216643,   0.067500,   0.666757> }
		triangle { <  -0.205095,   0.044400,   0.631216>, <   0.205095,   0.044400,   0.631216>, <   0.000000,   0.044400,   0.000000> }
		triangle { <   0.539825,   0.000000,   0.392206>, <   0.206195,   0.000000,   0.634602>, <   0.000000,   0.000000,   0.000000> }
		triangle { <   0.206195,   0.000000,   0.634602>, <   0.539825,   0.000000,   0.392206>, <   0.555657,   0.023090,   0.403709> }
		triangle { <   0.555657,   0.023090,   0.403709>, <   0.212242,   0.023090,   0.653214>, <   0.206195,   0.000000,   0.634602> }
		triangle { <   0.212242,   0.023090,   0.653214>, <   0.555657,   0.023090,   0.403709>, <   0.575810,   0.037300,   0.418350> }
		triangle { <   0.575810,   0.037300,   0.418350>, <   0.219940,   0.037300,   0.676905>, <   0.212242,   0.023090,   0.653214> }
		triangle { <   0.219940,   0.037300,   0.676905>, <   0.575810,   0.037300,   0.418350>, <   0.646348,   0.065720,   0.469599> }
		triangle { <   0.646348,   0.065720,   0.469599>, <   0.246883,   0.065720,   0.759828>, <   0.219940,   0.037300,   0.676905> }
		triangle { <   0.246883,   0.065720,   0.759828>, <   0.646348,   0.065720,   0.469599>, <   0.762952,   0.065720,   0.554317> }
		triangle { <   0.762952,   0.065720,   0.554317>, <   0.291422,   0.065720,   0.896903>, <   0.246883,   0.065720,   0.759828> }
		triangle { <   0.291422,   0.065720,   0.896903>, <   0.762952,   0.065720,   0.554317>, <   0.777344,   0.101240,   0.564773> }
		triangle { <   0.777344,   0.101240,   0.564773>, <   0.296919,   0.101240,   0.913823>, <   0.291422,   0.065720,   0.896903> }
		triangle { <   0.296919,   0.101240,   0.913823>, <   0.777344,   0.101240,   0.564773>, <   0.646348,   0.101240,   0.469599> }
		triangle { <   0.646348,   0.101240,   0.469599>, <   0.246883,   0.101240,   0.759828>, <   0.296919,   0.101240,   0.913823> }
		triangle { <   0.246883,   0.101240,   0.759828>, <   0.646348,   0.101240,   0.469599>, <   0.567178,   0.067500,   0.412079> }
		triangle { <   0.567178,   0.067500,   0.412079>, <   0.216643,   0.067500,   0.666757>, <   0.246883,   0.101240,   0.759828> }
		triangle { <   0.216643,   0.067500,   0.666757>, <   0.567178,   0.067500,   0.412079>, <   0.536945,   0.044400,   0.390113> }
		triangle { <   0.536945,   0.044400,   0.390113>, <   0.205095,   0.044400,   0.631216>, <   0.216643,   0.067500,   0.666757> }
		triangle { <   0.205095,   0.044400,   0.631216>, <   0.536945,   0.044400,   0.390113>, <   0.000000,   0.044400,   0.000000> }
		triangle { <   0.667260,   0.000000,   0.000000>, <   0.539825,   0.000000,   0.392206>, <   0.000000,   0.000000,   0.000000> }
		triangle { <   0.539825,   0.000000,   0.392206>, <   0.667260,   0.000000,   0.000000>, <   0.686830,   0.023090,   0.000000> }
		triangle { <   0.686830,   0.023090,   0.000000>, <   0.555657,   0.023090,   0.403709>, <   0.539825,   0.000000,   0.392206> }
		triangle { <   0.555657,   0.023090,   0.403709>, <   0.686830,   0.023090,   0.000000>, <   0.711740,   0.037300,   0.000000> }
		triangle { <   0.711740,   0.037300,   0.000000>, <   0.575810,   0.037300,   0.418350>, <   0.555657,   0.023090,   0.403709> }
		triangle { <   0.575810,   0.037300,   0.418350>, <   0.711740,   0.037300,   0.000000>, <   0.798930,   0.065720,   0.000000> }
		triangle { <   0.798930,   0.065720,   0.000000>, <   0.646348,   0.065720,   0.469599>, <   0.575810,   0.037300,   0.418350> }
		triangle { <   0.646348,   0.065720,   0.469599>, <   0.798930,   0.065720,   0.000000>, <   0.943060,   0.065720,   0.000000> }
		triangle { <   0.943060,   0.065720,   0.000000>, <   0.762952,   0.065720,   0.554317>, <   0.646348,   0.065720,   0.469599> }
		triangle { <   0.762952,   0.065720,   0.554317>, <   0.943060,   0.065720,   0.000000>, <   0.960850,   0.101240,   0.000000> }
		triangle { <   0.960850,   0.101240,   0.000000>, <   0.777344,   0.101240,   0.564773>, <   0.762952,   0.065720,   0.554317> }
		triangle { <   0.777344,   0.101240,   0.564773>, <   0.960850,   0.101240,   0.000000>, <   0.798930,   0.101240,   0.000000> }
		triangle { <   0.798930,   0.101240,   0.000000>, <   0.646348,   0.101240,   0.469599>, <   0.777344,   0.101240,   0.564773> }
		triangle { <   0.646348,   0.101240,   0.469599>, <   0.798930,   0.101240,   0.000000>, <   0.701070,   0.067500,   0.000000> }
		triangle { <   0.701070,   0.067500,   0.000000>, <   0.567178,   0.067500,   0.412079>, <   0.646348,   0.101240,   0.469599> }
		triangle { <   0.567178,   0.067500,   0.412079>, <   0.701070,   0.067500,   0.000000>, <   0.663700,   0.044400,   0.000000> }
		triangle { <   0.663700,   0.044400,   0.000000>, <   0.536945,   0.044400,   0.390113>, <   0.567178,   0.067500,   0.412079> }
		triangle { <   0.536945,   0.044400,   0.390113>, <   0.663700,   0.044400,   0.000000>, <   0.000000,   0.044400,   0.000000> }
	}


//The pierced plate
difference {
	object {
		SolidMesh
		texture {
			pigment {
				crackle
				color_map {
					[ 0.0 rgb <0.675990, 0.924010, 0.870253> ]
					[ 0.42 rgb <0.726390, 0.893599, 0.837858> ]
					[ 0.85 rgb <0.796994, 0.923003, 0.885191> ]
					[ 0.95 rgb <1.000000, 1.000000, 1.000000> ]
					[ 1.0 rgb <0.000000, 0.000000, 0.000000> ]
				}
				scallop_wave
				scale 0.01
			}
			finish {
				reflection rgb 0.15
				phong 1.0 phong_size 350
			}
		}
	}
	prism {		//piercing shape
		bezier_spline
		linear_sweep
		0.0, 	//Base height
		0.1, 	//Top height
		28,
		<0.29537, 0.03020>,
		<0.10644, 0.13620>,
		<0.73665, 0.26110>,
		<0.47331, 0.46714>,
		<0.47331, 0.46714>,
		<0.21078, 0.67254>,
		<-0.08478, 0.93077>,
		<-0.37011, 0.75844>,
		<-0.37011, 0.75844>,
		<-0.64235, 0.59401>,
		<-0.66194, 0.45472>,
		<-0.37011, 0.23623>,
		<-0.37011, 0.23623>,
		<-0.05694, 0.00178>,
		<-0.97630, -0.10853>,
		<-0.57651, -0.36767>,
		<-0.57651, -0.36767>,
		<-0.30249, -0.54529>,
		<-0.26987, -0.17241>,
		<-0.08541, -0.30018>,
		<-0.08541, -0.30018>,
		<0.08897, -0.42096>,
		<-0.02456, -0.67436>,
		<0.29537, -0.58082>,
		<0.29537, -0.58082>,
		<0.57829, -0.49810>,
		<0.83986, -0.27531>,
		<0.29537, 0.03020>
		sturm
		texture {
			pigment { rgb <0.752193, 0.476661, 0.407797> }
			normal {
				granite 0.7
				triangle_wave
				scale 0.05
			}
			finish { diffuse 0.8  brilliance 0.4 }
		}
		scale <0.6, 1.2, 0.6>
		translate <0, -0.001, -0.15>
	}
	rotate x*-40
}

//The sky_sphere
#declare P_Cloud5 =
pigment {
    wrinkles
    turbulence 0.65
    octaves 6 omega 0.7 lambda 2
    color_map {
        [0.0, 0.1   color rgb <0.85, 0.85, 0.85>+<0.2, 0.2, 0.2>
                    	color rgb <0.75, 0.75, 0.75>+<0.2, 0.2, 0.2>]
        [0.1, 0.5   color rgb <0.75, 0.75, 0.75>+<0.2, 0.2, 0.2>
                    color rgb <0.258, 0.258, 0.435>+<0.2, 0.2, 0.2>  ]
        [0.5, 1.001 color rgb <0.258, 0.258, 0.435>+<0.2, 0.2, 0.2>
                    color rgb <0.258, 0.258, 0.435>+<0.2, 0.2, 0.2> ]
    }
    scale <6, 1, 6>
}
#declare P_Cloud6 =
pigment {
    bozo
    color_map {
        [0.0, 0.1  color rgb <0.85, 0.85, 0.85>+<0.2, 0.2, 0.2>
                    	color rgb <0.55, 0.60, 0.65>+<0.2, 0.2, 0.2>]
        [0.1, 0.5   color rgb <0.55, 0.60, 0.65>+<0.2, 0.2, 0.2>
                    	color rgb <0.184, 0.184, 0.309>+<0.2, 0.2, 0.2> ]
        [0.5, 1.001 color rgb <0.184, 0.184, 0.309>+<0.2, 0.2, 0.2>
                   		 color rgb <0.1, 0.1, 0.2>+<0.2, 0.2, 0.2>]
    }
    turbulence 0.65
    octaves 6 omega 0.707 lambda 2
    scale <6, 4, 6>
}
#declare S_Cloud8 =
sky_sphere {
    pigment {
        gradient y
        pigment_map {
            [0.01 rgb <0.847, 0.749, 0.847> ] // horizon
            [0.25 P_Cloud5 scale 0.25 rotate z*5]
            [0.60 P_Cloud6 scale <0.25, 0.15, 0.25> rotate z*10]
        }
    }
}

sky_sphere { S_Cloud8 scale <1, 1, 1> translate y*0.38 }
