// Persistence Of Vision raytracer version 3.1e (isosurface)
// sample file.
// By R.Suzuki
// This image contains an example of 'isosurface'.

//		helix
//			p[0] : number of helix
//			p[1] : frequency
//			p[2] : minor radius
//			p[3] : major radius
//			p[4] : shape parameter
//			p[5] : cross section
//				p[5]	= 1:  circle
//						= 2:  diamond
//						< 1:  rectangle(rounded)
//			p[6] : rotation angle for p[5]<1

global_settings { assumed_gamma 1.8 }
#version unofficial MegaPov 0.4;

camera {  
	location <15, 20, -40>
	angle 35
	look_at <0, 0, 0>
}

light_source { <140, 160, -110> color rgb <1.0, 1.0, 1.0>*1.1 }
light_source { <-30, 20, 50> color rgb <1.0, 1.0, 1.0> }

background { color red 0.184314 green 0.309804 blue 0.309804 }

isosurface {
	function {"helix1", <2, 4, 0.1, 1.5, 1, 1, 0> }
	contained_by { box { <-1.7, -5, -1.7>, <1.7, 4.5, 1.7> } }
	scale 2.2
	texture {
		pigment { color red 1.0 green 0.8 blue 0.5 }
		finish { phong 0.6 }
	}
	no_shadow
}

isosurface {
	function { "helix2", <1, -3, 1.15, 0.15, 1, 1, 0> }
	contained_by { box { <-1.3, -4, -1.3>, <1.3, 4, 1.3> } }
	scale 1.2
	texture {
		pigment { color red 0.6 green 1.0 blue 0.8 }
		finish { phong 0.6 }
	}
	translate <-12, -1, 0>
	no_shadow
}


isosurface {
	function { "helix1", <1, -1, 0.8, 1.5, 1.0, 0.5, 15> }
	contained_by { box { <-2.5, -12, -2.5>, <2.5, 10, 2.5> } }
	eval
	texture {
		pigment { color red 0.6 green 0.6 blue 1.0 }
		finish { phong 0.6 }
	}
	no_shadow
}


isosurface {
	function { "helix1", <1, 3, 0.9, 1.7, 1.0, 0.2, 45> }
	contained_by { box { <-3.0, -7, -3.0>, <3.0, 7, 3.0> } }
	eval
	texture {
		pigment { color red 1.0 green 0.7 blue 0.6 }
		finish { phong 0.6 }
	}
	scale <0.5, 1, 0.5>
	translate <9, 1, 0>
	no_shadow
}
