// MegaPov 0.4 scene file (version not know at this time Dec 27 1999)
// Writes out a data file for
// dat_3d function or uses the array direct.
// scene by David Sharp (slightly modified by Y. Smellenbergh)
// Patch added by David Sharp
#version unofficial MegaPov 0.4;
#include "colors.inc"
#include "textures.inc" 
// set UseArray to false to write a file instead of using the array direct
#declare UseArray=true;

#declare Samples=10;	
#local xsamples=Samples;
#local ysamples=Samples;
#local zsamples=Samples; 
#local Density_Array=array[xsamples][ysamples][zsamples]

#local xmin=-2;
#local ymin=-2;
#local zmin=-2;
#local xmax=2;
#local ymax=2;
#local zmax=2;
#local dxx=(xmax-xmin)/xsamples;
#local dyy=(ymax-ymin)/ysamples; 
#local dzz=(zmax-zmin)/zsamples;
                           
// Set MakeData=0 to
// save parse time if
// the data file has
// already been written:                           
/*====================*/
#declare MakeData = 1;
/*====================*/
#declare e=2.7182818;

#if(MakeData)
  #local rrlim=10;
  #local A=2;
  

  #local xx=xmin;
  #local xi=0;
  #while(xi<xsamples)
        #local yy=ymin;
        #local yi=0;
        #while(yi<ysamples)
                #local zz=zmin;
                #local zi=0;
                #while(zi<zsamples)  
/*===================================================================*/
// your own demented stuff goes in here
                        #local R=sqrt(xx*xx+yy*yy+zz*zz);

                        #local d=R*cos(xx*yy+zz);
                        #local d=(d)+(sin(xx)+sin(yy)+sin(zz)); 
                        #local rr=1;
                        #while(rr<rrlim)
                         #if(abs(d)>A) 
                          #local rr=rrlim;
                         #else
                          #if (abs(d)<=1) 
                                #local d=1-d/(abs(d)+1)*exp(-abs(d-R));
                          #else 
                                #if(d) 
                                #local d=d/(abs(d))*log(e)*log(abs(d-R));
                                #end
                          #end
                          
                         #end
                         #local rr=rr+1;
                        #end
                                                         
/*===================================================================*/
                        // we *could* write straight to the data file
                        // from here: 
                        //      #local datastring=concat(str(d,0,-1),"\n")
                        //      #write(thedata, datastring) 
                        // but instead, we write to an array ...
                        #declare Density_Array[xi][yi][zi]=d;
                     

                        #local zz=zz+dzz;
                        #local zi=zi+1;
                        
                #end
                #local yy=yy+dyy;
                #local yi=yi+1;
        #end
        #local xx=xx+dxx;              
        #local xi=xi+1;
  #end
 #if (UseArray=false)
 // ... and write out the file "all at once"
  #fopen thedata "testw.dat" write 
  #local xi=0;
  #while(xi<xsamples)
  #local yi=0;
  #while(yi<ysamples)
  #local zi=0;
  #while(zi<zsamples)
      #local datastring=concat(str(Density_Array[xi][yi][zi],0,-1),"\n")
      #write(thedata, datastring) 
  
  #local zi=zi+1;
  #end           
  #local yi=yi+1;
  #end    
  #local xi=xi+1;
  #end       

  #fclose thedata 
#end  
#end    // end of MakeData

#declare xscale=1;
#declare yscale=1;
#declare zscale=1/(xscale*yscale);

#if  (UseArray=true)
 #declare DensityFn = function {"data_3D_3", <1.0>, library   "i_dat3d", Density_Array, 
                               <xscale*xsamples,yscale*ysamples,zscale*zsamples,0>}  
#else
#declare DensityFn = function {"data_3D_3", <1.0>, library   "i_dat3d", "testw.dat", 
                               <xscale*xsamples,yscale*ysamples,zscale*zsamples,0>}  
 #end
                                  
 #include "golds.inc"
 #declare DensityTexture= texture {
     function {DensityFn}
     texture_map{

       [0 T_Gold_4D    ]
       [ 0.100  pigment{color rgbt<0.508, 0.080, 0.052,0> }]
       [ 0.315  Soft_Silver ]
       //[ 0.315  Dark_Green_Glass ]
       [ 0.324   Aluminum ]
       [ 0.462  New_Penny  ]
       [ 0.518  Orange_Glass ]

       [ 0.590  pigment{color rgbt<.9,.9,.85,0> }]
       [ 0.604  Orange_Glass]
       [ 0.635  Soft_Silver] 
       [ 0.8   Dark_Green_Glass]
       [ 0.8  pigment{color rgbt<0.328, 0.107, 0.092,0> }]
       [ .900   pigment{color rgbt<0.508, 0.080, 0.052,0> }]
       
       [ .92 T_Gold_4D]
       [1.01 T_Gold_4D]

     }

     frequency .15
   }

camera { location 4*<65, 25, 35> direction <0, 0, 6.0> look_at <0,0,0> }

light_source {4*<50, 180, 30> color White}

light_source {4*<60, -25, 0> color White}



object{
    isosurface
    {
      function   {DensityFn} 
     
      threshold  2
      sign 1     
      contained_by{sphere{0,13}}
      eval
      max_gradient 8
    }
    texture{DensityTexture}
    
  scale 1.5
}


sky_sphere
{
  pigment
  {
    gradient y    
    color_map { [0.0 color rgb <0.5,0.7,1.0>] [1.0 color rgb .6*<0.5,0.7,.7>] }
  }
}
