// Persistence Of Vision raytracer version 3.1e isosurface patch
// sample file. By R.Suzuki.
// This image contains an example of 'isosurface'.
#version unofficial MegaPov 0.4;

#include "colors.inc"
#include "textures.inc"

//------  declare Objects ------------
#declare PsObject = 
isosurface {  
	function  {  "func_13", <5.5>,  library "i_nfunc" }
	contained_by { box { <-6, -3, -6>, <6, 3, 6> } }
	max_gradient 1.5
}

#declare FuchiObject =
isosurface {  
	function { "func_6", <6, 4, 0.5, 0.2, 0.7,1,0>,  library "i_nfunc" }
	contained_by { box { <-1, -8, -1>, <1, 8, 1> } }
	max_gradient 3.5
	texture{ Yellow_Pine }
}

#declare Leg1Object=
isosurface {  
	function  { "func_6", <1, 6, 0.3, 1.0, 0.77,1,0>,  library "i_nfunc" }
	contained_by { box { <-1.5, -4, -1.5>, <1.5, 4, 1.5> } }
	max_gradient 2.1
	texture {
		pigment { Blue_Agate }
		finish { phong 1.0 }
	}
}

#declare Leg2Object=
isosurface {
	function { "func_12", <1.0, 9, 3, 0, 1.0, 0.3, 0.1, -6, 0.1,-64>, library "i_nfunc" }
	contained_by { box { <-2.5, -1, -2.5>, <2.5, 1, 2.5> } }
	max_gradient 7.5
	texture {
		pigment {color red 0.5 green 0.4 blue 0.2 }
		finish { phong 1.0 reflection 0.6 }
	}
}

#declare CornerObject=
sphere {
	<8, -3, 8>, 2
	texture {
        pigment { color red 0.25 green 0.3 blue 0.3	}
        finish { phong 0.8 reflection 0.7	}
	}
}

//------------------------------------------------
camera {  
	location <24, 24, -45>
	direction <0, 0,  2.3>
	look_at <0,-8,0>
}

light_source { <150, 400, -120> color White }
light_source { <350, 200, -120> color White }

// -----------  POSITRONIUM   -------------------
object {
	PsObject
	texture {
		pigment { color red 1.0 green 0.7 blue 0.7 filter 0.8 }
		finish { phong 1.0 reflection 0.2 }
	}
	interior { ior 1.5 }
	rotate <0, 230, 0>
}

object {
	PsObject
	texture {
		pigment { color red 0.7 green 0.7 blue 1.0 filter 0.8 }
		finish { phong 1.0 reflection 0.2 }
	}
	interior { ior 1.5 }
	rotate <0, 50, 0>
}

//------------ MESH ----------------------
isosurface {  
	function { "mesh1", <4, 4, 0.5, 0.3, 1> }
	contained_by { box { <-16, -1.0, -16>, <16, 1.0, 16> } }
	threshold 0.3
	max_gradient 1.2
	eval
	texture {
		pigment { White_Wood }
		finish { phong 1.0 }
	}
	scale <0.5, 0.5, 0.5>
	translate <0, -3, 0>
}
//-----------------------------------------------
//----------  FUCHI ------------------
object { FuchiObject  rotate x*90   translate <8,-3,0> }
object { FuchiObject  rotate x*90   translate <-8,-3,0> }
object { FuchiObject  rotate z*90   translate <0,-3,8> }
object { FuchiObject  rotate z*90   translate <0,-3,-8> }

//--------------  LEG   -----------------
object { Leg1Object   translate <8,-7,-8> }
object { Leg1Object   translate <8,-7,8> }
object { Leg1Object   translate <-8,-7,8> }
object { Leg1Object   translate <-8,-7,-8> }

//-------- LEG2 ------------------
object { Leg2Object  translate <8, -11, -8> }
object { Leg2Object  translate <8, -11, 8> }
object { Leg2Object  translate <-8, -11, 8> }
object { Leg2Object  translate <-8, -11, -8> }

//--------------- corner ----------------
object { CornerObject rotate y*0 }
object { CornerObject rotate y*90 }
object { CornerObject rotate y*180 }
object { CornerObject rotate y*270 }

//---------------  ground  ------------------------
plane {
	<0, 1, 0>, 0
	texture {
		pigment {
			marble
			turbulence 1
			color_map {
				[0.0		color red 0.65 green 0.75 blue 0.65 ]
				[0.75		color red 0.5 green 0.5 blue 0.35 ]
				[0.75		color red 0.5 green 0.5 blue 0.35 ]
				[1.01		color red 0.3 green 0.2 blue 0.3 ]
			}
		}
		finish { reflection 0.4}
	scale 10
	translate <0,-12.,0>
	}
	no_shadow
}

background {color Gray30}
