//	Persistence of Vision Ray Tracer Scene Description File
#version unofficial MegaPov 0.4;

#include "colors.inc"

camera {location <0,0,-15> look_at <0,0,0>}

light_source {<-50, 40, -20> rgb 1}
light_source {<  0, 40, -50> rgb 1}

background {color rgb .4}

// the <0>'s are "dummy" parameters
#declare F1= function{"hex_x",<0>} 
#declare F2= function{"hex_y",<0>}

#declare Dis=3.5;
#declare Sz=3;
isosurface {
     function{(F1-.65) | (0.6*F2-.08)}
     contained_by{box{<-Sz,-Sz,-1>,<Sz,Sz,1>}}
//     pigment {Yellow}
	method 1
	eval
	pigment {
		hexagon 
		rgb <1.000000, 0.000000, 0.000000>,
		rgb <0.000000, 1.000000, 0.000000>,
		rgb <0.000000, 0.000000, 1.000000>
		rotate x*90
		rotate z*30
	}
     translate<-Dis,Dis,0>     
}

isosurface {
	function{(0.8*F2-.08) | (F1-2*F2-.08)}
	contained_by{box{<-Sz,-Sz,-1>,<Sz,Sz,1>}}
	method 1
	eval
	pigment {
		hexagon 
		rgb <1.000000, 0.000000, 0.000000>,
		rgb <0.000000, 1.000000, 0.000000>,
		rgb <0.000000, 0.000000, 1.000000>
		rotate x*90
		rotate z*30
	}
//	pigment {Yellow}
	translate<Dis,Dis,0> 
}

isosurface {
	function{(F1-.85) / (F1-.4)}
	contained_by{box{<-Sz,-Sz,-1>,<Sz,Sz,1>}}
	method 1
	eval
//	pigment {Yellow}
	pigment {
		hexagon 
		rgb <1.000000, 0.000000, 0.000000>,
		rgb <0.000000, 1.000000, 0.000000>,
		rgb <0.000000, 0.000000, 1.000000>
		rotate x*90
		rotate z*30
	}
     translate<-Dis,-Dis,0>
}

isosurface {
     function{(F1-.55) / (F1-.4)}
     contained_by{box{<-Sz,-Sz,-1>,<Sz,Sz,1>}}
//     pigment {Yellow}     
	method 1
	eval
	pigment {
		hexagon 
		rgb <1.000000, 0.000000, 0.000000>,
		rgb <0.000000, 1.000000, 0.000000>,
		rgb <0.000000, 0.000000, 1.000000>
		rotate x*90
		rotate z*30
	}
     translate<Dis,-Dis,0>
}
