// Persistence Of Vision raytracer version 3.1 (isosurface patch)
// sample file by R.Suzuki   <rsuzuki@etl.go.jp>  Apr.'99
#version unofficial MegaPov 0.4;

#include "isocom.inc"
camera { location <0, 20, -70>  direction <0, 0,  4.2> look_at <0,0,0>}


#declare R0=0.9;
#declare R1=0.4;

#declare T1=object{isosurface
 {
     function {"torus",<R0,R1>}
     contained_by{ box {<-R0-R1,-R1,-R0-R1>,<R0+R1,R1,R0+R1>}} 
     texture {ComBl}
 }  
 no_shadow
}

#declare Count=5;
#while (Count>0)  
  isosurface
  {
     function {"helix2",<0,Count,R0,R1,1,1,0>}
     contained_by{ box {<-R0-R1,-R0*2,-R0-R1>,<R0+R1,R0*2,R0+R1>}}
     eval 
     texture {ComYw}
     translate <-12+Count*4,R0*6,0>
     no_shadow
  }
  object{T1   translate <-12+Count*4,R0*8,0>}
  object{T1   translate <-12+Count*4,R0*4,0>}
  #declare Count=Count-1;
#end


#declare Count=5;
#while (Count>0)             
#declare R2=R0+R1+Count*0.2-0.4;
  isosurface
  {
     function {"helix2",<1,3,R0,R1+Count*0.2-0.4,1,1,0>}
     contained_by{ box {<-R2,-R0*2,-R2>,<R2,R0*2,R2>}}  
     eval
     texture {ComYw}
     translate <-12+Count*4,0,0>
     no_shadow
  }
  object{T1   translate <-12+Count*4,R0*2,0>}
  object{T1   translate <-12+Count*4,-R0*2,0>}
  #declare Count=Count-1;
#end

#declare Count=5;
#declare R2=R0+R1+Count*0.2-0.4;
#while (Count>0)  
  isosurface
  {
     function {"helix2",<1,3,R0+Count*0.2-0.4,R1,1,1,0>}
     contained_by{ box {<-R2,-R0*2,-R2>,<R2,R0*2,R2>}}  
     texture {ComYw}
     translate <-12+Count*4,-R0*6,0>
     no_shadow
  }
  object{T1   translate <-12+Count*4,-R0*4,0>}
  object{T1   translate <-12+Count*4,-R0*8,0>}
  #declare Count=Count-1;
#end
