//	Persistence of Vision Ray Tracer Scene Description File
//	File: truerand.pov
//	Date: 01/01/2000
//	Author: Ren Smellenbergh
//	Demo scene for true random seed. With each render a different seed will be used,
//  based on the computer internal clock.
#version unofficial MegaPov 0.4;
	
camera {
	location <0.0, 0.0, -8>
	up y*image_height right x*image_width
	angle 60
	look_at <0.0, 0.0, 0.0>
}

light_source { <200, 1000, -5000> 	rgb 1 }

//**************first row of random spheres*****************
#declare C = 0;
#declare Copies = 20;
//tick_count returns the current internal clock counter
#declare Jump=seed(tick_count );

#while ( C < Copies)
	sphere {
		<0.0, 0.0, 0.0>, 0.2
		translate x * (-3 + (C * (3 - (-3))/(Copies -1)))
		translate y*(rand(Jump))		//use seed from thick_count
		translate y*1
		#declare R = (1.000000 + (C * (0.978378 -(1.000000))/(Copies -1)));
		#declare G = (0.000000 + (C * (1.000000 -(0.000000))/(Copies -1)));
		#declare B = (0.000000 + (C * (0.350027 -(0.000000))/(Copies -1)));
		texture { pigment { rgb <R, G, B> } }
	} //object
	#declare C = C +1;
#end  //while (C < Copies)

//*******************second row of random spheres ******************
#declare C = 0;
#declare Copies = 20;
//this second time the value of thick_count will be higher because the counter increases by
//200 to 60 times per seconds, depending on the platform
//(60=Macintosh, 200= Atari and Intell????)
#declare Jump=seed(tick_count );
#while ( C < Copies)
	sphere {
		<0.0, 0.0, 0.0>, 0.2
		translate x * (-3 + (C * (3 - (-3))/(Copies -1)))
		translate y*(rand(Jump))		//use seed from thick_count
		translate y*-1.5
		#declare R = (1.000000 + (C * (0.978378 -(1.000000))/(Copies -1)));
		#declare G = (0.000000 + (C * (1.000000 -(0.000000))/(Copies -1)));
		#declare B = (0.000000 + (C * (0.350027 -(0.000000))/(Copies -1)));
		texture { pigment { rgb <R, G, B> } }
	} //object
	#declare C = C +1;
#end  //while (C < Copies)
