diff -c3 -o -r ./change31.doc \povray3/change31.doc
*** ./change31.doc	Sun Sep 13 14:05:46 1998
--- \povray3/change31.doc	Tue Sep 29 13:33:40 1998
***************
*** 1,5 ****
--- 1,13 ----
  This file is a historical record of changes to POV-Ray 3.1 as we develop it.
  
+ 3.1a               9/29/98 Chris Young
+ Fixed problem with sor and lathe affecting unix and amiga
+ Fixed fclose in FILE_EXISTS
+ Fixed crackle and black_hole use of POV_SRAND.
+   Note POV_SRAND and POV_RAND no longer reconfigurable 
+   in frame.h or config.h.  If you redefined them on your
+   platform -- don't.
+ 
  3.1  Final Patch   9/13/98 Chris Young
  Fixed media bug in multi-density declared media
  Fixed included macro crash
diff -c3 -o -r ./source/bcyl.c \povray3/source/bcyl.c
*** ./source/bcyl.c	Fri May 22 16:47:30 1998
--- \povray3/source/bcyl.c	Mon Sep 28 13:45:34 1998
***************
*** 405,410 ****
--- 405,413 ----
  
      switch (intersect_thick_cylinder(BCyl, Entry, dist))
      {
+       case 0:
+         break;
+ 
        case 2:
  
          if (dist[0] > EPSILON)
diff -c3 -o -r ./source/express.c \povray3/source/express.c
*** ./source/express.c	Mon Aug 31 14:33:20 1998
--- \povray3/source/express.c	Mon Sep 28 14:02:24 1998
***************
*** 320,326 ****
              GET (LEFT_PAREN_TOKEN);
              Local_String=Parse_String();
              Val = ((f=Locate_File(Local_String,READ_BINFILE_STRING,"","",NULL,FALSE))==NULL) ? 0.0 : 1.0;
!             fclose(f);
              POV_FREE(Local_String);
              GET (RIGHT_PAREN_TOKEN);
              break;
--- 320,329 ----
              GET (LEFT_PAREN_TOKEN);
              Local_String=Parse_String();
              Val = ((f=Locate_File(Local_String,READ_BINFILE_STRING,"","",NULL,FALSE))==NULL) ? 0.0 : 1.0;
!             if (f != NULL)
!             {
!                fclose(f);
!             }
              POV_FREE(Local_String);
              GET (RIGHT_PAREN_TOKEN);
              break;
diff -c3 -o -r ./source/frame.h \povray3/source/frame.h
*** ./source/frame.h	Thu Aug 27 13:52:44 1998
--- \povray3/source/frame.h	Mon Sep 28 15:04:44 1998
***************
*** 443,462 ****
  
  
  /*
-  * Functions which have POV default replacements, but which can be replaced
-  * by system-specific functions.  Care should be taken with the RAND
-  * functions, as changing these means your images will render differently.
-  */
- #ifndef POV_RAND   /* Return a pseudo-random 32-bit value in [0, 2^32-1] */
- #define POV_RAND() POV_Std_rand()
- #endif
- 
- #ifndef POV_SRAND  /* Seed the random number generator with the given value */
- #define POV_SRAND(i) POV_Std_srand(i)
- #endif
- 
- 
- /*
   * Functions that write text for the user to see.  These functions will
   * usually be customized for GUI environments so that POV outputs its
   * messages to a status bar or popup window.
--- 443,448 ----
diff -c3 -o -r ./source/optout.h \povray3/source/optout.h
*** ./source/optout.h	Sun Sep 13 14:22:40 1998
--- \povray3/source/optout.h	Tue Sep 29 12:37:14 1998
***************
*** 33,39 ****
  
  /* These are used by OPTOUT.C and the machine specific modules */
  
! #define POV_RAY_VERSION "3.1"
  
  #define DISTRIBUTION_MESSAGE_1 "This is an unofficial version compiled by:"
  #define DISTRIBUTION_MESSAGE_2 "FILL IN NAME HERE........................."
--- 33,39 ----
  
  /* These are used by OPTOUT.C and the machine specific modules */
  
! #define POV_RAY_VERSION "3.1a"
  
  #define DISTRIBUTION_MESSAGE_1 "This is an unofficial version compiled by:"
  #define DISTRIBUTION_MESSAGE_2 "FILL IN NAME HERE........................."
diff -c3 -o -r ./source/pattern.c \povray3/source/pattern.c
*** ./source/pattern.c	Wed Jul 15 18:25:00 1998
--- \povray3/source/pattern.c	Mon Sep 28 15:10:28 1998
***************
*** 1363,1369 ****
  
  static long PickInCube(VECTOR tv, VECTOR  p1)
  {
!   int seed;
    VECTOR flo;
  
    /*
--- 1363,1369 ----
  
  static long PickInCube(VECTOR tv, VECTOR  p1)
  {
!   int seed, temp;
    VECTOR flo;
  
    /*
***************
*** 1378,1388 ****
--- 1378,1392 ----
  
    seed = Hash3d((int)flo[X], (int)flo[Y], (int)flo[Z]);
  
+   temp = POV_GET_OLD_RAND(); /* save current seed */
+   
    POV_SRAND(seed);
  
    p1[X] = flo[X] + FRAND();
    p1[Y] = flo[Y] + FRAND();
    p1[Z] = flo[Z] + FRAND();
+ 
+   POV_SRAND(temp);  /* restore */
  
    return((long)seed);
  }
diff -c3 -o -r ./source/texture.c \povray3/source/texture.c
*** ./source/texture.c	Mon Aug 31 18:51:48 1998
--- \povray3/source/texture.c	Mon Sep 28 15:17:46 1998
***************
*** 1393,1399 ****
  *
  * FUNCTION
  *
! *   POV_Std_rand
  *
  * INPUT
  *
--- 1393,1399 ----
  *
  * FUNCTION
  *
! *   POV_RAND
  *
  * INPUT
  *
***************
*** 1417,1423 ****
  *
  ******************************************************************************/
  
! int POV_Std_rand()
  {
    next_rand = next_rand * 1812433253L + 12345L;
  
--- 1417,1423 ----
  *
  ******************************************************************************/
  
! int POV_RAND()
  {
    next_rand = next_rand * 1812433253L + 12345L;
  
***************
*** 1424,1429 ****
--- 1424,1434 ----
    return((int)(next_rand >> 16) & RNDMASK);
  }
  
+ int POV_GET_OLD_RAND()
+ {
+   return(next_rand);
+ }
+ 
  
  
  /*****************************************************************************
***************
*** 1430,1436 ****
  *
  * FUNCTION
  *
! *   POV_Std_srand
  *
  * INPUT
  *
--- 1435,1441 ----
  *
  * FUNCTION
  *
! *   POV_SRAND
  *
  * INPUT
  *
***************
*** 1454,1460 ****
  *
  ******************************************************************************/
  
! void POV_Std_srand(int seed)
  {
    next_rand = (unsigned long int)seed;
  }
--- 1459,1465 ----
  *
  ******************************************************************************/
  
! void POV_SRAND(int seed)
  {
    next_rand = (unsigned long int)seed;
  }
diff -c3 -o -r ./source/texture.h \povray3/source/texture.h
*** ./source/texture.h	Mon Aug 31 18:52:06 1998
--- \povray3/source/texture.h	Mon Sep 28 15:15:20 1998
***************
*** 101,108 ****
  TEXTURE *Create_Texture (void);
  int Test_Opacity (TEXTURE *Texture);
  TURB *Create_Turb (void);
! int POV_Std_rand (void);
! void POV_Std_srand (int seed);
  
  
  #endif
--- 101,109 ----
  TEXTURE *Create_Texture (void);
  int Test_Opacity (TEXTURE *Texture);
  TURB *Create_Turb (void);
! int POV_RAND (void);
! void POV_SRAND (int seed);
! int POV_GET_OLD_RAND(void);
  
  
  #endif
diff -c3 -o -r ./source/warps.c \povray3/source/warps.c
*** ./source/warps.c	Wed Aug  5 13:13:52 1998
--- \povray3/source/warps.c	Mon Sep 28 15:12:46 1998
***************
*** 75,81 ****
  void Warp_EPoint (VECTOR TPoint, VECTOR EPoint, TPATTERN *TPat)
  {
     VECTOR PTurbulence,RP;
!    int Axis,i;
     int blockX = 0, blockY = 0, blockZ = 0 ;
     SNGL BlkNum;
     DBL  Length;
--- 75,81 ----
  void Warp_EPoint (VECTOR TPoint, VECTOR EPoint, TPATTERN *TPat)
  {
     VECTOR PTurbulence,RP;
!    int Axis,i,temp_rand;
     int blockX = 0, blockY = 0, blockZ = 0 ;
     SNGL BlkNum;
     DBL  Length;
***************
*** 164,173 ****
--- 164,177 ----
              {
                /* if the position is uncertain calculate the new one first */
                /* this will allow the same numbers to be returned by frand */
+               
+               temp_rand = POV_GET_OLD_RAND(); /*protect seed*/
+   
                POV_SRAND (Hash3d (blockX, blockY, blockZ)) ;
                Center [X] += FRAND () * Black_Hole->Uncertainty_Vector [X] ;
                Center [Y] += FRAND () * Black_Hole->Uncertainty_Vector [Y] ;
                Center [Z] += FRAND () * Black_Hole->Uncertainty_Vector [Z] ;
+               POV_SRAND (temp_rand) ;  /*restore*/
              }
  
              Center [X] += Black_Hole->Repeat_Vector [X] * blockX ;
