diff -c3 -o -r ./change31.doc \povray3/change31.doc
*** ./change31.doc	Mon Jan 18 19:39:20 1999
--- \povray3/change31.doc	Fri Jan 29 14:49:26 1999
***************
*** 1,5 ****
--- 1,10 ----
  This file is a historical record of changes to POV-Ray 3.1 as we develop it.
  
+ 3.1c               1/29/99 Chris Young
+ Fixed radiosity preview with odd screen size.
+ Reinitialized max_trace_level & radiosity_trace_level properly
+ Fixed token at end of file with no cr/lf or newline
+ 
  3.1b               1/18/99 Chris Young
  Blob elements transformed after textures now works
  Can now declare 2D vectors
diff -c3 -o -r ./source/optout.h \povray3/source/optout.h
*** ./source/optout.h	Sun Oct  4 17:54:54 1998
--- \povray3/source/optout.h	Fri Jan 29 15:02:52 1999
***************
*** 33,39 ****
  
  /* These are used by OPTOUT.C and the machine specific modules */
  
! #define POV_RAY_VERSION "3.1b"
  
  #define DISTRIBUTION_MESSAGE_1 "This is an unofficial version compiled by:"
  #define DISTRIBUTION_MESSAGE_2 "FILL IN NAME HERE........................."
--- 33,39 ----
  
  /* These are used by OPTOUT.C and the machine specific modules */
  
! #define POV_RAY_VERSION "3.1c"
  
  #define DISTRIBUTION_MESSAGE_1 "This is an unofficial version compiled by:"
  #define DISTRIBUTION_MESSAGE_2 "FILL IN NAME HERE........................."
diff -c3 -o -r ./source/render.c \povray3/source/render.c
*** ./source/render.c	Mon Jan 18 18:41:04 1999
--- \povray3/source/render.c	Fri Jan 29 14:36:18 1999
***************
*** 364,369 ****
--- 364,370 ----
    VEC2 *Standard_Sample_Grid;
  
    maxclr = (DBL)(1 << Color_Bits) - 1.0;
+   Radiosity_Trace_Level = 1;
  
    size = (Frame.Screen_Width + 1) * sizeof(COLOUR);
  
***************
*** 1075,1102 ****
                upa[x] = Alpha;
              }
  
!             ulr = (x>0) ? upr[x-skip] : Red;
              urr = upr[x];
  
!             llr = (x>0) ? lastr   : Red;
              lrr = Red;
  
!             ulg = (x>0) ? upg[x-skip] : Green;
              urg = upg[x];
  
!             llg = (x>0) ? lastg   : Green;
              lrg = Green;
  
!             ulb = (x>0) ? upb[x-skip] : Blue;
              urb = upb[x];
  
!             llb = (x>0) ? lastb   : Blue;
              lrb = Blue;
  
!             ula = (x>0) ? upa[x-skip] : Alpha;
              ura = upa[x];
  
!             lla = (x>0) ? lasta   : Alpha;
              lra = Alpha;
  
              for (ty = y, dy = 0; (dy < skip) && (ty < opts.Last_Line); dy++, ty++)
--- 1076,1103 ----
                upa[x] = Alpha;
              }
  
!             ulr = (x>opts.First_Column) ? upr[x-skip] : Red;
              urr = upr[x];
  
!             llr = (x>opts.First_Column) ? lastr   : Red;
              lrr = Red;
  
!             ulg = (x>opts.First_Column) ? upg[x-skip] : Green;
              urg = upg[x];
  
!             llg = (x>opts.First_Column) ? lastg   : Green;
              lrg = Green;
  
!             ulb = (x>opts.First_Column) ? upb[x-skip] : Blue;
              urb = upb[x];
  
!             llb = (x>opts.First_Column) ? lastb   : Blue;
              lrb = Blue;
  
!             ula = (x>opts.First_Column) ? upa[x-skip] : Alpha;
              ura = upa[x];
  
!             lla = (x>opts.First_Column) ? lasta   : Alpha;
              lra = Alpha;
  
              for (ty = y, dy = 0; (dy < skip) && (ty < opts.Last_Line); dy++, ty++)
***************
*** 1133,1140 ****
            }
            else
            {
!             y2 = min(y + skip - 1, opts.Last_Line);
!             x2 = min(x + skip - 1, opts.Last_Column);
  
              POV_DISPLAY_PLOT_RECT(x, y, x2, y2, Red, Green, Blue, Alpha);
            }
--- 1134,1141 ----
            }
            else
            {
!             y2 = min(y + skip - 1, opts.Last_Line - 1);
!             x2 = min(x + skip - 1, opts.Last_Column - 1);
  
              POV_DISPLAY_PLOT_RECT(x, y, x2, y2, Red, Green, Blue, Alpha);
            }
diff -c3 -o -r ./source/tokenize.c \povray3/source/tokenize.c
*** ./source/tokenize.c	Mon Jan 18 18:24:20 1999
--- \povray3/source/tokenize.c	Fri Jan 29 14:36:24 1999
***************
*** 129,135 ****
  };
  
  static CS_ENTRY *Cond_Stack;
! static int CS_Index, Skipping, Inside_Ifdef, Inside_MacroDef;
  
  int input_file_in_memory = 0 ;
  
--- 129,135 ----
  };
  
  static CS_ENTRY *Cond_Stack;
! static int CS_Index, Skipping, Got_EOF, Inside_Ifdef, Inside_MacroDef;
  
  int input_file_in_memory = 0 ;
  
***************
*** 677,683 ****
  
    Echo_Line = 0;
    Echo_Ptr = Echo_Buff[0];
! 
    /* Init conditional stack. */
  
    Cond_Stack = (CS_ENTRY*)POV_MALLOC(sizeof(CS_ENTRY) * COND_STACK_SIZE, "conditional stack");
--- 677,684 ----
  
    Echo_Line = 0;
    Echo_Ptr = Echo_Buff[0];
!   Got_EOF  = FALSE;
!   
    /* Init conditional stack. */
  
    Cond_Stack = (CS_ENTRY*)POV_MALLOC(sizeof(CS_ENTRY) * COND_STACK_SIZE, "conditional stack");
***************
*** 686,692 ****
    Cond_Stack[0].Switch_Value = 0.0;
  
    init_sym_tables();
! 
  }
  
  
--- 687,693 ----
    Cond_Stack[0].Switch_Value = 0.0;
  
    init_sym_tables();
!   Max_Trace_Level = 5;      
  }
  
  
***************
*** 765,770 ****
--- 766,772 ----
    if (Data_File->Filename != NULL)
    {
      fclose (Data_File->File);
+     Got_EOF=FALSE;
  
      POV_FREE (Data_File->Filename);
  
***************
*** 778,783 ****
--- 780,786 ----
      if (Data_File->Filename != NULL)
      {
        fclose (Data_File->File);
+       Got_EOF=FALSE;
  
        POV_FREE (Data_File->Filename);
  
***************
*** 892,897 ****
--- 895,901 ----
        UICB_CLOSE_INCLUDE_FILE  /* Notify UI that we are about to close an include file normally */
  
        fclose(Data_File->File); /* added to fix open file buildup JLN 12/91 */
+       Got_EOF=FALSE;
        
        Destroy_Table(Table_Index--);
  
***************
*** 1938,1944 ****
  {
    register int c;
  
!   Echo_Ptr[Echo_Indx++] = c = getc(Data_File->File);
  
    if ((Echo_Indx > Echo_Line_Length) || (c == '\n'))
    {
--- 1942,1962 ----
  {
    register int c;
  
!   if (Got_EOF)
!   {
!     return(EOF);
!   }
!   
!   c = getc(Data_File->File);
!   
!   if (c == EOF)
!   {
!     ungetc(c,Data_File->File);
!     c = '\n';
!     Got_EOF=TRUE;
!   }
! 
!   Echo_Ptr[Echo_Indx++] = c;
  
    if ((Echo_Indx > Echo_Line_Length) || (c == '\n'))
    {
***************
*** 2363,2368 ****
--- 2381,2387 ----
                Error("#while loop didn't end in file where it started.");
             }
             
+            Got_EOF=FALSE;
             if (fseek(Data_File->File, Cond_Stack[CS_Index].Pos,0) < 0)
             {
                Error("Unable to seek in input file for #while directive.\n");
***************
*** 2768,2773 ****
--- 2787,2802 ----
  
     UICB_OPEN_INCLUDE_FILE  /* Notify UI that we are about to open an include file */
  
+    Echo_Ptr[Echo_Indx++] = '\n';
+    Echo_Ptr[Echo_Indx] = '\0';
+    Echo_Indx = 0;
+    Echo_Line++;
+    if (Echo_Line == Num_Echo_Lines)
+    {
+      Echo_Line = 0;
+    }
+    Echo_Ptr=Echo_Buff[Echo_Line];
+ 
     Data_File = &Include_Files[Include_File_Index];
     Data_File->Line_Number = 0;
  
***************
*** 3235,3240 ****
--- 3264,3270 ----
      /* Not in same file */
      Cond_Stack[CS_Index].Macro_Same_Flag=FALSE;
      fclose(Data_File->File);
+     Got_EOF=FALSE;
      Data_File->Filename = POV_STRDUP(PMac->Macro_Filename);
      Data_File->R_Flag=FALSE;
      if ((Data_File->File = Locate_File (Data_File->Filename, READ_TXTFILE_STRING,"","",NULL,TRUE)) == NULL)
***************
*** 3252,3257 ****
--- 3282,3288 ----
  
    Data_File->Line_Number=PMac->Macro_Line_No;
  
+   Got_EOF=FALSE;
    if (fseek(Data_File->File, PMac->Macro_Pos,0) < 0)
    {
      Error("Unable to file seek in macro.\n");
***************
*** 3272,3277 ****
--- 3303,3309 ----
    if (!Cond_Stack[CS_Index].Macro_Same_Flag)
    {
       fclose(Data_File->File);
+      Got_EOF=FALSE;
       POV_FREE(Data_File->Filename);
       Data_File->Filename = Cond_Stack[CS_Index].Macro_Return_Name;
       Data_File->R_Flag=FALSE;
***************
*** 3286,3291 ****
--- 3318,3324 ----
   
    Data_File->Line_Number = Cond_Stack[CS_Index].Line_No;
  
+   Got_EOF=FALSE;
    if (fseek(Data_File->File, Cond_Stack[CS_Index].Pos,0) < 0)
    {
      Error("Unable to file seek in return from macro.\n");
***************
*** 3467,3472 ****
--- 3500,3506 ----
         Data=(DATA_FILE *)Token.Data;
         fflush(Data->File);
         fclose(Data->File);
+        Got_EOF=FALSE;
         Data->File = NULL;       /* <--- this line added -hdf- */
         Remove_Symbol (1,Token.Token_String);
         EXIT
***************
*** 3552,3557 ****
--- 3586,3592 ----
     if (End_File)
     {
        fclose(User_File->File);
+       Got_EOF=FALSE;
        User_File->File = NULL;   /* <--- this line added -hdf- */
        Remove_Symbol (1,File_Id);
     }
