/*
**  Str - String Library
**  Copyright (c) 1999-2000 Ralf S. Engelschall <rse@engelschall.com>
**
**  This file is part of Str, a string handling and manipulation 
**  library which can be found at http://www.engelschall.com/sw/str/.
**
**  Permission to use, copy, modify, and distribute this software for
**  any purpose with or without fee is hereby granted, provided that
**  the above copyright notice and this permission notice appear in all
**  copies.
**
**  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
**  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
**  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
**  IN NO EVENT SHALL THE AUTHORS AND COPYRIGHT HOLDERS AND THEIR
**  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
**  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
**  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
**  USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
**  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
**  OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
**  OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
**  SUCH DAMAGE.
**
**  str.h: public API header
*/

#ifndef _STR_H_
#define _STR_H_

    /* C++ support */
#ifdef __cplusplus
#define BEGIN_DECLARATION extern "C" {
#define END_DECLARATION   }
#else
#define BEGIN_DECLARATION /*nop*/
#define END_DECLARATION   /*nop*/
#endif

#include <string.h>
#include <sys/types.h>
#include <stdarg.h>
#include <ctype.h>

/* true and false boolean values and corresponding type */
#undef TRUE
#undef FALSE
#undef BOOL
#ifdef __cplusplus
#define BOOL  bool
#define TRUE  true
#define FALSE false
#else
#define BOOL  char
#define TRUE  ((BOOL)(1 == 1))
#define FALSE ((BOOL)(0 == 1))
#endif

/* null values for pointers and characters */
#ifndef NULL
#define NULL ((void *)0)
#endif
#ifndef NUL
#define NUL '\0'
#endif

BEGIN_DECLARATION

typedef unsigned int str_size_t;

#define STR_RIGHT        (1 << 0)  /* operate from right end */
#define STR_COMPLEMENT   (1 << 1)  /* use complement */
#define STR_NOCASE       (1 << 2)  /* no case sensitive operation */
#define STR_STRIPQUOTES  (1 << 3)  /* strip quote characters */
#define STR_BACKSLASHESC (1 << 4)  /* enable ANSI C style (backslashed) escape sequences */
#define STR_SKIPDELIMS   (1 << 5)  /* skip trailing delimiters before return */
#define STR_TRIGRAPHS    (1 << 6)  /* enable ANSI C trigraph processing (implies STR_BACKSLASHESCAPE) */

extern str_size_t  str_len        (const char *);
extern char       *str_copy       (char *, const char *, str_size_t);
extern char       *str_dup        (const char *, str_size_t);
extern char       *str_concat     (char *, ...);
extern char       *str_splice     (char *, str_size_t, str_size_t, char *, str_size_t);
extern char       *str_token      (char **, const char *, const char *, const char *, int);
extern int         str_parse      (const char *, const char *, ...);
extern int         str_compare    (const char *, const char *, str_size_t, int);
extern char       *str_span       (const char *, str_size_t, const char *, int);
extern char       *str_locate     (const char *, str_size_t, const char *);
extern int         str_format     (char *, str_size_t, const char *, ...);

END_DECLARATION

#endif /* _STR_H_ */

