/*
** mm_test.c -- Test Functions
*/

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/wait.h>

#define MM_PRIVATE
#include "mm.h"

int main(int argc, char *argv[]) 
{
    char *core;
    int i;
    size_t s;
    pid_t pid;
    int *count;
	MM *mm;
	char *cp1, *cp2, *cp3;
	char *cp[1025];

	mm = mm_create(1024*1024*8, NULL);
	mm_display_info(mm);
	for (i = 0; i < 1024; i++) {
		cp[i] = mm_malloc(mm, i*i);
		if (cp[i] != NULL)
		    memset(cp[i], 0xF5, i*i);
	}
	mm_display_info(mm);
	for (i = 0; i < 1024; i++) {
		if (i % 2 == 0)
			continue;
		mm_free(mm, cp[i]);
		cp[i] = NULL;
	}
	mm_display_info(mm);
	for (i = 0; i < 1024; i++) {
		mm_free(mm, cp[i]);
	}
	mm_display_info(mm);
	mm_destroy(mm);
	exit(0);

	fprintf(stderr, "mm_create(0, NULL);\n");
	if ((mm = mm_create(0, NULL)) == NULL) {
		perror("mm_create");
	    exit(1);
	}
	mm_display_info(mm);
	fprintf(stderr, "cp1 = mm_malloc(mm, 100);\n");
	if ((cp1 = mm_malloc(mm, 100)) == NULL) {
		perror("mm_malloc");
	    exit(1);
	}
	mm_display_info(mm);
	fprintf(stderr, "cp2 = mm_malloc(mm, 16384);\n");
	if ((cp2 = mm_malloc(mm, 16384)) == NULL) {
		perror("mm_malloc");
	    exit(1);
	}
	mm_display_info(mm);
	fprintf(stderr, "cp3 = mm_malloc(mm, 1);\n");
	if ((cp3 = mm_malloc(mm, 1)) == NULL) {
		perror("mm_malloc");
	    exit(1);
	}
	mm_display_info(mm);
	fprintf(stderr, "mm_free(mm, cp2);\n");
	mm_free(mm, cp2);
	mm_display_info(mm);
	fprintf(stderr, "mm_free(mm, cp3);\n");
	mm_free(mm, cp3);
	mm_display_info(mm);
	fprintf(stderr, "mm_free(mm, cp1);\n");
	mm_free(mm, cp1);
	mm_display_info(mm);
	mm_destroy(mm);
	exit(0);

    if ((core = mm_core_create(1024*16, NULL)) == NULL) {
        fprintf(stderr, "Failed to create memory\n");
        perror("create");
        exit(0);
    }
    s = mm_core_size(core);
    fprintf(stderr, "core size = %d\n", s);
    for (i = 0; i < s; i++) {
        core[i] = 0xF5;
    }
    for (i = 0; i < s; i++) {
        if (core[i] != (char)0xF5) {
            fprintf(stderr, "Offset %d: no 0xF5\n", i);
            exit(0);
        }
    }

    count = (int *)&core[1024];
    *count = 1;
    setbuf(stderr, NULL);
    if ((pid = fork()) == 0) {
        /* child */
        while (*count < 1024) {
			if (!mm_core_lock(core)) {
				fprintf(stderr, "locking failed (child)\n");
				perror("locking");
				exit(1);
			}
            fprintf(stderr, "count=%d (child)\n", *count);
            *count += 1;
			if (!mm_core_unlock(core)) {
				fprintf(stderr, "locking failed (child)\n");
				perror("unlocking");
				exit(1);
			}
        }
        exit(0);
    }
    /* parent ... */
    while (*count < 1024) {
        if (!mm_core_lock(core)) {
            fprintf(stderr, "locking failed (parent)\n");
			perror("locking");
			exit(1);
        }
        fprintf(stderr, "count=%d (parent)\n", *count);
        *count += 1;
        if (!mm_core_unlock(core)) {
            fprintf(stderr, "locking failed (parent)\n");
			perror("unlocking");
			exit(1);
        }
    }

    waitpid(pid, NULL, 0);
    mm_core_delete(core);
    fprintf(stderr, "OK\n");
    return 0;
}

