#!/bin/sh
##
##  mm_conf.sh -- Platform Configuration
##

v=`grep MM_VERSION_STR ./mm.h | sed -e 's;.*MM_VERSION_STR *";;' -e 's;".*;;'`
echo "Configuring for MM, Version $v"

platform=`sh ./mm_gos.sh`
echo " + platform: $platform"

#   MM library availability
MM_NA="undef "               # not available at all

#   How to find out the VM pagesize
MM_VMPS_GETPAGESIZE="undef " # getpagesize()
MM_VMPS_SYSCONF="undef "     # sysconf()

#   Shared Memory Type
MM_SHMT_MMANON="undef "      # mmap() with MAP_ANON   [4.4BSD]
MM_SHMT_MMPOSX="undef "      # mmap() with shm_open() [POSIX.1]
MM_SHMT_MMZERO="undef "      # mmap() with /dev/zero  [SVR4]
MM_SHMT_MMFILE="undef "      # mmap() with temp file  [Classical]
MM_SHMT_IPCSHM="undef "      # shmget()               [SYSV IPC]

#   Semaphore Type
MM_SEMT_FLOCK="undef "       # lock file + flock()    [4.4BSD]
MM_SEMT_FCNTL="undef "       # lock file + fnctl()    [SVR4]
MM_SEMT_IPCSEM="undef "      # semget()               [SYSV IPC]

case $platform in
    *-*-freebsd* ) 
        MM_OS="MM_OS_FreeBSD"
        MM_VMPS_GETPAGESIZE=define
        MM_SHMT_MMANON=define
        MM_SEMT_FCNTL=define 
        ;;
    *-*-netbsd* )
        MM_OS="MM_OS_NetBSD"
        MM_VMPS_GETPAGESIZE=define
        MM_SHMT_MMANON=define
        MM_SEMT_FCNTL=define 
        ;;
    *-*-openbsd* ) 
        MM_OS="MM_OS_OpenBSD" 
        MM_VMPS_GETPAGESIZE=define
        MM_SHMT_MMANON=define
        MM_SEMT_FCNTL=define 
        ;;
    *-*-linux* ) 
        MM_OS="MM_OS_Linux"
        MM_VMPS_GETPAGESIZE=define
        MM_SHMT_IPCSHM=define
        MM_SEMT_FCNTL=define 
        ;;
    *-*-sunos* ) 
        MM_OS="MM_OS_SunOS"
        MM_VMPS_GETPAGESIZE=define
        MM_SHMT_MMZERO=define
        MM_SEMT_FLOCK=define 
        ;;
    *-*-solaris* ) 
        MM_OS="MM_OS_Solaris" 
        MM_VMPS_SYSCONF=define    
        MM_SHMT_IPCSHM=define
        MM_SEMT_FCNTL=define 
        ;;
    *-*-irix* )
        MM_OS="MM_OS_Irix"
        MM_VMPS_SYSCONF=define
        MM_SHMT_IPCSHM=define
        MM_SEMT_FCNTL=define
        ;;
    * ) 
        MM_NA=define
        MM_OS="MM_OS_Unknown"  
        ;;           
esac

vmps_type="N/A"
if [ .$MM_VMPS_GETPAGESIZE = .define ]; then
    vmps_type="BSD getpagesize()"
elif [ .$MM_VMPS_SYSCONF = .define ]; then
    vmps_type="SysV sysconf()"
fi
shm_type="N/A"
if [ .$MM_SHMT_MMANON = .define ]; then
    shm_type="4.4BSD anonymous memory-mapping"
elif [ .$MM_SHMT_MMPOSX = .define ]; then
    shm_type="POSIX.1 shared memory-mapping"
elif [ .$MM_SHMT_MMZERO = .define ]; then
    shm_type="Nifty memory-mapping of /dev/zero"
elif [ .$MM_SHMT_MMFILE = .define ]; then
    shm_type="Classical memory-mapping of temporary file"
elif [ .$MM_SHMT_IPCSHM = .define ]; then
    shm_type="SysV IPC Shared Memory"
fi
sem_type="N/A"
if [ .$MM_SEMT_FLOCK = .define ]; then
    sem_type="BSD flock()"
elif [ .$MM_SEMT_FCNTL = .define ]; then
    sem_type="POSIX fcntl()"
elif [ .$MM_SEMT_IPCSEM = .define ]; then
    sem_type="SysV IPC Semaphore"
fi

na=1
if [ ".vmps_type" != ".N/A" ]; then
    if [ ".shm_type" != ".N/A" ]; then
        if [ ".sem_type" != ".N/A" ]; then
            na=0
        fi
    fi
fi
if [ ".$na" = .1 ]; then
    echo " + !FUNCTIONALITY NOT AVAILABLE!"
else
    echo " + pagesize: $vmps_type"
    echo " + memory  : $shm_type"
    echo " + mutex   : $sem_type"
fi

header="mm_conf.h"
echo "/*" > $header
echo "**  $header" >> $header
echo "*/" >> $header
echo "" >> $header
echo "#ifndef MM_CONF_HH" >> $header
echo "#define MM_CONF_HH" >> $header
echo "" >> $header
echo "/* Availability */" >> $header
echo "#$MM_NA MM_NA" >> $header
echo "" >> $header
echo "/* Operating System */" >> $header
echo "#define $MM_OS" >> $header
echo "" >> $header
echo "/* VM Page Size Determination */" >> $header
echo "#$MM_VMPS_GETPAGESIZE MM_VMPS_GETPAGESIZE" >> $header
echo "#$MM_VMPS_SYSCONF MM_VMPS_SYSCONF" >> $header
echo "" >> $header
echo "/* Shared Memory Type */" >> $header
echo "#$MM_SHMT_MMANON MM_SHMT_MMANON" >> $header
echo "#$MM_SHMT_MMPOSX MM_SHMT_MMPOSX" >> $header
echo "#$MM_SHMT_MMZERO MM_SHMT_MMZERO" >> $header
echo "#$MM_SHMT_MMFILE MM_SHMT_MMFILE" >> $header
echo "#$MM_SHMT_IPCSHM MM_SHMT_IPCSHM" >> $header
echo "" >> $header
echo "/* Semaphore Type */" >> $header
echo "#$MM_SEMT_FLOCK MM_SEMT_FLOCK" >> $header
echo "#$MM_SEMT_FCNTL MM_SEMT_FCNTL" >> $header
echo "#$MM_SEMT_IPCSEM MM_SEMT_IPCSEM" >> $header
echo "" >> $header
echo "#endif /* MM_CONF_HH */" >> $header

