/*
**  OSSP fsl - Faking/Flexible Syslog Library
**  Copyright (c) 2002-2003 Ralf S. Engelschall <rse@engelschall.com>
**  Copyright (c) 2002-2003 The OSSP Project <http://www.ossp.org/>
**  Copyright (c) 2002-2003 Cable & Wireless Deutschland <http://www.cw.com/de/>
**
**  This file is part of OSSP fsl, a syslog(3) API faking library which
**  can be found at http://www.ossp.org/pkg/lib/fsl/.
**
**  Permission to use, copy, modify, and distribute this software for
**  any purpose with or without fee is hereby granted, provided that
**  the above copyright notice and this permission notice appear in all
**  copies.
**
**  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
**  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
**  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
**  IN NO EVENT SHALL THE AUTHORS AND COPYRIGHT HOLDERS AND THEIR
**  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
**  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
**  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
**  USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
**  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
**  OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
**  OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
**  SUCH DAMAGE.
**
**  fsltool.c: OSSP fsl tool
*/

#include <stdio.h>
#include <syslog.h>

int main(int argc, char *argv[])
{
    syslog(LOG_INFO, "Connection from host %s", "foo.bar.dom");
    openlog("mail", LOG_PID|LOG_NDELAY, LOG_LOCAL0);
    syslog(LOG_ALERT, "who: internal error 23\n");
    setlogmask(LOG_UPTO(LOG_ERR));
    syslog(LOG_INFO|LOG_LOCAL2, "foobar error: %m");
    syslog(LOG_EMERG,   "syslogging LOG_EMERG   %d", LOG_EMERG  );
    syslog(LOG_ALERT,   "syslogging LOG_ALERT   %d", LOG_ALERT  );
    syslog(LOG_CRIT,    "syslogging LOG_CRIT    %d", LOG_CRIT   );
    syslog(LOG_ERR,     "syslogging LOG_ERR     %d", LOG_ERR    );
    syslog(LOG_WARNING, "syslogging LOG_WARNING %d", LOG_WARNING);
    syslog(LOG_NOTICE,  "syslogging LOG_NOTICE  %d", LOG_NOTICE );
    syslog(LOG_INFO,    "syslogging LOG_INFO    %d", LOG_INFO   );
    syslog(LOG_DEBUG,   "syslogging LOG_DEBUG   %d", LOG_DEBUG  );
    closelog();
    return 0;

    /* minimal command line parsing */
    if (argc != 2) {
        fprintf(stderr, "fsltool:ERROR: invalid command line\n");
        fprintf(stderr, "fsltool:USAGE: fsltool <specification>\n");
        exit(1);
    }


-s -p -m     void syslog(int priority, const char *message, ...); #calls vsyslog()
-o -i -l -f  void openlog(const char *ident, int logopt, int facility);
-c           void closelog(void);
-m           int setlogmask(int maskpri);

/* priority */
#define	LOG_EMERG	0	/* system is unusable */
#define	LOG_ALERT	1	/* action must be taken immediately */
#define	LOG_CRIT	2	/* critical conditions */
#define	LOG_ERR		3	/* error conditions */
#define	LOG_WARNING	4	/* warning conditions */
#define	LOG_NOTICE	5	/* normal but significant condition */
#define	LOG_INFO	6	/* informational */
#define	LOG_DEBUG	7	/* debug-level messages */

/* message */
/* args */
/* ident */
#define mai const char

/* logopt */
#define	LOG_PID		0x01	/* log the pid with each message */
#define	LOG_CONS	0x02	/* log on the console if errors in sending */
#define	LOG_ODELAY	0x04	/* delay open until first syslog() (default) */
#define	LOG_NDELAY	0x08	/* don't delay open */
#define	LOG_NOWAIT	0x10	/* don't wait for console forks: DEPRECATED */
#define	LOG_PERROR	0x20	/* log to stderr as well */

/* facility */
/* mapping table for syslog(3) facilities to strings */
static struct {
    int facility;
    char *string;
} syslogfacility2string[] = {
    { LOG_AUTH,     "auth"     },
#ifdef LOG_AUTHPRIV
    { LOG_AUTHPRIV, "authpriv" },
#endif
#ifdef LOG_CONSOLE
    { LOG_CONSOLE,  "console"  },
#endif
    { LOG_CRON,     "cron"     },
    { LOG_DAEMON,   "daemon"   },
#ifdef LOG_FTP
    { LOG_FTP,      "ftp"      },
#endif
    { LOG_KERN,     "kern"     },
    { LOG_LOCAL0,   "local0"   },
    { LOG_LOCAL1,   "local1"   },
    { LOG_LOCAL2,   "local2"   },
    { LOG_LOCAL3,   "local3"   },
    { LOG_LOCAL4,   "local4"   },
    { LOG_LOCAL5,   "local5"   },
    { LOG_LOCAL6,   "local6"   },
    { LOG_LOCAL7,   "local7"   },
    { LOG_LPR,      "lpr"      },
    { LOG_MAIL,     "mail"     },
    { LOG_NEWS,     "news"     },
#ifdef LOG_NTP
    { LOG_NTP,      "ntp"      },
#endif
#ifdef LOG_SECURITY
    { LOG_SECURITY, "security" },
#endif
    { LOG_SYSLOG,   "syslog"   },
    { LOG_USER,     "user"     },
    { LOG_UUCP,     "uucp"     },
    { -1,            NULL      }
};

#define	LOG_PRIMASK	0x07	/* mask to extract priority part (internal) */
#define	LOG_PRI(p)	((p) & LOG_PRIMASK)
#define	LOG_MAKEPRI(fac, pri)	((fac) | (pri))
#ifdef SYSLOG_NAMES
#define	INTERNAL_MARK	LOG_MAKEPRI((LOG_NFACILITIES<<3), 0)
	{ "alert",	LOG_ALERT,	},
	{ "crit",	LOG_CRIT,	},
	{ "debug",	LOG_DEBUG,	},
	{ "emerg",	LOG_EMERG,	},
	{ "err",	LOG_ERR,	},
	{ "error",	LOG_ERR,	},	/* DEPRECATED */
	{ "info",	LOG_INFO,	},
	{ "notice",	LOG_NOTICE,	},
	{ "panic", 	LOG_EMERG,	},	/* DEPRECATED */
	{ "warn",	LOG_WARNING,	},	/* DEPRECATED */
	{ "warning",	LOG_WARNING,	},

#define	LOG_MASK(pri)	(1 << (pri))		/* mask for one priority */
#define	LOG_UPTO(pri)	((1 << ((pri)+1)) - 1)	/* all priorities through pri */
 * LOG_ODELAY no longer does anything.
 * LOG_NDELAY is the inverse of what it used to be.
#define	LOG_PID		0x01	/* log the pid with each message */
#define	LOG_CONS	0x02	/* log on the console if errors in sending */
#define	LOG_ODELAY	0x04	/* delay open until first syslog() (default) */
#define	LOG_NDELAY	0x08	/* don't delay open */
#define	LOG_NOWAIT	0x10	/* don't wait for console forks: DEPRECATED */
#define	LOG_PERROR	0x20	/* log to stderr as well */
}








