/*
 *  Perl Compatible Regular Expression (PCRE) Library
 *  Copyright (c) 1997-2001 Philip Hazel <ph10@cam.ac.uk>
 *  Copyright (c) 1997-2001 University of Cambridge
 *
 *  DO NOT EDIT THIS FILE, IT WAS AUTOMATICALLY GENERATED!
 *
 *  This is an automatically generated, extremely stripped down
 *  version of the PCRE 3.9 library from the Philip Hazel.
 *  This version is still distributed under the same original PCRE
 *  Open Source license, but Philip Hazel is no longer responsible
 *  for this version.
 */

/*
This is a library of functions to support regular expressions whose syntax
and semantics are as close as possible to those of the Perl 5 language. See
the file Tech.Notes for some information on the internals.

Written by: Philip Hazel <ph10@cam.ac.uk>

           Copyright (c) 1997-2001 University of Cambridge

-----------------------------------------------------------------------------
Permission is granted to anyone to use this software for any purpose on any
computer system, and to redistribute it freely, subject to the following
restrictions:

1. This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

2. The origin of this software must not be misrepresented, either by
   explicit claim or by omission.

3. Altered versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

4. If PCRE is embedded in any software that is released under the GNU
   General Purpose Licence (GPL), then the terms of that licence shall
   supersede any condition above with which it is incompatible.
-----------------------------------------------------------------------------
*/

#ifndef __L2_UT_PCRE_H__
#define __L2_UT_PCRE_H__

#define PCRE_PREFIX l2_util_

#define PCRE_MAJOR          3
#define PCRE_MINOR          9
#define PCRE_DATE           02-Jan-2002

#ifdef PCRE_PREFIX
#if defined(__STDC__) || defined(__cplusplus)
#define __PCRE_CONCAT(x,y) x ## y
#define PCRE_CONCAT(x,y) __PCRE_CONCAT(x,y)
#else
#define __PCRE_CONCAT(x) x
#define PCRE_CONCAT(x,y) __PCRE_CONCAT(x)y
#endif
#define pcre_malloc PCRE_CONCAT(PCRE_PREFIX,pcre_malloc)
#define pcre_free PCRE_CONCAT(PCRE_PREFIX,pcre_free)
#define pcre_compile PCRE_CONCAT(PCRE_PREFIX,pcre_compile)
#define pcre_copy_substring PCRE_CONCAT(PCRE_PREFIX,pcre_copy_substring)
#define pcre_exec PCRE_CONCAT(PCRE_PREFIX,pcre_exec)
#define pcre_free_substring PCRE_CONCAT(PCRE_PREFIX,pcre_free_substring)
#define pcre_free_substring_list PCRE_CONCAT(PCRE_PREFIX,pcre_free_substring_list)
#define pcre_get_substring PCRE_CONCAT(PCRE_PREFIX,pcre_get_substring)
#define pcre_get_substring_list PCRE_CONCAT(PCRE_PREFIX,pcre_get_substring_list)
#define pcre_info PCRE_CONCAT(PCRE_PREFIX,pcre_info)
#define pcre_fullinfo PCRE_CONCAT(PCRE_PREFIX,pcre_fullinfo)
#define pcre_maketables PCRE_CONCAT(PCRE_PREFIX,pcre_maketables)
#define pcre_study PCRE_CONCAT(PCRE_PREFIX,pcre_study)
#define pcre_version PCRE_CONCAT(PCRE_PREFIX,pcre_version)
#endif

#include <stdlib.h>

#ifdef __cplusplus
extern "C" {
#endif

#define PCRE_CASELESS        0x0001
#define PCRE_MULTILINE       0x0002
#define PCRE_DOTALL          0x0004
#define PCRE_EXTENDED        0x0008
#define PCRE_ANCHORED        0x0010
#define PCRE_DOLLAR_ENDONLY  0x0020
#define PCRE_EXTRA           0x0040
#define PCRE_NOTBOL          0x0080
#define PCRE_NOTEOL          0x0100
#define PCRE_UNGREEDY        0x0200
#define PCRE_NOTEMPTY        0x0400
#define PCRE_UTF8            0x0800

#define PCRE_ERROR_NOMATCH        (-1)
#define PCRE_ERROR_NULL           (-2)
#define PCRE_ERROR_BADOPTION      (-3)
#define PCRE_ERROR_BADMAGIC       (-4)
#define PCRE_ERROR_UNKNOWN_NODE   (-5)
#define PCRE_ERROR_NOMEMORY       (-6)
#define PCRE_ERROR_NOSUBSTRING    (-7)

#define PCRE_INFO_OPTIONS         0
#define PCRE_INFO_SIZE            1
#define PCRE_INFO_CAPTURECOUNT    2
#define PCRE_INFO_BACKREFMAX      3
#define PCRE_INFO_FIRSTCHAR       4
#define PCRE_INFO_FIRSTTABLE      5
#define PCRE_INFO_LASTLITERAL     6

struct pcre_st;
struct pcre_extra_st;

typedef struct pcre_st pcre;
typedef struct pcre_extra_st pcre_extra;

extern void *(*pcre_malloc)(size_t);
extern void  (*pcre_free)(void *);

extern pcre *pcre_compile(const char *, int, const char **, int *,
              const unsigned char *);
extern int  pcre_copy_substring(const char *, int *, int, int, char *, int);
extern int  pcre_exec(const pcre *, const pcre_extra *, const char *,
              int, int, int, int *, int);
extern void pcre_free_substring(const char *);
extern void pcre_free_substring_list(const char **);
extern int  pcre_get_substring(const char *, int *, int, int, const char **);
extern int  pcre_get_substring_list(const char *, int *, int, const char ***);
extern int  pcre_info(const pcre *, int *, int *);
extern int  pcre_fullinfo(const pcre *, const pcre_extra *, int, void *);
extern const unsigned char *pcre_maketables(void);
extern pcre_extra *pcre_study(const pcre *, int, const char **);
extern const char *pcre_version(void);

#ifdef __cplusplus
}
#endif

#endif
