
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "cfg.h"
#include "cfg_util.h"

int main(int argc, char *argv[]) 
{
    cfg_rc_t rc;
    char *im_ptr;
    size_t im_size;
    char *ex_ptr;
    char *error;
    cfg_t *cfg;
    cfg_node_t **vec;
    cfg_node_t *n;
    int i;

    if (argc < 2 || argc > 3) {
        fprintf(stderr, "USAGE: %s <file> [<select>]\n", argv[0]);
        exit(1);
    }

    if ((rc = cfg_util_readfile(argv[1], &im_ptr, &im_size)) != CFG_OK) {
        fprintf(stderr, "ERROR: reading file \"%s\"\n", argv[1]);
        exit(1);
    }

    if ((rc = cfg_create(&cfg)) != CFG_OK) {
        cfg_error(cfg, rc, &error);
        fprintf(stderr, "ERROR: cfg_create: %s\n", error);
        free(im_ptr);
        exit(1);
    }

    if ((rc = cfg_import(cfg, NULL, CFG_FMT_CFG, im_ptr, im_size)) != CFG_OK) {
        cfg_error(cfg, rc, &error);
        fprintf(stderr, "ERROR: cfg_import: %s\n", error);
        free(im_ptr);
        cfg_destroy(cfg);
        exit(1);
    }

    if ((rc = cfg_export(cfg, NULL, CFG_FMT_CFG, &ex_ptr, 0)) != CFG_OK) {
        cfg_error(cfg, rc, &error);
        fprintf(stderr, "ERROR: cfg_export: %s\n", error);
        free(im_ptr);
        cfg_destroy(cfg);
        exit(1);
    }

    fprintf(stdout, "%s", ex_ptr);
    fflush(stdout);

    if (argc == 3) {
        if ((rc = cfg_node_select(cfg, NULL, &vec, "%s", argv[2])) != CFG_OK) {
            cfg_error(cfg, rc, &error);
            fprintf(stderr, "ERROR: cfg_node_select: %s\n", error);
            free(im_ptr);
            //cfg_destroy(cfg);
            exit(1);
        }
        for (i = 1; vec[i] != NULL; i++) {
            fprintf(stdout, "---- selection #%d ----\n", i);
            if ((rc = cfg_export(cfg, vec[i], CFG_FMT_CFG, &ex_ptr, 0)) != CFG_OK) {
                cfg_error(cfg, rc, &error);
                fprintf(stderr, "ERROR: cfg_export: %s\n", error);
                free(im_ptr);
                //cfg_destroy(cfg);
                exit(1);
            }
            fprintf(stdout, "%s", ex_ptr);
            fprintf(stdout, "---- selection #%d ----\n", i);
        }
    }

#if 0
    cfg_syn_destroy(cfg, node);
    cfg_destroy(cfg);
#endif

    return 0;
}

