/*
 * Decompiled with CFR 0.152.
 */
package org.sablecc.sablecc;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import org.sablecc.sablecc.GenAlts;
import org.sablecc.sablecc.MacroExpander;
import org.sablecc.sablecc.ResolveAstIds;
import org.sablecc.sablecc.analysis.DepthFirstAdapter;
import org.sablecc.sablecc.node.AAstProd;
import org.sablecc.sablecc.node.Start;

public class GenUtils
extends DepthFirstAdapter {
    private MacroExpander macros;
    private ResolveAstIds ast_ids;
    private File pkgDir;
    private String pkgName;
    private String mainProduction;

    public GenUtils(ResolveAstIds ast_ids) {
        this.ast_ids = ast_ids;
        try {
            this.macros = new MacroExpander(new InputStreamReader(this.getClass().getResourceAsStream("utils.txt")));
        }
        catch (IOException e) {
            throw new RuntimeException("unable to open utils.txt.");
        }
        this.pkgDir = new File(ast_ids.astIds.pkgDir, "node");
        String string = this.pkgName = ast_ids.astIds.pkgName.equals("") ? "node" : ast_ids.astIds.pkgName + ".node";
        if (!this.pkgDir.exists() && !this.pkgDir.mkdir()) {
            throw new RuntimeException("Unable to create " + this.pkgDir.getAbsolutePath());
        }
    }

    @Override
    public void caseAAstProd(AAstProd node) {
        if (this.mainProduction == null) {
            this.mainProduction = (String)this.ast_ids.ast_names.get(node);
        }
    }

    @Override
    public void outStart(Start node) {
        if (this.mainProduction != null) {
            this.createStart();
        }
        this.createEOF();
        this.createInvalidToken();
        this.createNode();
        this.createToken();
        this.create("Switch");
        this.create("Switchable");
    }

    public void createStart() {
        BufferedWriter file;
        try {
            file = new BufferedWriter(new FileWriter(new File(this.pkgDir, "Start.java")));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create " + new File(this.pkgDir, "Start.java").getAbsolutePath());
        }
        try {
            this.macros.apply(file, "Start", new String[]{this.pkgName, this.ast_ids.astIds.pkgName.equals("") ? "analysis" : this.ast_ids.astIds.pkgName + ".analysis", this.mainProduction, GenAlts.nodeName(this.mainProduction)});
        }
        catch (IOException e) {
            throw new RuntimeException("An error occured while writing to " + new File(this.pkgDir, "Start.java").getAbsolutePath());
        }
        try {
            file.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void createEOF() {
        BufferedWriter file;
        try {
            file = new BufferedWriter(new FileWriter(new File(this.pkgDir, "EOF.java")));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create " + new File(this.pkgDir, "EOF.java").getAbsolutePath());
        }
        try {
            this.macros.apply(file, "EOF", new String[]{this.pkgName, this.ast_ids.astIds.pkgName.equals("") ? "analysis" : this.ast_ids.astIds.pkgName + ".analysis"});
        }
        catch (IOException e) {
            throw new RuntimeException("An error occured while writing to " + new File(this.pkgDir, "EOF.java").getAbsolutePath());
        }
        try {
            file.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void createInvalidToken() {
        BufferedWriter file;
        try {
            file = new BufferedWriter(new FileWriter(new File(this.pkgDir, "InvalidToken.java")));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create " + new File(this.pkgDir, "InvalidToken.java").getAbsolutePath());
        }
        try {
            this.macros.apply(file, "InvalidToken", new String[]{this.pkgName, this.ast_ids.astIds.pkgName.equals("") ? "analysis" : this.ast_ids.astIds.pkgName + ".analysis"});
        }
        catch (IOException e) {
            throw new RuntimeException("An error occured while writing to " + new File(this.pkgDir, "InvalidToken.java").getAbsolutePath());
        }
        try {
            file.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void createNode() {
        BufferedWriter file;
        try {
            file = new BufferedWriter(new FileWriter(new File(this.pkgDir, "Node.java")));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create " + new File(this.pkgDir, "Node.java").getAbsolutePath());
        }
        try {
            this.macros.apply(file, "Node", new String[]{this.pkgName, this.ast_ids.astIds.pkgName.equals("") ? "analysis" : this.ast_ids.astIds.pkgName + ".analysis"});
        }
        catch (IOException e) {
            throw new RuntimeException("An error occured while writing to " + new File(this.pkgDir, "Node.java").getAbsolutePath());
        }
        try {
            file.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void createToken() {
        BufferedWriter file;
        try {
            file = new BufferedWriter(new FileWriter(new File(this.pkgDir, "Token.java")));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create " + new File(this.pkgDir, "Token.java").getAbsolutePath());
        }
        try {
            this.macros.apply(file, "Token", new String[]{this.pkgName});
        }
        catch (IOException e) {
            throw new RuntimeException("An error occured while writing to " + new File(this.pkgDir, "Token.java").getAbsolutePath());
        }
        try {
            file.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void create(String cls) {
        BufferedWriter file;
        try {
            file = new BufferedWriter(new FileWriter(new File(this.pkgDir, cls + ".java")));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create " + new File(this.pkgDir, cls + ".java").getAbsolutePath());
        }
        try {
            this.macros.apply(file, cls, new String[]{this.pkgName});
        }
        catch (IOException e) {
            throw new RuntimeException("An error occured while writing to " + new File(this.pkgDir, cls + ".java").getAbsolutePath());
        }
        try {
            file.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

