/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesAndCommentsBinder;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.parsing.JavaScriptParser;
import com.intellij.openapi.util.Key;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.PropertyKey;

public class JavaScriptParserBase<T extends JavaScriptParser> {
    public static final Key<JSLanguageDialect> JS_DIALECT_KEY = Key.create((String)"JS_DIALECT");
    public static final Key<Boolean> JS_TYPE_USAGE_KEY = Key.create((String)"JS_TYPE_USAGE_KEY");
    public static final Key<ForceContext> FORCE_CONTEXT_KEY = Key.create((String)"FORCE_CONTEXT");
    public static int MAX_TREE_DEPTH = 100;
    protected final PsiBuilder builder;
    protected final T myJavaScriptParser;
    protected static final WhitespacesAndCommentsBinder INCLUDE_DOC_COMMENT_AT_LEFT = new WhitespacesAndCommentsBinder(){

        public int getEdgePosition(List<IElementType> tokens, boolean atStreamEdge, WhitespacesAndCommentsBinder.TokenTextGetter getter) {
            IElementType type;
            int i = tokens.size() - 1;
            IElementType iElementType = type = i >= 0 ? tokens.get(i) : null;
            while (type == JSTokenTypes.WHITE_SPACE || type == JSTokenTypes.END_OF_LINE_COMMENT) {
                type = --i >= 0 ? tokens.get(i) : null;
            }
            if (type == JSTokenTypes.DOC_COMMENT) {
                return i;
            }
            return tokens.size();
        }
    };

    protected JavaScriptParserBase(T parser) {
        this.builder = ((JavaScriptParser)parser).builder;
        this.myJavaScriptParser = parser;
    }

    public static boolean hasSemanticLinefeedBefore(PsiBuilder builder) {
        IElementType tokenType = builder.getTokenType();
        if (tokenType == null || tokenType == JSTokenTypes.RBRACE || tokenType == JSTokenTypes.OR_RBRACE) {
            return true;
        }
        if (tokenType == JSTokenTypes.ELSE_KEYWORD || tokenType == JSTokenTypes.WHILE_KEYWORD) {
            return true;
        }
        return JavaScriptParserBase.hasSemanticLinefeed(builder, true);
    }

    public static boolean hasSemanticLinefeedAfter(PsiBuilder builder) {
        return JavaScriptParserBase.hasSemanticLinefeed(builder, false);
    }

    private static boolean hasSemanticLinefeed(PsiBuilder builder, boolean isBefore) {
        int at = isBefore ? -1 : 1;
        IElementType boundElementType = builder.rawLookup(at);
        while (boundElementType == JSTokenTypes.WHITE_SPACE || boundElementType == JSTokenTypes.HEREDOC_BOUND || JSTokenTypes.COMMENTS.contains(boundElementType)) {
            int end = builder.rawTokenTypeStart(at + 1);
            CharSequence sequence = builder.getOriginalText();
            for (int start = builder.rawTokenTypeStart(at); start < end; ++start) {
                char ch = sequence.charAt(start);
                if (ch != '\n' && ch != '\u2028' && ch != '\u2029' && ch != '\r') continue;
                return true;
            }
            at = isBefore ? --at : ++at;
            boundElementType = builder.rawLookup(at);
        }
        return false;
    }

    protected static boolean checkMatches(PsiBuilder builder, IElementType token, @NonNls @PropertyKey(resourceBundle="messages.JavaScriptBundle") String errorMessageKey) {
        if (builder.getTokenType() == token) {
            builder.advanceLexer();
            return true;
        }
        builder.error(JSBundle.message((String)errorMessageKey, (Object[])new Object[0]));
        return false;
    }

    protected boolean isECMAL4() {
        return this.builder.getUserData(JS_DIALECT_KEY) == JavaScriptSupportLoader.ECMA_SCRIPT_L4;
    }

    protected boolean isGwt() {
        return this.builder.getUserData(JS_DIALECT_KEY) == JavaScriptSupportLoader.GWT_DIALECT;
    }

    protected boolean isECMA6() {
        JSLanguageDialect dialect = (JSLanguageDialect)((Object)this.builder.getUserData(JS_DIALECT_KEY));
        return dialect != null && dialect.getOptionHolder().isECMA6;
    }

    protected boolean isJavaScript() {
        JSLanguageDialect dialect = (JSLanguageDialect)((Object)this.builder.getUserData(JS_DIALECT_KEY));
        return dialect == null || dialect.getOptionHolder().isJavaScript();
    }

    protected boolean isJSorTS() {
        JSLanguageDialect dialect = (JSLanguageDialect)((Object)this.builder.getUserData(JS_DIALECT_KEY));
        return dialect == null || dialect.getOptionHolder().isJavaScript() || dialect.getOptionHolder().isTypeScript;
    }

    @NotNull
    protected DialectOptionHolder getOptionHolder(@NotNull DialectOptionHolder defaultValue) {
        JSLanguageDialect dialect;
        if (defaultValue == null) {
            JavaScriptParserBase.$$$reportNull$$$0(0);
        }
        DialectOptionHolder dialectOptionHolder = (dialect = (JSLanguageDialect)((Object)this.builder.getUserData(JS_DIALECT_KEY))) != null ? dialect.getOptionHolder() : defaultValue;
        if (dialectOptionHolder == null) {
            JavaScriptParserBase.$$$reportNull$$$0(1);
        }
        return dialectOptionHolder;
    }

    protected boolean isIdentifierToken(IElementType tokenType) {
        if (tokenType == JSTokenTypes.IDENTIFIER) {
            return true;
        }
        return ((JavaScriptParser)this.myJavaScriptParser).isIdentifierToken(tokenType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/parsing/JavaScriptParserBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/parsing/JavaScriptParserBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionHolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOptionHolder";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum ForceContext {
        Type,
        TypeAllowEmpty,
        Parameter;

    }
}

