/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter.blocks.alignment;

import com.intellij.formatting.Alignment;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.formatter.blocks.alignment.ASTNodeBasedAlignmentFactory;
import com.intellij.lang.javascript.formatter.blocks.alignment.JSVarStatementAlignmentFactory;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class ES6ImportAlignmentFactory
implements ASTNodeBasedAlignmentFactory {
    private final JSCodeStyleSettings myJSCodeStyleSettings;
    private Alignment myAlignment;

    public ES6ImportAlignmentFactory(JSCodeStyleSettings jsCodeStyleSettings) {
        this.myJSCodeStyleSettings = jsCodeStyleSettings;
        this.resetAlignment();
    }

    @Override
    public Alignment getAlignment(@NotNull ASTNode child) {
        if (child == null) {
            ES6ImportAlignmentFactory.$$$reportNull$$$0(0);
        }
        IElementType childType = child.getElementType();
        if (this.myJSCodeStyleSettings.ALIGN_IMPORTS && childType == ES6ElementTypes.FROM_CLAUSE) {
            if (ES6ImportAlignmentFactory.shouldRestartAlignment(child.getTreeParent())) {
                this.resetAlignment();
            }
            return this.myAlignment;
        }
        return null;
    }

    private static boolean shouldRestartAlignment(@NotNull ASTNode statement) {
        if (statement == null) {
            ES6ImportAlignmentFactory.$$$reportNull$$$0(1);
        }
        return JSVarStatementAlignmentFactory.getPreviousSiblingIfClose(statement) == null;
    }

    private void resetAlignment() {
        this.myAlignment = Alignment.createAlignment((boolean)true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/formatter/blocks/alignment/ES6ImportAlignmentFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getAlignment";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldRestartAlignment";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

