/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.names.JSNameSuggestionsUtil;
import com.intellij.lang.javascript.names.JSNamedEntityKind;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.stubs.JSGlobalSymbolIndex;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.settings.JSApplicationSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class JSVariableNameCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        PsiElement position;
        if (parameters == null) {
            JSVariableNameCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            JSVariableNameCompletionContributor.$$$reportNull$$$0(1);
        }
        if (!((position = parameters.getPosition()) instanceof LeafPsiElement) || ((LeafPsiElement)position).getElementType() != JSTokenTypes.IDENTIFIER) {
            return;
        }
        PsiElement parent = position.getParent();
        if (parent instanceof JSField || !(parent instanceof JSVariable) || ((JSVariable)parent).getNameIdentifier() != position || JSDestructuringUtil.isDestructuring(parent.getParent())) {
            return;
        }
        PsiElement typeElement = ((JSVariable)parent).getTypeElement();
        if (typeElement != null) {
            if (typeElement instanceof JSTypeDeclaration) {
                JSType type = TypeScriptTypeParser.buildTypeFromTypeScript((JSTypeDeclaration)typeElement);
                JSVariableNameCompletionContributor.addAllNamesForType(result2, type, parent);
            }
            return;
        }
        JSExpression initializer = ((JSVariable)parent).getInitializerOrStub();
        if (initializer != null) {
            for (String name : JSNameSuggestionsUtil.generateVariableNamesFromExpression(initializer, parent, "", ContainerUtil.emptyList(), JSNamedEntityKind.Variable)) {
                result2.addElement((LookupElement)LookupElementBuilder.create((String)name));
            }
            return;
        }
        JSType type = JSTypeUtils.getTypeOfElement(parent);
        if (type != null) {
            JSVariableNameCompletionContributor.addAllNamesForType(result2, type, parent);
            return;
        }
        if (!JSApplicationSettings.getInstance().isUseVarNamesCompletion()) {
            return;
        }
        Project project = parameters.getOriginalFile().getProject();
        Collection keys = StubIndex.getInstance().getAllKeys(JSGlobalSymbolIndex.KEY, project);
        for (String key : keys) {
            if (!StringUtil.isCapitalized((String)key) || StringUtil.isUpperCase((CharSequence)key) || StringUtil.containsChar((String)key, (char)'_')) continue;
            for (String variant : NameUtil.getSuggestionsByName((String)JSVariableNameCompletionContributor.normalizeVariableName(key), (String)"", (String)"", (boolean)false, (boolean)false, (boolean)false)) {
                if (!JSRefactoringUtil.isValidIdentifier(variant, project)) continue;
                result2.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)variant).withAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE), (double)-1.0));
            }
        }
    }

    @NotNull
    private static String normalizeVariableName(@NotNull String key) {
        String decapitalized;
        if (key == null) {
            JSVariableNameCompletionContributor.$$$reportNull$$$0(2);
        }
        if (!Character.isUpperCase((decapitalized = StringUtil.decapitalize((String)key)).charAt(0))) {
            String string = decapitalized;
            if (string == null) {
                JSVariableNameCompletionContributor.$$$reportNull$$$0(3);
            }
            return string;
        }
        StringBuilder builder = new StringBuilder();
        boolean lowerCase = true;
        for (int i = 0; i < decapitalized.length(); ++i) {
            char ch = decapitalized.charAt(i);
            if (lowerCase && !Character.isUpperCase(ch)) {
                builder.replace(i - 1, i, String.valueOf(Character.toUpperCase(builder.charAt(i - 1))));
                lowerCase = false;
            }
            builder.append(lowerCase ? Character.toLowerCase(ch) : ch);
        }
        String string = builder.toString();
        if (string == null) {
            JSVariableNameCompletionContributor.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static void addAllNamesForType(@NotNull CompletionResultSet result2, JSType type, PsiElement parent) {
        if (result2 == null) {
            JSVariableNameCompletionContributor.$$$reportNull$$$0(5);
        }
        for (String name : JSNameSuggestionsUtil.generateVariableNamesFromType(type, parent, ContainerUtil.emptyList())) {
            result2.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)name).withAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE), (double)-1.0));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/completion/JSVariableNameCompletionContributor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/completion/JSVariableNameCompletionContributor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeVariableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fillCompletionVariants";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "normalizeVariableName";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addAllNamesForType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

