/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.cucumber.ruby.steps;

import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.psi.i18n.JsonGherkinKeywordProvider;
import org.jetbrains.plugins.cucumber.steps.AbstractStepDefinition;
import org.jetbrains.plugins.ruby.cucumber.CucumberUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactory;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RRegexpLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgument;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RBlockArgumentList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RListOfExpressions;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;

public class RubyStepDefinition
extends AbstractStepDefinition {
    private Ref<String> myPattern;

    public RubyStepDefinition(PsiElement element) {
        super(element);
    }

    public List<String> getVariableNames() {
        RCodeBlock block;
        RBlockArgumentList blockVars;
        PsiElement definitionElement = this.getElement();
        if (definitionElement != null && definitionElement.getParent() instanceof RBlockCall && (blockVars = (block = ((RBlockCall)definitionElement.getParent()).getBlock()).getBlockArguments()) != null) {
            ArrayList<String> result = new ArrayList<String>();
            for (RArgument identifier : blockVars.getArguments()) {
                result.add(identifier.getName());
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Nullable
    protected String getCucumberRegexFromElement(PsiElement element) {
        if (this.myPattern == null) {
            RCall call = CucumberUtil.getStepCall(element);
            if (call == null) {
                return null;
            }
            String result = null;
            String command = call.getCommand();
            if (JsonGherkinKeywordProvider.getKeywordProvider().isStepKeyword(command)) {
                result = RubyStepDefinition.getStepPattern(call);
            }
            this.myPattern = new Ref((Object)result);
        }
        return (String)this.myPattern.get();
    }

    @Nullable
    private static String getStepPattern(@NotNull RCall call) {
        List args;
        if (call == null) {
            RubyStepDefinition.$$$reportNull$$$0(0);
        }
        if ((args = (List)call.getData(new RubyCallType[0])).size() == 0) {
            return null;
        }
        String result = (String)args.get(0);
        if (CucumberUtil.isCucumberExpressionEnabled((PsiElement)call) && result != null) {
            result = CucumberUtil.processCucumberExpressions(result, call.getProject());
        }
        return result;
    }

    public void setCucumberRegex(@NotNull String newValue) {
        RCall call;
        if (newValue == null) {
            RubyStepDefinition.$$$reportNull$$$0(1);
        }
        if ((call = CucumberUtil.getStepCall(this.getElement())) != null) {
            RListOfExpressions arguments = (RListOfExpressions)PsiTreeUtil.getChildOfType((PsiElement)call, RListOfExpressions.class);
            RRegexpLiteral regex = (RRegexpLiteral)PsiTreeUtil.getChildOfType((PsiElement)arguments, RRegexpLiteral.class);
            String escapedNewValue = newValue.replaceAll("/", "\\\\/");
            RPsiElement newString = RubyElementFactory.createElementFromText((PsiElement)call, (String)("/" + escapedNewValue + "/"));
            if (regex != null) {
                regex.replace((PsiElement)newString);
                this.myPattern = null;
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/cucumber/ruby/steps/RubyStepDefinition";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getStepPattern";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setCucumberRegex";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

