/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.ruby;

import com.intellij.docker.remote.DockerCredentialsType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.remote.RubyRemoteSdkAdditionalData;

public class RubyDockerUtil {
    public static final String SERVER_PID_PATH = "/opt/project/tmp/pids/server.pid";

    public static boolean isRubyDockerSDK(@Nullable Sdk sdk) {
        if (sdk != null) {
            SdkAdditionalData sdkAdditionalData = sdk.getSdkAdditionalData();
            return RubyDockerUtil.isRubyDockerSdkAdditionalData(sdkAdditionalData);
        }
        return false;
    }

    public static boolean isRubyDockerSdkAdditionalData(@Nullable SdkAdditionalData sdkAdditionalData) {
        return RubyDockerUtil.matchesSdkAdditionalDataCredentialType(sdkAdditionalData, DockerCredentialsType.class);
    }

    public static boolean matchesSdkAdditionalDataCredentialType(SdkAdditionalData sdkAdditionalData, Class credentialsTypeClass) {
        if (sdkAdditionalData instanceof RubyRemoteSdkAdditionalData) {
            return ((RubyRemoteSdkAdditionalData)sdkAdditionalData).getRemoteConnectionType().getClass().equals(credentialsTypeClass);
        }
        return false;
    }

    public static void prepareRailsProjectToStart() {
        FileUtil.asyncDelete((File)new File(SERVER_PID_PATH));
    }
}

