/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class TreeBuilderUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.util.treeView.TreeBuilderUtil");

    public static void storePaths(@NotNull AbstractTreeBuilder treeBuilder, @NotNull DefaultMutableTreeNode root, @NotNull List<Object> pathsToExpand, @NotNull List<Object> selectionPaths, boolean storeElementsOnly) {
        if (treeBuilder == null) {
            TreeBuilderUtil.$$$reportNull$$$0(0);
        }
        if (root == null) {
            TreeBuilderUtil.$$$reportNull$$$0(1);
        }
        if (pathsToExpand == null) {
            TreeBuilderUtil.$$$reportNull$$$0(2);
        }
        if (selectionPaths == null) {
            TreeBuilderUtil.$$$reportNull$$$0(3);
        }
        if (!treeBuilder.wasRootNodeInitialized()) {
            return;
        }
        JTree tree = treeBuilder.getTree();
        if (tree != null) {
            TreeBuilderUtil.storePaths(tree, root, pathsToExpand, selectionPaths, storeElementsOnly);
        }
    }

    public static void storePaths(@NotNull JTree tree, @NotNull DefaultMutableTreeNode root, @NotNull List<Object> pathsToExpand, @NotNull List<Object> selectionPaths, boolean storeElementsOnly) {
        TreePath path2;
        if (tree == null) {
            TreeBuilderUtil.$$$reportNull$$$0(4);
        }
        if (root == null) {
            TreeBuilderUtil.$$$reportNull$$$0(5);
        }
        if (pathsToExpand == null) {
            TreeBuilderUtil.$$$reportNull$$$0(6);
        }
        if (selectionPaths == null) {
            TreeBuilderUtil.$$$reportNull$$$0(7);
        }
        if (tree.isPathSelected(path2 = new TreePath(root.getPath()))) {
            selectionPaths.add(storeElementsOnly ? ((NodeDescriptor)root.getUserObject()).getElement() : path2);
        }
        if (tree.isExpanded(path2) || root.getChildCount() == 0) {
            pathsToExpand.add(storeElementsOnly ? ((NodeDescriptor)root.getUserObject()).getElement() : path2);
            TreeBuilderUtil._storePaths(tree, root, pathsToExpand, selectionPaths, storeElementsOnly);
        }
    }

    private static void _storePaths(@NotNull JTree tree, @NotNull DefaultMutableTreeNode root, @NotNull List<Object> pathsToExpand, @NotNull List<Object> selectionPaths, boolean storeElementsOnly) {
        if (tree == null) {
            TreeBuilderUtil.$$$reportNull$$$0(8);
        }
        if (root == null) {
            TreeBuilderUtil.$$$reportNull$$$0(9);
        }
        if (pathsToExpand == null) {
            TreeBuilderUtil.$$$reportNull$$$0(10);
        }
        if (selectionPaths == null) {
            TreeBuilderUtil.$$$reportNull$$$0(11);
        }
        List<TreeNode> childNodes = TreeUtil.listChildren(root);
        for (TreeNode childNode1 : childNodes) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)childNode1;
            TreePath path2 = new TreePath(childNode.getPath());
            Object userObject = childNode.getUserObject();
            if (tree.isPathSelected(path2)) {
                if (!(userObject instanceof NodeDescriptor)) {
                    LOG.error("Node: " + childNode + "; userObject: " + userObject + " of class " + userObject.getClass());
                    return;
                }
                selectionPaths.add(storeElementsOnly ? ((NodeDescriptor)userObject).getElement() : path2);
            }
            if (!tree.isExpanded(path2) && childNode.getChildCount() != 0) continue;
            pathsToExpand.add(storeElementsOnly && userObject instanceof NodeDescriptor ? ((NodeDescriptor)userObject).getElement() : path2);
            TreeBuilderUtil._storePaths(tree, childNode, pathsToExpand, selectionPaths, storeElementsOnly);
        }
    }

    public static void restorePaths(@NotNull AbstractTreeBuilder treeBuilder, @NotNull List<Object> pathsToExpand, @NotNull List<Object> selectionPaths, boolean elementsOnly) {
        if (treeBuilder == null) {
            TreeBuilderUtil.$$$reportNull$$$0(12);
        }
        if (pathsToExpand == null) {
            TreeBuilderUtil.$$$reportNull$$$0(13);
        }
        if (selectionPaths == null) {
            TreeBuilderUtil.$$$reportNull$$$0(14);
        }
        JTree tree = treeBuilder.getTree();
        if (!elementsOnly) {
            for (Object path2 : pathsToExpand) {
                tree.expandPath((TreePath)path2);
            }
            tree.addSelectionPaths(selectionPaths.toArray(new TreePath[0]));
        } else {
            DefaultMutableTreeNode node;
            for (Object element : pathsToExpand) {
                treeBuilder.buildNodeForElement(element);
                node = treeBuilder.getNodeForElement(element);
                if (node == null) continue;
                tree.expandPath(new TreePath(node.getPath()));
            }
            for (Object element : selectionPaths) {
                node = treeBuilder.getNodeForElement(element);
                if (node == null) continue;
                DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
                tree.addSelectionPath(new TreePath(treeModel.getPathToRoot(node)));
            }
        }
    }

    static boolean isNodeOrChildSelected(@NotNull JTree tree, @NotNull DefaultMutableTreeNode node) {
        TreePath[] selectionPaths;
        if (tree == null) {
            TreeBuilderUtil.$$$reportNull$$$0(15);
        }
        if (node == null) {
            TreeBuilderUtil.$$$reportNull$$$0(16);
        }
        if ((selectionPaths = tree.getSelectionPaths()) == null || selectionPaths.length == 0) {
            return false;
        }
        TreePath path2 = new TreePath(node.getPath());
        for (TreePath selectionPath : selectionPaths) {
            if (!path2.isDescendant(selectionPath)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeBuilder";
                break;
            }
            case 1: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathsToExpand";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionPaths";
                break;
            }
            case 4: 
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/util/treeView/TreeBuilderUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "storePaths";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "_storePaths";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "restorePaths";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "isNodeOrChildSelected";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

